/*
 * Decompiled with CFR 0.152.
 */
package club.funcodes.bin2txt;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.refcodes.archetype.CliHelper;
import org.refcodes.cli.CasesCondition;
import org.refcodes.cli.CliSugar;
import org.refcodes.cli.DebugFlag;
import org.refcodes.cli.EnumOption;
import org.refcodes.cli.Example;
import org.refcodes.cli.Flag;
import org.refcodes.cli.HelpFlag;
import org.refcodes.cli.IntOption;
import org.refcodes.cli.StringOption;
import org.refcodes.cli.SysInfoFlag;
import org.refcodes.cli.VerboseFlag;
import org.refcodes.codec.BaseBuilder;
import org.refcodes.codec.BaseDecoderInputStream;
import org.refcodes.codec.BaseEncoderOutputStream;
import org.refcodes.codec.BaseMetrics;
import org.refcodes.codec.BaseMetricsConfig;
import org.refcodes.data.AsciiColorPalette;
import org.refcodes.exception.BugException;
import org.refcodes.io.LineBreakOutputStream;
import org.refcodes.logger.RuntimeLogger;
import org.refcodes.logger.RuntimeLoggerFactorySingleton;
import org.refcodes.numerical.NumericalUtility;
import org.refcodes.properties.ext.application.ApplicationProperties;
import org.refcodes.runtime.Execution;
import org.refcodes.textual.Font;
import org.refcodes.textual.FontFamily;
import org.refcodes.textual.FontStyle;
import org.refcodes.textual.VerboseTextBuilder;

public class Main {
    private static final RuntimeLogger LOGGER = RuntimeLoggerFactorySingleton.createRuntimeLogger();
    private static final String NAME = "bin2txt";
    private static final String TITLE = ":::" + "bin2txt".toUpperCase() + ":::";
    private static final String DEFAULT_CONFIG = "bin2txt.ini";
    private static final String LICENSE_NOTE = "You may choose between the LGPL v3.0 or later and the Apache License v2.0 when using this software";
    private static final String COPYRIGHT = "Copyright (c) by CLUB.FUNCODES | See [https://www.metacodes.pro/manpages/bin2txt_manpage]";
    private static final char[] BANNER_PALETTE = AsciiColorPalette.MAX_LEVEL_GRAY.getPalette();
    private static final Font BANNER_FONT = new Font(FontFamily.DIALOG, FontStyle.BOLD);
    private static final String DESCRIPTION = "Encoding and decoding tool for BASE64 and related encodings/decodings from/to ASCII to/from binary (see [https://www.metacodes.pro/manpages/bin2txt_manpage]).";
    private static final String BYTES_PROPERTY = "bytes";
    private static final String DECODE_PROPERTY = "decode";
    private static final String ENCODE_PROPERTY = "encode";
    private static final String TEXT_PROPERTY = "text";
    private static final String OUTPUTFILE_PROPERTY = "outputFile";
    private static final String INPUTFILE_PROPERTY = "inputFile";
    private static final String ENCODING_PROPERTY = "encoding";
    private static final String HEX_PROPERTY = "hex";
    private static final String LINE_WIDTH_PROPERTY = "lineWidth";

    public static void main(String[] args) {
        block18: {
            EnumOption<BaseMetricsConfig> theEncodingArg = CliSugar.enumOption(ENCODING_PROPERTY, BaseMetricsConfig.class, ENCODING_PROPERTY, "The BASE (e.g. BASE64) encoding/decoding to be applied for handling encoded data: " + VerboseTextBuilder.asString(BaseMetricsConfig.values()));
            Flag theHexFlag = CliSugar.flag(HEX_PROPERTY, HEX_PROPERTY, "Use a hexadecimal representation of (binary) output.");
            StringOption theInputFileArg = CliSugar.stringOption(Character.valueOf('i'), "input-file", INPUTFILE_PROPERTY, "The input file which to process from.");
            StringOption theOutputFileArg = CliSugar.stringOption(Character.valueOf('o'), "output-file", OUTPUTFILE_PROPERTY, "The output file which to process to.");
            StringOption theTextArg = CliSugar.stringOption(Character.valueOf('t'), TEXT_PROPERTY, TEXT_PROPERTY, "The text message which to process.");
            StringOption theBytesArg = CliSugar.stringOption(Character.valueOf('b'), BYTES_PROPERTY, BYTES_PROPERTY, "The message in bytes (e.g. \"127, 128, 0x10, 0xFF\") which to process.");
            IntOption theLineWidthArg = CliSugar.intOption("line-width", LINE_WIDTH_PROPERTY, "The line width when outputting text.");
            Flag theEncodeFlag = CliSugar.flag(Character.valueOf('e'), ENCODE_PROPERTY, ENCODE_PROPERTY, "Encodes the given message.");
            Flag theDecodeFlag = CliSugar.flag(Character.valueOf('d'), DECODE_PROPERTY, DECODE_PROPERTY, "Decodes the given message.");
            DebugFlag theDebugFlag = CliSugar.debugFlag(false);
            VerboseFlag theVerboseFlag = CliSugar.verboseFlag();
            SysInfoFlag theSysInfoFlag = CliSugar.sysInfoFlag(false);
            HelpFlag theHelpFlag = CliSugar.helpFlag();
            CasesCondition theArgsSyntax = CliSugar.cases(CliSugar.and(CliSugar.xor(theEncodeFlag, theDecodeFlag), CliSugar.any(CliSugar.and(CliSugar.xor(theTextArg, theBytesArg), CliSugar.any(theHexFlag, theEncodingArg, theVerboseFlag, theDebugFlag)))), CliSugar.and(CliSugar.xor(CliSugar.and(theEncodeFlag, CliSugar.any(theLineWidthArg)), theDecodeFlag), theInputFileArg, theOutputFileArg, CliSugar.any(theEncodingArg, theVerboseFlag, theDebugFlag)), CliSugar.and(CliSugar.xor(CliSugar.and(theEncodeFlag, CliSugar.any(theLineWidthArg)), theDecodeFlag), CliSugar.xor(theInputFileArg, CliSugar.and(theOutputFileArg, CliSugar.any(theVerboseFlag, theDebugFlag))), CliSugar.any(theEncodingArg)), CliSugar.xor(theHelpFlag, CliSugar.and(theSysInfoFlag, CliSugar.any(theVerboseFlag))));
            Example[] theExamples = CliSugar.examples(CliSugar.example("Encode a text message", theEncodeFlag, theTextArg, theVerboseFlag), CliSugar.example("Decode a text message", theDecodeFlag, theTextArg, theVerboseFlag), CliSugar.example("Encode a message in bytes", theEncodeFlag, theBytesArg, theVerboseFlag), CliSugar.example("Decode a message in bytes", theDecodeFlag, theBytesArg, theVerboseFlag), CliSugar.example("Encode input file to output file", theEncodeFlag, theInputFileArg, theOutputFileArg, theVerboseFlag), CliSugar.example("Decode input file to output file", theDecodeFlag, theInputFileArg, theOutputFileArg, theVerboseFlag), CliSugar.example("Encode STDIN file to output file", theEncodeFlag, theOutputFileArg), CliSugar.example("Decode input file to STDOUT", theDecodeFlag, theInputFileArg), CliSugar.example("Encode STDIN to STDOUT (BASE64 encoding)", theEncodeFlag), CliSugar.example("Decode STDIN (BASE64 encoding) to STDOUT", theDecodeFlag), CliSugar.example("To show the help text", theHelpFlag), CliSugar.example("To print the system info", theSysInfoFlag));
            CliHelper theCliHelper = ((CliHelper.Builder)((CliHelper.Builder)((CliHelper.Builder)((CliHelper.Builder)((CliHelper.Builder)((CliHelper.Builder)((CliHelper.Builder)((CliHelper.Builder)((CliHelper.Builder)((CliHelper.Builder)((CliHelper.Builder)((CliHelper.Builder)((CliHelper.Builder)CliHelper.builder().withArgs(args)).withArgsSyntax(theArgsSyntax)).withExamples(theExamples)).withFilePath(DEFAULT_CONFIG)).withResourceClass((Class)Main.class)).withName(NAME)).withTitle(TITLE)).withDescription(DESCRIPTION)).withLicense(LICENSE_NOTE)).withCopyright(COPYRIGHT)).withBannerFont(BANNER_FONT)).withBannerFontPalette(BANNER_PALETTE)).withLogger(LOGGER)).build();
            ApplicationProperties theArgsProperties = theCliHelper.getApplicationProperties();
            boolean isVerbose = theCliHelper.isVerbose();
            try {
                String theText = (String)theArgsProperties.get((Object)theTextArg);
                byte[] theBytes = theArgsProperties.get((Object)theBytesArg) != null ? NumericalUtility.toBytes((String)theArgsProperties.get((Object)theBytesArg)) : null;
                String theInputFilePath = (String)theArgsProperties.get((Object)theInputFileArg);
                String theOutputFilePath = (String)theArgsProperties.get((Object)theOutputFileArg);
                boolean isHex = theArgsProperties.getBoolean((Object)theHexFlag);
                int theLineWidth = theArgsProperties.getIntOr(theLineWidthArg, (Integer)-1);
                boolean isEncode = theArgsProperties.getBoolean((Object)theEncodeFlag);
                boolean isDecode = theArgsProperties.getBoolean((Object)theDecodeFlag);
                BaseMetricsConfig theBaseMetrics = theArgsProperties.getEnumOr(BaseMetricsConfig.class, theEncodingArg, BaseMetricsConfig.BASE64);
                if (isVerbose) {
                    if (theText != null && theText.length() != 0) {
                        LOGGER.info("Text = " + theText);
                    }
                    if (theBytes != null && theBytes.length != 0) {
                        LOGGER.info("Bytes = { " + NumericalUtility.toHexString(", ", theBytes) + " }");
                    }
                    if (theBaseMetrics != null) {
                        LOGGER.info("Encoding = " + String.valueOf(theBaseMetrics));
                    }
                    if (theLineWidth != -1) {
                        LOGGER.info("Line width = " + theLineWidth);
                    }
                    LOGGER.info("Operation = " + (isEncode ? "Encoding" : (isDecode ? "Decoding" : "?")));
                }
                if (theText != null && theText.length() != 0 || theBytes != null && theBytes.length != 0) {
                    if (isEncode) {
                        Main.encode(theText, theBytes, theBaseMetrics, isHex, isVerbose);
                        break block18;
                    }
                    if (isDecode) {
                        Main.decode(theText, theBytes, theBaseMetrics, isHex, isVerbose);
                        break block18;
                    }
                    throw new BugException("We encountered a bug, none argument was processed.");
                }
                InputStream theInputStream = Execution.toBootstrapStandardIn();
                OutputStream theOutputStream = Execution.toBootstrapStandardOut();
                if (theInputFilePath != null && theInputFilePath.length() != 0) {
                    File theInputFile = new File(theInputFilePath);
                    if (isVerbose) {
                        LOGGER.info("Input file = \"" + theInputFilePath + "\" (<" + theInputFile.getAbsolutePath() + ">)");
                    }
                    if (!theInputFile.exists() || !theInputFile.isFile()) {
                        throw new FileNotFoundException("No file \"" + theInputFilePath + "\" (<" + theInputFile.getAbsolutePath() + ">) found!");
                    }
                    theInputStream = new FileInputStream(theInputFile);
                }
                if (theOutputFilePath != null && theOutputFilePath.length() != 0) {
                    File theOutputFile = new File(theOutputFilePath);
                    if (isVerbose) {
                        LOGGER.info("Output file = \"" + theOutputFilePath + "\" (<" + theOutputFile.getAbsolutePath() + ">)");
                    }
                    theOutputStream = new FileOutputStream(theOutputFile);
                }
                if (isEncode) {
                    if (theLineWidth != -1) {
                        theOutputStream = new LineBreakOutputStream(theOutputStream, theLineWidth);
                    }
                    theOutputStream = new BaseEncoderOutputStream(theOutputStream, (BaseMetrics)theBaseMetrics);
                    Main.encode(theInputStream, theOutputStream, isVerbose);
                    break block18;
                }
                if (isDecode) {
                    theInputStream = new BaseDecoderInputStream(theInputStream, (BaseMetrics)theBaseMetrics);
                    Main.decode(theInputStream, theOutputStream, isVerbose);
                    break block18;
                }
                throw new BugException("We encountered a bug, none argument was processed.");
            }
            catch (Throwable e) {
                theCliHelper.exitOnException(e);
            }
        }
    }

    private static void encode(InputStream aInputStream, OutputStream aOutputStream, boolean aIsVerbose) throws IOException {
        try (BufferedInputStream theInputStream = new BufferedInputStream(aInputStream);
             BufferedOutputStream theOutputStream = new BufferedOutputStream(aOutputStream);){
            ((InputStream)theInputStream).transferTo(theOutputStream);
        }
    }

    private static void decode(InputStream aInputStream, OutputStream aOutputStream, boolean aIsVerbose) throws IOException {
        try (BufferedInputStream theInputStream = new BufferedInputStream(aInputStream);
             BufferedOutputStream theOutputStream = new BufferedOutputStream(aOutputStream);){
            ((InputStream)theInputStream).transferTo(theOutputStream);
        }
    }

    private static void encode(String aText, byte[] aBytes, BaseMetrics aBaseMetrics, boolean isHex, boolean isVerbose) {
        String theResult;
        BaseBuilder theBaseBuilder = new BaseBuilder().withBaseMetrics(aBaseMetrics);
        byte[] theDecodedData = aBytes != null ? aBytes : aText.getBytes();
        String string = theResult = isHex ? "{ " + NumericalUtility.toHexString(", ", theBaseBuilder.toEncodedText(theDecodedData).getBytes()) + " }" : theBaseBuilder.toEncodedText(theDecodedData);
        if (isVerbose) {
            LOGGER.info("Encoded := " + theResult);
        } else {
            System.out.println(theResult);
        }
    }

    private static void decode(String aText, byte[] aBytes, BaseMetrics aBaseMetrics, boolean isHex, boolean isVerbose) {
        Object theResult;
        BaseBuilder theBaseBuilder = new BaseBuilder().withBaseMetrics(aBaseMetrics);
        byte[] theDecoded = theBaseBuilder.toDecodedData(aBytes != null ? new String(aBytes) : aText);
        Object object = theResult = isHex ? "{ " + NumericalUtility.toHexString(", ", theDecoded) + " }" : new String(theDecoded);
        if (isVerbose) {
            LOGGER.info("Decoded := " + (String)theResult);
        } else {
            System.out.println((String)theResult);
        }
    }
}

