/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.web;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import org.refcodes.exception.MarshalException;
import org.refcodes.exception.UnmarshalException;
import org.refcodes.struct.TypeUtility;
import org.refcodes.struct.ext.factory.DocumentOptions;
import org.refcodes.web.MediaType;
import org.refcodes.web.MediaTypeFactory;

public class YamlMediaTypeFactory
implements MediaTypeFactory {
    private static final MediaType[] MEDIA_TYPES = new MediaType[]{MediaType.APPLICATION_YAML, MediaType.TEXT_YAML};
    private final ObjectMapper _mapper = new ObjectMapper(new YAMLFactory());

    public YamlMediaTypeFactory() {
        this._mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    }

    @Override
    public MediaType[] getMediaTypes() {
        return MEDIA_TYPES;
    }

    @Override
    public String toMarshaled(Object aUnmarshaled, DocumentOptions aOptions) throws MarshalException {
        try {
            return this._mapper.writeValueAsString(aUnmarshaled);
        }
        catch (Exception e) {
            throw new MarshalException("A problem occurred marshaling an object of type <" + aUnmarshaled.getClass().getName() + ">.", e);
        }
    }

    @Override
    public <T> T toUnmarshaled(String aHttpBody, Class<T> aType, DocumentOptions aOptions) throws UnmarshalException {
        try {
            if (aHttpBody == null) {
                return null;
            }
            if (aHttpBody.isEmpty()) {
                return aType.getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            return this._mapper.readValue(aHttpBody, aType);
        }
        catch (JsonParseException | JsonMappingException e) {
            if (aType.isArray()) {
                try {
                    Map theMap = this._mapper.readValue(aHttpBody, Map.class);
                    return TypeUtility.toArray(theMap, aType);
                }
                catch (JsonProcessingException e2) {
                    throw new UnmarshalException("Unable to unmarshal the HTTP body \"" + aHttpBody + "\" to type  <" + aType.getName() + "> at column <" + e.getLocation().getColumnNr() + ">!", e);
                }
            }
            if (Map.class.isAssignableFrom(aType)) {
                try {
                    Map theMap = Map.class.equals(aType) ? new HashMap() : (Map)aType.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                    Object[] theArray = this._mapper.readValue(aHttpBody, Object[].class);
                    if (theArray != null) {
                        for (int i = 0; i < theArray.length; ++i) {
                            if (theArray[i] == null) continue;
                            theMap.put(Integer.toString(i), theArray[i]);
                        }
                    }
                    return (T)theMap;
                }
                catch (JsonProcessingException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e2) {
                    throw new UnmarshalException("Unable to unmarshal the HTTP body \"" + aHttpBody + "\" to type  <" + aType.getName() + "> at column <" + e.getLocation().getColumnNr() + ">!", e);
                }
            }
            throw new UnmarshalException("Unable to unmarshal the HTTP body \"" + aHttpBody + "\" to type  <" + aType.getName() + "> at column <" + e.getLocation().getColumnNr() + ">!", e);
        }
        catch (Exception e) {
            throw new UnmarshalException("Unable to unmarshal the HTTP body \"" + aHttpBody + "\" to type  <" + aType.getName() + ">!", e);
        }
    }
}

