/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.web;

import java.io.InputStream;
import java.util.Collection;
import java.util.Map;
import org.refcodes.exception.MarshalException;
import org.refcodes.exception.UnmarshalException;
import org.refcodes.struct.CanonicalTable;
import org.refcodes.struct.MapCanonicalTable;
import org.refcodes.struct.SimpleType;
import org.refcodes.struct.ext.factory.DocumentOptions;
import org.refcodes.struct.ext.factory.XmlCanonicalTableFactorySingleton;
import org.refcodes.web.HttpBodyTable;
import org.refcodes.web.MediaType;
import org.refcodes.web.MediaTypeFactory;

public class XmlMediaTypeFactory
implements MediaTypeFactory {
    private static final MediaType[] MEDIA_TYPES = new MediaType[]{MediaType.APPLICATION_XML, MediaType.TEXT_XML, MediaType.APPLICATION_HAL_XML, MediaType.APPLICATION_SCHEMA_XML};

    @Override
    public MediaType[] getMediaTypes() {
        return MEDIA_TYPES;
    }

    @Override
    public <UN> String toMarshaled(UN aUnmarshaled, DocumentOptions aOptions) throws MarshalException {
        MapCanonicalTable theCanoniocalMap = new MapCanonicalTable(aUnmarshaled);
        if (aUnmarshaled.getClass().isArray()) {
            theCanoniocalMap = new MapCanonicalTable(theCanoniocalMap.retrieveTo("array", "value"));
            theCanoniocalMap.put(new String[]{"array", TYPE_ANNOTATION}, aUnmarshaled.getClass().getName());
        } else if (Collection.class.isAssignableFrom(aUnmarshaled.getClass())) {
            theCanoniocalMap = new MapCanonicalTable(theCanoniocalMap.retrieveTo("collection", "value"));
            theCanoniocalMap.put(new String[]{"collection", TYPE_ANNOTATION}, aUnmarshaled.getClass().getName());
        } else if (Map.class.isAssignableFrom(aUnmarshaled.getClass()) && theCanoniocalMap.dirs().size() == 0) {
            theCanoniocalMap = new MapCanonicalTable(theCanoniocalMap.retrieveTo("map", "value"));
            theCanoniocalMap.put(new String[]{"map", TYPE_ANNOTATION}, aUnmarshaled.getClass().getName());
        } else if (theCanoniocalMap.children().size() > 1 || SimpleType.isSimpleType(aUnmarshaled.getClass())) {
            String theRootElement;
            String string = theRootElement = aOptions != null ? aOptions.getRootElement() : null;
            if (theRootElement == null || theRootElement.isEmpty()) {
                theRootElement = "value";
            }
            theCanoniocalMap = new MapCanonicalTable(theCanoniocalMap.retrieveTo(theRootElement));
        }
        return XmlCanonicalTableFactorySingleton.getInstance().toMarshaled(theCanoniocalMap, aOptions);
    }

    @Override
    public <T> T toUnmarshaled(String aHttpBody, Class<T> aType, DocumentOptions aOptions) throws UnmarshalException {
        CanonicalTable theCanoniocalMap = XmlCanonicalTableFactorySingleton.getInstance().toUnmarshaled(aHttpBody, aOptions);
        if (aType.isArray() && theCanoniocalMap.isDir("array") && theCanoniocalMap.dirs().size() == 1 && theCanoniocalMap.leaves().size() == 0 && theCanoniocalMap.isDir("array", "value") && theCanoniocalMap.dirs("array").size() == 1) {
            theCanoniocalMap = theCanoniocalMap.retrieveFrom("array", "value");
        }
        if (aType.isArray() && theCanoniocalMap.isDir("map") && theCanoniocalMap.dirs().size() == 1 && theCanoniocalMap.leaves().size() == 0 && theCanoniocalMap.isDir("map", "value") && theCanoniocalMap.dirs("map").size() == 1) {
            theCanoniocalMap = theCanoniocalMap.retrieveFrom("map", "value");
        } else if (Collection.class.isAssignableFrom(aType) && theCanoniocalMap.dirs().size() == 1 && theCanoniocalMap.leaves().size() == 0 && theCanoniocalMap.isDir("collection", "value") && theCanoniocalMap.dirs("collection").size() == 1) {
            theCanoniocalMap = theCanoniocalMap.retrieveFrom("collection", "value");
        } else if (Map.class.isAssignableFrom(aType) && theCanoniocalMap.dirs().size() == 1 && theCanoniocalMap.leaves().size() == 0 && theCanoniocalMap.isDir("map", "value") && theCanoniocalMap.dirs("map").size() == 1) {
            theCanoniocalMap = theCanoniocalMap.retrieveFrom("map", "value");
        } else if (Map.class.isAssignableFrom(aType) && theCanoniocalMap.dirs().size() == 1 && theCanoniocalMap.leaves().size() == 0 && theCanoniocalMap.isDir("array", "value") && theCanoniocalMap.dirs("array").size() == 1) {
            theCanoniocalMap = theCanoniocalMap.retrieveFrom("array", "value");
        } else {
            if (aType.isAssignableFrom(HttpBodyTable.class)) {
                return (T)new HttpBodyTable((Object)theCanoniocalMap);
            }
            if (theCanoniocalMap.hasValue("value") && theCanoniocalMap.leaves().size() == 1 && theCanoniocalMap.dirs().size() == 0 || theCanoniocalMap.isDir("value") && theCanoniocalMap.leaves().size() == 0 && theCanoniocalMap.dirs().size() == 1) {
                theCanoniocalMap = theCanoniocalMap.retrieveFrom("value");
            }
        }
        return theCanoniocalMap.toType(aType);
    }

    @Override
    public Object fromMarshaled(InputStream aMarshaled, DocumentOptions aOptions, Class<?> ... aTypes) throws UnmarshalException {
        CanonicalTable theBuilder = XmlCanonicalTableFactorySingleton.getInstance().fromMarshaled(aMarshaled, aOptions);
        for (Class<?> eType : aTypes) {
            try {
                return theBuilder.toType(eType);
            }
            catch (Exception exception) {
            }
        }
        throw new UnmarshalException("Unable to unmarshal the input stream to fit into one of the provided types.");
    }
}

