/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.web;

import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import org.refcodes.data.Encoding;
import org.refcodes.exception.UnmarshalException;
import org.refcodes.io.InputStreamStringBuilder;
import org.refcodes.struct.ext.factory.DocumentOptions;
import org.refcodes.textual.VerboseTextBuilder;
import org.refcodes.web.AbstractHttpRequest;
import org.refcodes.web.BadRequestException;
import org.refcodes.web.ContentType;
import org.refcodes.web.HeaderField;
import org.refcodes.web.HttpBodyAccessor;
import org.refcodes.web.HttpBodyTable;
import org.refcodes.web.HttpInputStreamAccessor;
import org.refcodes.web.HttpMethod;
import org.refcodes.web.MediaType;
import org.refcodes.web.MediaTypeFactory;
import org.refcodes.web.MediaTypeFactoryLookup;
import org.refcodes.web.RequestHeaderFields;
import org.refcodes.web.Url;

public class HttpServerRequest
extends AbstractHttpRequest
implements HttpBodyAccessor,
HttpInputStreamAccessor {
    protected MediaTypeFactoryLookup _mediaTypeFactoryLookup;
    private String _httpBody = null;
    private InputStream _httpInputStream = null;

    public HttpServerRequest(HttpMethod aHttpMethod, Url aUrl, RequestHeaderFields aHeaderFields, InputStream aHttpInputStream, MediaTypeFactoryLookup aMediaTypeFactoryLookup) {
        super(aHttpMethod, aUrl, aHeaderFields);
        this._httpInputStream = aHttpInputStream;
        this._mediaTypeFactoryLookup = aMediaTypeFactoryLookup;
    }

    public HttpBodyTable getRequest() throws BadRequestException {
        return this.getRequest(HttpBodyTable.class);
    }

    public <REQ> REQ getRequest(Class<REQ> aRequestType) throws BadRequestException {
        if (aRequestType.isAssignableFrom(InputStream.class)) {
            return (REQ)this._httpInputStream;
        }
        String theHttpBody = this.getHttpBody();
        if (theHttpBody == null) {
            return null;
        }
        if (aRequestType.isAssignableFrom(String.class)) {
            return (REQ)theHttpBody;
        }
        DocumentOptions.Builder theOptionsBuilder = DocumentOptions.builder();
        ContentType theContentType = this.getHeaderFields().getContentType();
        if (theContentType == null && this.getHeaderFields().getAcceptTypes() != null && this.getHeaderFields().getAcceptTypes().size() != 0) {
            for (ContentType eContentType : this.getHeaderFields().getAcceptTypes()) {
                if (!this._mediaTypeFactoryLookup.hasMediaTypeFactory(eContentType.getMediaType())) continue;
                theContentType = eContentType;
                break;
            }
        }
        MediaTypeFactory theFactory = null;
        if (theContentType == null) {
            MediaType[] theMediaTypes = this._mediaTypeFactoryLookup.getFactoryMediaTypes();
            if (theMediaTypes != null && theMediaTypes.length != 0) {
                theFactory = this._mediaTypeFactoryLookup.toMediaTypeFactory(theMediaTypes[0]);
            }
        } else {
            theFactory = this._mediaTypeFactoryLookup.toMediaTypeFactory(theContentType.getMediaType());
            String theCharset = theContentType.getCharsetParametrer();
            if (theCharset != null) {
                theOptionsBuilder.withEncoding(theCharset);
            }
        }
        DocumentOptions theOptions = theOptionsBuilder.build();
        if (theFactory == null) {
            throw new BadRequestException("No Media-Type factory found (added) for Media-Type <" + String.valueOf(theContentType) + "> (raw requested Media-Type is <" + String.valueOf(this.getHeaderFields().get(HeaderField.CONTENT_TYPE)) + ">)");
        }
        try {
            if (HttpBodyTable.class.isAssignableFrom(aRequestType)) {
                if (theHttpBody.isEmpty()) {
                    return (REQ)new HttpBodyTable();
                }
                Map theUnmarshaled = theFactory.toUnmarshaled(theHttpBody, Map.class, theOptions);
                return (REQ)new HttpBodyTable((Object)theUnmarshaled);
            }
            return theFactory.toUnmarshaled(theHttpBody, aRequestType, theOptions);
        }
        catch (UnmarshalException e) {
            throw new BadRequestException("Unable to unmarshal request body with Media-Type <" + new VerboseTextBuilder().toString(theFactory.getMediaTypes()) + "> from URL <" + this.getUrl().toHttpUrl() + "> with HTTP-Method <" + String.valueOf((Object)this.getHttpMethod()) + "> and request body <" + this.getHttpBody() + ">.", (Throwable)e);
        }
    }

    @Override
    public InputStream getHttpInputStream() {
        return this._httpInputStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getHttpBody() {
        if (this._httpBody == null) {
            HttpServerRequest httpServerRequest = this;
            synchronized (httpServerRequest) {
                if (this._httpBody == null) {
                    try {
                        ContentType theContentType = this.getHeaderFields().getContentType();
                        String theEncoding = theContentType != null && theContentType.getCharsetParametrer() != null ? theContentType.getCharsetParametrer() : Encoding.UTF_8.getCode();
                        this._httpBody = new InputStreamStringBuilder().toString(this._httpInputStream, theEncoding);
                    }
                    catch (IOException e) {
                        this._httpBody = e.getMessage();
                    }
                }
            }
        }
        return this._httpBody;
    }

    public String toString() {
        return this.getClass().getName() + " [_httpMethod=" + String.valueOf((Object)this._httpMethod) + ", _url=" + String.valueOf(this._url) + "]";
    }
}

