/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.web;

import java.util.Objects;
import org.refcodes.web.AuthType;
import org.refcodes.web.AuthTypeCredentials;
import org.refcodes.web.ForbiddenException;
import org.refcodes.web.TokenCredentials;

public class BearerAuthCredentials
implements TokenCredentials,
AuthTypeCredentials<BearerAuthCredentials, TokenCredentials> {
    public static final char DELIMITER_AUTH_TYPE = ' ';
    private String _token;

    public BearerAuthCredentials() {
    }

    public BearerAuthCredentials(String aToken) {
        this._token = aToken;
    }

    @Override
    public void validate(TokenCredentials aCredentials) throws ForbiddenException {
        if (!this.isValid(aCredentials)) {
            throw new ForbiddenException("Access denied as of unsuccessfull authentification!");
        }
    }

    @Override
    public void validate(String aToken) throws ForbiddenException {
        if (!this.isValid(aToken)) {
            throw new ForbiddenException("Access denied as of unsuccessfull authentification!");
        }
    }

    @Override
    public BearerAuthCredentials withHttpAuthorization(String aHttpAuthorization) {
        this.fromHttpAuthorization(aHttpAuthorization);
        return this;
    }

    @Override
    public AuthType getAuthType() {
        return AuthType.BEARER;
    }

    @Override
    public String getToken() {
        return this._token;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this._token == null ? 0 : this._token.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BearerAuthCredentials other = (BearerAuthCredentials)obj;
        return !(this._token == null ? other._token != null : !this._token.equals(other._token));
    }

    public String toString() {
        return "<...>";
    }

    @Override
    public void fromHttpAuthorization(String aHttpAuthorization) {
        Objects.requireNonNull(aHttpAuthorization, "The HTTP-authorization argument must not be null!");
        int theMarker = aHttpAuthorization.indexOf(32);
        if (theMarker == -1 || !aHttpAuthorization.substring(0, theMarker).equalsIgnoreCase(AuthType.BEARER.getName())) {
            throw new IllegalArgumentException("The provided HTTP authorization value does not conform to the format expected for <" + AuthType.BEARER.getName() + "> authentication.");
        }
        this._token = aHttpAuthorization.substring(theMarker + 1);
    }

    @Override
    public String toHttpAuthorization() {
        return this.getAuthType().getName() + " " + this.getToken();
    }
}

