/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.textual;

import org.refcodes.data.AnsiEscapeCode;
import org.refcodes.data.Literal;
import org.refcodes.data.MoreText;
import org.refcodes.mixin.ColumnWidthAccessor;
import org.refcodes.runtime.Terminal;
import org.refcodes.textual.AbstractText;
import org.refcodes.textual.MoreTextMode;

public class MoreTextBuilder
extends AbstractText<MoreTextBuilder>
implements ColumnWidthAccessor.ColumnWidthProperty,
ColumnWidthAccessor.ColumnWidthBuilder<MoreTextBuilder> {
    private int _columnWidth = Terminal.toHeuristicWidth();
    private MoreTextMode _moreTextMode = MoreTextMode.RIGHT;
    private String _moreText = "" + MoreText.MORE_TEXT_BEFORE.getChar();

    public String getMoreText() {
        return this._moreText;
    }

    public void setMoreText(String aMoreText) {
        this._moreText = aMoreText;
    }

    @Override
    public int getColumnWidth() {
        return this._columnWidth;
    }

    @Override
    public void setColumnWidth(int aColumnWidth) {
        this._columnWidth = aColumnWidth;
    }

    @Override
    public MoreTextBuilder withColumnWidth(int aColumnWidth) {
        this._columnWidth = aColumnWidth;
        return this;
    }

    public MoreTextMode getMoreTextMode() {
        return this._moreTextMode;
    }

    public void setMoreTextMode(MoreTextMode aMoreTextMode) {
        this._moreTextMode = aMoreTextMode;
    }

    @Override
    public String[] toStrings() {
        return MoreTextBuilder.asMoreText(this.getText(), this._columnWidth, this._moreText, this._moreTextMode);
    }

    @Override
    public String[] toStrings(String ... aText) {
        return MoreTextBuilder.asMoreText(aText, this._columnWidth, this._moreText, this._moreTextMode);
    }

    public MoreTextBuilder withMoreTextMode(MoreTextMode aMoreTextMode) {
        this.setMoreTextMode(aMoreTextMode);
        return this;
    }

    public MoreTextBuilder withMoreText(String aMoreText) {
        this.setMoreText(aMoreText);
        return this;
    }

    @Override
    public String toString() {
        return super.toString();
    }

    public static String[] asMoreText(String[] aText, int aLength, String aMore, MoreTextMode aMoreTextMode) {
        return MoreTextBuilder.asMoreText(aText, aLength, aMore, aMoreTextMode, false);
    }

    public static String[] asMoreText(String[] aText, int aLength, String aMore, MoreTextMode aMoreTextMode, boolean hasAnsiEscapeCodes) {
        String[] theResult = new String[aText.length];
        for (int i = 0; i < aText.length; ++i) {
            theResult[i] = MoreTextBuilder.asMoreText(aText[i], aLength, aMore, aMoreTextMode, hasAnsiEscapeCodes);
        }
        return theResult;
    }

    public static String asMoreText(String aText, int aLength, String aMore, MoreTextMode aMoreTextMode) {
        return MoreTextBuilder.asMoreText(aText, aLength, aMore, aMoreTextMode, false);
    }

    public static String asMoreText(String aText, int aLength, String aMore, MoreTextMode aMoreTextMode, boolean hasAnsiEscapeCodes) {
        switch (aMoreTextMode) {
            case LEFT: {
                return MoreTextBuilder.toMoreLeft(aText, aLength, aMore, hasAnsiEscapeCodes);
            }
            case CENTER: {
                return MoreTextBuilder.toMoreCenter(aText, aLength, aMore, hasAnsiEscapeCodes);
            }
            case RIGHT: {
                return MoreTextBuilder.toMoreRight(aText, aLength, aMore, hasAnsiEscapeCodes);
            }
        }
        return aText;
    }

    private static String toMoreLeft(String aText, int aLength, String aMore, boolean hasAnsiEscapeCodes) {
        if (aText == null) {
            aText = Literal.NULL.getValue();
        }
        if (MoreTextBuilder.toLength(aMore, hasAnsiEscapeCodes) > aLength && MoreTextBuilder.toLength(aText, hasAnsiEscapeCodes) > aLength) {
            return aMore.substring(0, aLength);
        }
        if (MoreTextBuilder.toLength(aText, hasAnsiEscapeCodes) <= aLength) {
            return aText;
        }
        aText = aText.substring(MoreTextBuilder.toLength(aText, hasAnsiEscapeCodes) - aLength + MoreTextBuilder.toLength(aMore, hasAnsiEscapeCodes));
        return aMore + aText;
    }

    private static String toMoreRight(String aText, int aLength, String aMore, boolean hasAnsiEscapeCodes) {
        if (MoreTextBuilder.toLength(aMore, hasAnsiEscapeCodes) > aLength && MoreTextBuilder.toLength(aText, hasAnsiEscapeCodes) > aLength) {
            return aMore.substring(0, aLength);
        }
        if (MoreTextBuilder.toLength(aText, hasAnsiEscapeCodes) <= aLength) {
            return aText;
        }
        aText = aText.substring(0, aLength - MoreTextBuilder.toLength(aMore, hasAnsiEscapeCodes));
        return aText + aMore;
    }

    private static String toMoreCenter(String aText, int aLength, String aMore, boolean hasAnsiEscapeCodes) {
        if (MoreTextBuilder.toLength(aMore, hasAnsiEscapeCodes) > aLength && MoreTextBuilder.toLength(aText, hasAnsiEscapeCodes) > aLength) {
            return aMore.substring(0, aLength);
        }
        if (MoreTextBuilder.toLength(aText, hasAnsiEscapeCodes) <= aLength) {
            return aText;
        }
        if (MoreTextBuilder.toLength(aText = aText.substring(0, MoreTextBuilder.toLength(aText, hasAnsiEscapeCodes) - MoreTextBuilder.toLength(aMore, hasAnsiEscapeCodes)), hasAnsiEscapeCodes) - MoreTextBuilder.toLength(aMore, hasAnsiEscapeCodes) == aLength) {
            return aText + aMore;
        }
        while (MoreTextBuilder.toLength(aText, hasAnsiEscapeCodes) + MoreTextBuilder.toLength(aMore, hasAnsiEscapeCodes) * 2 > aLength) {
            if (MoreTextBuilder.toLength(aText = aText.substring(MoreTextBuilder.toLength(aMore, hasAnsiEscapeCodes)), hasAnsiEscapeCodes) + MoreTextBuilder.toLength(aMore, hasAnsiEscapeCodes) * 2 == aLength) {
                return aMore + aText + aMore;
            }
            if (MoreTextBuilder.toLength(aText = aText.substring(0, MoreTextBuilder.toLength(aText, hasAnsiEscapeCodes) - MoreTextBuilder.toLength(aMore, hasAnsiEscapeCodes)), hasAnsiEscapeCodes) + MoreTextBuilder.toLength(aMore, hasAnsiEscapeCodes) * 2 != aLength) continue;
            return aMore + aText + aMore;
        }
        return aMore + aText + aMore;
    }

    private static int toLength(String aText, boolean hasAnsiEscapeCodes) {
        if (hasAnsiEscapeCodes) {
            return AnsiEscapeCode.toUnescapedLength(aText);
        }
        return aText.length();
    }
}

