/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.struct.ext.factory;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Stack;
import org.refcodes.data.Delimiter;
import org.refcodes.exception.MarshalException;
import org.refcodes.exception.UnmarshalException;
import org.refcodes.struct.CanonicalTable;
import org.refcodes.struct.ImmutableCanonicalTable;
import org.refcodes.struct.ImmutablePathTable;
import org.refcodes.struct.MapCanonicalTable;
import org.refcodes.struct.PathComparator;
import org.refcodes.struct.PropertyImpl;
import org.refcodes.struct.ext.factory.AbstractCanonicalTableFactory;
import org.refcodes.struct.ext.factory.DocumentOptions;

public class TomlCanonicalTableFactory
extends AbstractCanonicalTableFactory {
    public static final char SECTION_BEGIN = '[';
    public static final char SECTION_END = ']';
    public static final char[] COMMENTS = new char[]{'#', ';'};
    private static final String RESET_SECTION = "---";
    public static final char[] DELIMITERS = new char[]{'/', '.'};

    @Override
    public CanonicalTable fromMarshaled(InputStream aMarshaled, DocumentOptions aOptions) throws UnmarshalException {
        MapCanonicalTable mapCanonicalTable;
        char[] cArray;
        char theDelimiter;
        char c = theDelimiter = aOptions != null ? aOptions.getDelimiterOr(ImmutablePathTable.DELIMITER) : ImmutablePathTable.DELIMITER;
        if (aOptions != null) {
            cArray = aOptions.getDelimitersOr(new char[]{ImmutablePathTable.DELIMITER});
        } else {
            char[] cArray2 = new char[1];
            cArray = cArray2;
            cArray2[0] = ImmutablePathTable.DELIMITER;
        }
        char[] theSupportedDelimiters = cArray;
        BufferedReader theReader = new BufferedReader(new InputStreamReader(aMarshaled));
        try {
            Stack<String> theSections = new Stack<String>();
            int eLineNum = 0;
            MapCanonicalTable theResult = new MapCanonicalTable(theDelimiter);
            while (theReader.ready()) {
                ++eLineNum;
                String eLine = theReader.readLine();
                String eTruncated = eLine.replaceAll("^\\s+", "");
                boolean isStartComment = false;
                for (Object eChar : (MapCanonicalTable)COMMENTS) {
                    if (!eTruncated.startsWith("" + (char)eChar)) continue;
                    isStartComment = true;
                    break;
                }
                if (isStartComment || (eTruncated = eLine.trim()).length() <= 0) continue;
                int eLevel = this.getLevel(eTruncated);
                if (eLevel > 0) {
                    eTruncated = eTruncated.substring(eLevel, eTruncated.length() - eLevel);
                    if (theSupportedDelimiters != null && theSupportedDelimiters.length != 0) {
                        for (Object eDelimiter : (MapCanonicalTable)theSupportedDelimiters) {
                            if (eDelimiter == theResult.getDelimiter()) continue;
                            eTruncated = eTruncated.replace((char)eDelimiter, theResult.getDelimiter());
                        }
                    }
                    while (theSections.size() >= eLevel) {
                        theSections.pop();
                    }
                    if (theSections.size() + 1 < eLevel) {
                        throw new UnmarshalException("The line '" + eLine + "' is of a wrong section nesting (number of opening '[' and closing ']' section identifiers) of <" + eLevel + ">, though expected a section nesting of <" + (theSections.size() + 1) + ">", eLineNum);
                    }
                    theSections.push(eTruncated);
                    continue;
                }
                if (RESET_SECTION.equals(eTruncated)) {
                    theSections.clear();
                    continue;
                }
                if (!eLine.contains("" + Delimiter.PROPERTY.getChar())) {
                    throw new UnmarshalException("Expected a '" + Delimiter.PROPERTY.getChar() + "' at line <" + eLineNum + ">, line cannot be parsed as property.", eLineNum);
                }
                PropertyImpl eProperty = new PropertyImpl(eLine);
                if (((String)eProperty.getKey()).contains(" ")) {
                    throw new UnmarshalException("The key \"" + (String)eProperty.getKey() + "\" contains a space \" \" at line <" + eLineNum + ">, a key must not contain spaces.", eLineNum);
                }
                eTruncated = ((String)eProperty.getKey()).trim();
                eTruncated = theResult.fromExternalPath(eTruncated, theSupportedDelimiters);
                theResult.put(theResult.toPath(this.toSectionsPath(theSections, theResult), eTruncated), (String)eProperty.getValue());
            }
            mapCanonicalTable = theResult;
        }
        catch (Throwable throwable) {
            try {
                try {
                    theReader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new UnmarshalException("Unable to unmarshal the external representation from stream <" + String.valueOf(aMarshaled) + ">!", e);
            }
            catch (ParseException e) {
                throw new UnmarshalException("Unable to unmarshal the external representation from stream <" + String.valueOf(aMarshaled) + "> at offset <" + e.getErrorOffset() + ">!", e.getErrorOffset(), e);
            }
        }
        theReader.close();
        return mapCanonicalTable;
    }

    @Override
    public String toMarshaled(ImmutableCanonicalTable aUnmarshaled, DocumentOptions aOptions) throws MarshalException {
        String eExternalKey;
        char theDelimiter = aOptions != null ? aOptions.getDelimiterOr(aUnmarshaled.getDelimiter()) : aUnmarshaled.getDelimiter();
        ArrayList<String> theGlobals = new ArrayList<String>(aUnmarshaled.leaves());
        PathComparator thePathComparator = new PathComparator(aUnmarshaled.getDelimiter());
        theGlobals.sort(thePathComparator);
        ArrayList<String> theSections = new ArrayList<String>(aUnmarshaled.dirs());
        theSections.sort(thePathComparator);
        boolean hasWritten = false;
        Object theResult = "";
        String theComment = aOptions.getComment();
        if (theComment != null && theComment.length() > 0) {
            String[] theLines = theComment.split("\\r?\\n");
            for (String eLine : theLines) {
                theResult = (String)theResult + COMMENTS[0] + " " + (String)eLine;
                theResult = (String)theResult + System.lineSeparator();
            }
            hasWritten = true;
        }
        if (theGlobals != null && !theGlobals.isEmpty()) {
            if (hasWritten) {
                theResult = (String)theResult + System.lineSeparator();
            }
            for (String eKey : theGlobals) {
                eExternalKey = aUnmarshaled.toExternalPath(eKey, theDelimiter);
                theResult = (String)theResult + eExternalKey + Delimiter.PROPERTY.getChar() + (String)aUnmarshaled.get((Object)eKey);
                theResult = (String)theResult + System.lineSeparator();
            }
            hasWritten = true;
        }
        for (String eKey : theSections) {
            if (hasWritten) {
                theResult = (String)theResult + System.lineSeparator();
            }
            theResult = (String)theResult + "[" + eKey + "]";
            theResult = (String)theResult + System.lineSeparator();
            theResult = (String)theResult + System.lineSeparator();
            CanonicalTable eSecionProperties = aUnmarshaled.retrieveFrom(eKey);
            ArrayList eSectionKeys = new ArrayList(eSecionProperties.keySet());
            eSectionKeys.sort(thePathComparator);
            for (String eSectionKey : eSectionKeys) {
                eExternalKey = aUnmarshaled.toExternalPath(eSectionKey, theDelimiter);
                eExternalKey = aUnmarshaled.toPropertyPath(eExternalKey);
                theResult = (String)theResult + eExternalKey + Delimiter.PROPERTY.getChar() + (String)eSecionProperties.get((Object)eSectionKey);
                theResult = (String)theResult + System.lineSeparator();
            }
            hasWritten = true;
        }
        return theResult;
    }

    @Override
    public InputStream fromUnmarshaled(ImmutableCanonicalTable aUnmarshaled, DocumentOptions aOptions) throws MarshalException {
        String theExternalRepresentation = this.toMarshaled(aUnmarshaled, aOptions);
        return this.toInputStream(theExternalRepresentation);
    }

    private String toSectionsPath(Stack<String> aSections, ImmutableCanonicalTable aDataStructure) {
        String[] theSections = aSections.toArray(new String[aSections.size()]);
        for (int i = 0; i < theSections.length; ++i) {
            theSections[i] = aDataStructure.fromExternalPath(theSections[i], DELIMITERS);
        }
        return aDataStructure.toPath(theSections);
    }

    private int getLevel(String aLine) throws ParseException {
        String theLine = aLine;
        int theLeft = 0;
        int theRight = 0;
        while (theLine.startsWith("[")) {
            theLine = theLine.substring(1);
            ++theLeft;
        }
        while (theLine.endsWith("]")) {
            theLine = theLine.substring(0, theLine.length() - 1);
            ++theRight;
        }
        if (theLeft != theRight) {
            throw new ParseException("The line '" + aLine + "' starts with <" + theLeft + "> '[' chars, though ends with <" + theRight + "> ']' chars. It must start with as many '[' chars as it ends with ']' chars.", theLeft);
        }
        return theLeft;
    }
}

