/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.struct.ext.factory;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Properties;
import org.refcodes.data.Prefix;
import org.refcodes.exception.MarshalException;
import org.refcodes.exception.UnmarshalException;
import org.refcodes.struct.CanonicalTable;
import org.refcodes.struct.ImmutableCanonicalTable;
import org.refcodes.struct.ImmutablePathTable;
import org.refcodes.struct.MapCanonicalTable;
import org.refcodes.struct.ext.factory.AbstractCanonicalTableFactory;
import org.refcodes.struct.ext.factory.DocumentOptions;

public class JavaCanonicalTableFactory
extends AbstractCanonicalTableFactory {
    public static final char COMMENT = '#';

    @Override
    public CanonicalTable fromMarshaled(InputStream aMarshaled, DocumentOptions aOptions) throws UnmarshalException {
        char[] cArray;
        char theDelimiter;
        char c = theDelimiter = aOptions != null ? aOptions.getDelimiterOr(ImmutablePathTable.DELIMITER) : ImmutablePathTable.DELIMITER;
        if (aOptions != null) {
            cArray = aOptions.getDelimitersOr(new char[]{ImmutablePathTable.DELIMITER});
        } else {
            char[] cArray2 = new char[1];
            cArray = cArray2;
            cArray2[0] = ImmutablePathTable.DELIMITER;
        }
        char[] theSupportedDelimiters = cArray;
        Properties theProperties = new Properties();
        try {
            theProperties.load(aMarshaled);
        }
        catch (IOException | IllegalArgumentException e) {
            throw new UnmarshalException("Unable to unmarshal the external representation from input stream <" + String.valueOf(aMarshaled) + ">!", e);
        }
        MapCanonicalTable theResult = new MapCanonicalTable(theDelimiter);
        for (Object eObj : theProperties.keySet()) {
            String eKey = (String)eObj;
            String eValue = theProperties.getProperty(eKey);
            eKey = theResult.fromExternalPath(eKey, theSupportedDelimiters);
            theResult.put(eKey, eValue);
        }
        return theResult;
    }

    @Override
    public String toMarshaled(ImmutableCanonicalTable aUnmarshaled, DocumentOptions aOptions) throws MarshalException {
        char[] cArray;
        if (aOptions != null) {
            cArray = aOptions.getDelimitersOr(new char[]{ImmutablePathTable.DELIMITER});
        } else {
            char[] cArray2 = new char[1];
            cArray = cArray2;
            cArray2[0] = ImmutablePathTable.DELIMITER;
        }
        char[] theSupportedDelimiters = cArray;
        Properties theProperties = new Properties();
        ArrayList<String> theKeys = new ArrayList<String>(aUnmarshaled.sortedKeys());
        for (String eKey : theKeys) {
            String eValue = (String)aUnmarshaled.get((Object)eKey);
            eKey = aUnmarshaled.toExternalPath(eKey, theSupportedDelimiters[0]);
            eKey = aUnmarshaled.toPropertyPath(eKey);
            theProperties.put(eKey, eValue == null ? "" : eValue);
        }
        String theComment = aOptions.getComment();
        try {
            StringWriter theWriter = new StringWriter();
            theProperties.store(new PrintWriter(theWriter), theComment);
            String theResult = theWriter.getBuffer().toString();
            if (theComment == null) {
                while (theResult.startsWith(Prefix.JAVA_PROPERTIES_COMMENT.getPrefix())) {
                    theResult = theResult.split("\r\n|\r|\n", 2)[1];
                }
            }
            return theResult;
        }
        catch (IOException e) {
            throw new MarshalException("A problem occurred marshaling an object of type <" + ImmutableCanonicalTable.class.getName() + ">.", e);
        }
    }

    @Override
    public InputStream fromUnmarshaled(ImmutableCanonicalTable aUnmarshaled, DocumentOptions aOptions) throws MarshalException {
        String theMarshaled = this.toMarshaled(aUnmarshaled, aOptions);
        ByteArrayInputStream theMarshalledStream = new ByteArrayInputStream(theMarshaled.getBytes());
        return theMarshalledStream;
    }
}

