/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.struct;

import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.regex.Pattern;
import org.refcodes.data.Annotator;
import org.refcodes.data.Delimiter;
import org.refcodes.internal.PathPattern;
import org.refcodes.mixin.AnnotatorAccessor;
import org.refcodes.mixin.DelimiterAccessor;
import org.refcodes.mixin.TypeAccessor;
import org.refcodes.struct.ImmutableInterOperableTable;
import org.refcodes.struct.ImmutableTable;
import org.refcodes.struct.MapPathTable;
import org.refcodes.struct.PathComparator;
import org.refcodes.struct.PathSortStrategy;
import org.refcodes.struct.PathTable;
import org.refcodes.struct.Relation;
import org.refcodes.struct.SimpleType;
import org.refcodes.struct.StructureUtility;
import org.refcodes.struct.TypeUtility;

public interface ImmutablePathTable<T>
extends ImmutableTable<String, T>,
TypeAccessor<T>,
DelimiterAccessor,
AnnotatorAccessor {
    public static final char ANNOTATOR = Annotator.JAVA.getChar();
    public static final char DELIMITER = Delimiter.PATH.getChar();

    default public String toPrintable() {
        StringBuilder theBuilder = new StringBuilder();
        for (String eKey : this.sortedKeys()) {
            Object eValue = this.get((Object)eKey);
            eValue = eValue != null ? "\"" + String.valueOf(eValue) + "\"" : "null";
            theBuilder.append("\"" + eKey + "\" = " + String.valueOf(eValue));
            theBuilder.append(System.lineSeparator());
        }
        return theBuilder.toString();
    }

    default public Set<String> children() {
        return this.children(this.getRootPath());
    }

    default public Set<String> children(Collection<?> aPathElements) {
        return this.children(this.toPath(aPathElements));
    }

    default public Set<String> children(Object aPath) {
        return this.children(this.toPath(aPath));
    }

    default public Set<String> children(Object ... aPathElements) {
        return this.children(this.toPath(aPathElements));
    }

    default public Set<String> children(String aPath) {
        String thePath = this.toNormalizedPath(aPath);
        String theRootPath = this.getRootPath();
        LinkedHashSet<String> theElements = new LinkedHashSet<String>();
        this.keySet(thePath).stream().filter(eKey -> eKey.isEmpty() && thePath.equals(theRootPath) || eKey.length() > 0).forEach(eKey -> {
            int i = eKey.indexOf(this.getDelimiter(), 0);
            if (i == -1) {
                theElements.add((String)eKey);
            } else if ((eKey = eKey.substring(0, i)).length() > 0) {
                theElements.add((String)eKey);
            }
        });
        return theElements;
    }

    default public Set<String> children(String ... aPathElements) {
        return this.children(this.toPath(aPathElements));
    }

    default public boolean containsKey(Collection<?> aPathElements) {
        return this.containsKey((Object)this.toPath(aPathElements));
    }

    default public boolean containsKey(Object ... aPathElements) {
        return this.containsKey((Object)this.toPath(aPathElements));
    }

    default public boolean containsKey(String ... aPathElements) {
        return this.containsKey((Object)this.toPath(aPathElements));
    }

    default public Set<String> dirs() {
        return this.dirs(this.getRootPath());
    }

    default public Set<String> dirs(Collection<?> aPathElements) {
        return this.dirs(this.toPath(aPathElements));
    }

    default public Set<String> dirs(Object aPath) {
        return this.dirs(this.toPath(aPath));
    }

    default public Set<String> dirs(Object ... aPathElements) {
        return this.dirs(this.toPath(aPathElements));
    }

    default public Set<String> dirs(String aPath) {
        aPath = this.toNormalizedPath(aPath);
        LinkedHashSet<String> theDirs = new LinkedHashSet<String>();
        this.keySet(aPath).forEach(eKey -> {
            int i = eKey.indexOf(this.getDelimiter(), 0);
            if (i != -1 && (eKey = eKey.substring(0, i)).length() > 0) {
                theDirs.add((String)eKey);
            }
        });
        return theDirs;
    }

    default public Set<String> dirs(String ... aPathElements) {
        return this.dirs(this.toPath(aPathElements));
    }

    default public Set<String> findPaths(T aValue) {
        LinkedHashSet<String> thePaths = new LinkedHashSet<String>();
        if (aValue != null) {
            for (String ePath : this.keySet()) {
                if (!aValue.equals(this.get((Object)ePath))) continue;
                thePaths.add(ePath);
            }
        }
        return thePaths;
    }

    default public String fromExternalPath(String aPath, char ... aDelimiters) {
        if (aDelimiters != null && aDelimiters.length > 0) {
            for (char eDelimiter : aDelimiters) {
                if (eDelimiter == this.getDelimiter()) continue;
                aPath = aPath.replace(eDelimiter, this.getDelimiter());
            }
        }
        return this.toNormalizedPath(aPath);
    }

    default public T get(Collection<?> aPathElements) {
        return (T)this.get((Object)this.toPath(aPathElements));
    }

    default public T get(Object ... aPathElements) {
        return (T)this.get((Object)this.toPath(aPathElements));
    }

    default public T get(String ... aPathElements) {
        return (T)this.get((Object)this.toPath(aPathElements));
    }

    default public T[] getArray() {
        return this.getArray(this.getRootPath());
    }

    default public T[] getArray(Collection<?> aPathElements) {
        return this.getArray(this.toPath(aPathElements));
    }

    default public T[] getArray(Object aPath) {
        return this.getArray(this.toNormalizedPath(ImmutableInterOperableTable.asKey(aPath)));
    }

    default public T[] getArray(Object ... aPathElements) {
        return this.getArray(this.toPath(aPathElements));
    }

    default public T[] getArray(String ... aPathElements) {
        return this.getArray(this.toPath(aPathElements));
    }

    default public T[] getArray(String aPath) {
        int index;
        aPath = this.toNormalizedPath(aPath);
        boolean hasIllegalPathElements = false;
        int theMax = -1;
        PathTable<T> theMap = this.retrieveFrom(aPath);
        for (String string : theMap.leaves()) {
            try {
                if (!theMap.hasValue(string)) {
                    throw new IllegalArgumentException("The provided path \"" + aPath + "\" does not point to an array structure. Use \"isArray( String )\" to test if the leaves below the given path can be retrieved as array.");
                }
                index = Integer.valueOf(string);
                if (index < 0) {
                    throw new IllegalArgumentException("The provided path \"" + aPath + "\" does not point to an array structure. Use \"isArray( String )\" to test if the leaves below the given path can be retrieved as array.");
                }
                theMax = index > theMax ? index : theMax;
            }
            catch (NumberFormatException ignore) {
                hasIllegalPathElements = true;
            }
        }
        if (theMax != -1) {
            Object[] theArray = (Object[])Array.newInstance(this.getType(), theMax + 1);
            for (String eEntry : theMap.children()) {
                try {
                    if (!theMap.hasValue(eEntry)) {
                        throw new IllegalArgumentException("The provided path \"" + aPath + "\" does not point to an array structure. Use \"isArray( String )\" to test if the leaves below the given path can be retrieved as array.");
                    }
                    index = Integer.valueOf(eEntry);
                    theArray[index] = theMap.get((Object)eEntry);
                }
                catch (NumberFormatException numberFormatException) {}
            }
            return theArray;
        }
        Object theValue = this.get((Object)aPath);
        if (theValue != null) {
            Object[] objectArray = (Object[])Array.newInstance(this.getType(), 1);
            objectArray[0] = theValue;
            return objectArray;
        }
        if (hasIllegalPathElements) {
            throw new IllegalArgumentException("The provided path \"" + aPath + "\" does not point to an array structure. Use \"isArray( String )\" to test if the leaves below the given path can be retrieved as array.");
        }
        return (Object[])Array.newInstance(this.getType(), 0);
    }

    default public T[] getArrayOr(T[] aDefaultValue) {
        return this.getArrayOr(this.getRootPath(), aDefaultValue);
    }

    default public T[] getArrayOr(Collection<?> aPathElements, T[] aDefaultValue) {
        return this.getArrayOr(this.toPath(aPathElements), aDefaultValue);
    }

    default public T[] getArrayOr(Object[] aPathElements, T[] aDefaultValue) {
        return this.getArrayOr(this.toPath(aPathElements), aDefaultValue);
    }

    default public T[] getArrayOr(String aPath, T[] aDefaultValue) {
        try {
            return this.getArray(aPath);
        }
        catch (IllegalArgumentException e) {
            return aDefaultValue;
        }
    }

    default public T[] getArrayOr(String[] aPathElements, T[] aDefaultValue) {
        return this.getArrayOr(this.toPath(aPathElements), aDefaultValue);
    }

    default public T[] getArrayOr(Object aPath, T[] aDefaultValue) {
        return this.getArrayOr(this.toNormalizedPath(ImmutableInterOperableTable.asKey(aPath)), aDefaultValue);
    }

    default public int[] getArrayIndexes() {
        return this.getArrayIndexes(this.getRootPath());
    }

    default public int[] getArrayIndexes(Collection<?> aPathElements) {
        return this.getArrayIndexes(this.toPath(aPathElements));
    }

    default public int[] getArrayIndexes(Object ... aPathElements) {
        return this.getArrayIndexes(this.toPath(aPathElements));
    }

    default public int[] getArrayIndexes(String aPath) {
        HashSet<Integer> theIndexes = new HashSet<Integer>();
        aPath = this.toNormalizedPath(aPath);
        PathTable<T> theMap = this.retrieveFrom(aPath);
        for (String eEntry : theMap.children()) {
            try {
                if (!theMap.hasValue(eEntry)) {
                    throw new IllegalArgumentException("The provided path \"" + aPath + "\" does not point to an array structure. Use \"isArray( String )\" to test if the leaves below the given path can be retrieved as array.");
                }
                if (eEntry.startsWith("" + ANNOTATOR)) continue;
                int index = Integer.valueOf(eEntry);
                if (index < 0) {
                    throw new IllegalArgumentException("The provided path \"" + aPath + "\" does not point to an array structure. Use \"isArray( String )\" to test if the leaves below the given path can be retrieved as array.");
                }
                if (theIndexes.add(index)) continue;
                throw new IllegalArgumentException("The provided path \"" + aPath + "\" does not point to an array structure as we have multiple entries for index <" + index + ">. Use \"isArray( String )\" to test if the leaves below the given path can be retrieved as array.");
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("The provided path \"" + aPath + "\" does not point to an array structure. Use \"isArray( String )\" to test if the leaves below the given path can be retrieved as array.");
            }
        }
        int[] theArray = new int[theIndexes.size()];
        int i = 0;
        Iterator iterator = theIndexes.iterator();
        while (iterator.hasNext()) {
            int eIndex;
            theArray[i] = eIndex = ((Integer)iterator.next()).intValue();
            ++i;
        }
        Arrays.sort(theArray);
        return theArray;
    }

    default public int[] getArrayIndexes(String ... aPathElements) {
        return this.getArrayIndexes(this.toPath(aPathElements));
    }

    default public PathTable<T> getDirAt(Collection<?> aPathElements, int aIndex) {
        return this.getDirAt(this.toPath(aPathElements), aIndex);
    }

    default public PathTable<T> getDirAt(int aIndex) {
        return this.getDirAt(this.getRootPath(), aIndex);
    }

    default public PathTable<T> getDirAt(Object aPath, int aIndex) {
        return this.getDirAt(this.toNormalizedPath(ImmutableInterOperableTable.asKey(aPath)), aIndex);
    }

    default public PathTable<T> getDirAt(Object[] aPathElements, int aIndex) {
        return this.getDirAt(this.toPath(aPathElements), aIndex);
    }

    default public PathTable<T> getDirAt(String aPath, int aIndex) {
        return this.retrieveFrom(this.toPath(aPath, aIndex));
    }

    default public PathTable<T> getDirAt(String[] aPathElements, int aIndex) {
        return this.getDirAt(this.toPath(aPathElements), aIndex);
    }

    default public int[] getDirIndexes() {
        return this.getDirIndexes(this.getRootPath());
    }

    default public int[] getDirIndexes(Collection<?> aPathElements) {
        return this.getDirIndexes(this.toPath(aPathElements));
    }

    default public int[] getDirIndexes(Object aPath) {
        return this.getDirIndexes(this.toNormalizedPath(ImmutableInterOperableTable.asKey(aPath)));
    }

    default public int[] getDirIndexes(Object ... aPathElements) {
        return this.getDirIndexes(this.toPath(aPathElements));
    }

    default public int[] getDirIndexes(String aPath) {
        aPath = this.toNormalizedPath(aPath);
        HashSet<Integer> theIndexes = new HashSet<Integer>();
        Set<String> thePaths = this.paths(aPath);
        boolean isDirPath = false;
        Iterator<String> e = thePaths.iterator();
        while (e.hasNext()) {
            int eNextDelimiterIndex;
            String ePath = e.next();
            if (ePath.startsWith("" + this.getDelimiter())) {
                ePath = ePath.substring(1);
            }
            if ((eNextDelimiterIndex = ePath.indexOf(this.getDelimiter())) != -1) {
                isDirPath = true;
                ePath = ePath.substring(0, eNextDelimiterIndex);
            }
            try {
                if (ePath.startsWith("" + this.getAnnotator())) {
                    e.remove();
                    continue;
                }
                int eIndex = Integer.parseInt(ePath);
                if (!theIndexes.contains(eIndex)) {
                    theIndexes.add(eIndex);
                }
                e.remove();
            }
            catch (Exception exc) {
                throw new IllegalArgumentException("The path <" + String.valueOf(aPath == null || aPath.isEmpty() ? Character.valueOf(this.getDelimiter()) : aPath) + "> does not point to an indexed path. Use \"isIndexDir( String aPath )\" to test beforehand.");
            }
        }
        if (!isDirPath && !thePaths.isEmpty()) {
            throw new IllegalArgumentException("The path <" + String.valueOf(aPath == null || aPath.isEmpty() ? Character.valueOf(this.getDelimiter()) : aPath) + "> does not point to an indexed path. Use \"isIndexDir( String aPath )\" to test beforehand.");
        }
        int[] theArray = new int[theIndexes.size()];
        int i = 0;
        Iterator iterator = theIndexes.iterator();
        while (iterator.hasNext()) {
            int j;
            theArray[i] = j = ((Integer)iterator.next()).intValue();
            ++i;
        }
        Arrays.sort(theArray);
        return theArray;
    }

    default public int[] getDirIndexes(String ... aPathElements) {
        return this.getDirIndexes(this.toPath(aPathElements));
    }

    default public String getRootPath() {
        return "" + this.getDelimiter();
    }

    default public T getValueAt(Collection<?> aPathElements, int aIndex) {
        return (T)this.get((Object)this.toPath(aPathElements, aIndex));
    }

    default public T getValueAt(int aIndex) {
        return (T)this.get((Object)aIndex);
    }

    default public T getValueAt(Object aPath, int aIndex) {
        return (T)this.get((Object)this.toPath(aPath, aIndex));
    }

    default public T getValueAt(Object[] aPathElements, int aIndex) {
        return this.get(this.toPath(aPathElements), aIndex);
    }

    default public T getValueAt(String aPath, int aIndex) {
        return (T)this.get((Object)this.toPath(aPath, aIndex));
    }

    default public T getValueAt(String[] aPathElements, int aIndex) {
        return this.get(this.toPath(aPathElements), aIndex);
    }

    default public boolean hasChildren(Collection<?> aPathElements) {
        return this.hasChildren(this.toPath(aPathElements));
    }

    default public boolean hasChildren(Object aPath) {
        return this.hasChildren(this.toNormalizedPath(ImmutableInterOperableTable.asKey(aPath)));
    }

    default public boolean hasChildren(Object ... aPathElements) {
        return this.hasChildren(this.toPath(aPathElements));
    }

    default public boolean hasChildren(String aPath) {
        Set<String> theChildren = this.children(aPath);
        return theChildren != null && theChildren.size() != 0;
    }

    default public boolean hasChildren(String ... aPathElements) {
        return this.hasChildren(this.toPath(aPathElements));
    }

    default public boolean hasDirAt(Collection<?> aPathElements) {
        return this.hasDirAt(this.toPath(aPathElements));
    }

    default public boolean hasDirAt(Collection<?> aPathElements, int aIndex) {
        return this.hasDirAt(this.toPath(aPathElements), aIndex);
    }

    default public boolean hasDirAt(int aIndex) {
        return this.hasDirAt(this.getRootPath(), aIndex);
    }

    default public boolean hasDirAt(Object aPath) {
        return this.hasDirAt(this.toNormalizedPath(ImmutableInterOperableTable.asKey(aPath)));
    }

    default public boolean hasDirAt(Object ... aPathElements) {
        return this.hasDirAt(this.toPath(aPathElements));
    }

    default public boolean hasDirAt(Object aPath, int aIndex) {
        return this.isDir(this.toPath(aPath, Integer.toString(aIndex)));
    }

    default public boolean hasDirAt(Object[] aPathElements, int aIndex) {
        return this.isDir(this.toPath(aPathElements, aIndex));
    }

    default public boolean hasDirAt(String aPath) {
        String[] thePathElements = this.toPathElements(aPath);
        if (thePathElements != null && thePathElements.length > 0) {
            try {
                int index = Integer.valueOf(thePathElements[thePathElements.length - 1]);
                aPath = this.toParentPath(aPath);
                return this.hasDirAt(aPath, index);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return false;
    }

    default public boolean hasDirAt(String ... aPathElements) {
        return this.hasDirAt(this.toPath(aPathElements));
    }

    default public boolean hasDirAt(String aPath, int aIndex) {
        return this.isDir(this.toPath(aPath, Integer.toString(aIndex)));
    }

    default public boolean hasDirAt(String[] aPathElements, int aIndex) {
        return this.hasDirAt(this.toPath(aPathElements), aIndex);
    }

    default public boolean hasParentPath(String aPath) {
        int index = (aPath = this.toNormalizedPath(aPath)).lastIndexOf(this.getDelimiter());
        return index > 0;
    }

    default public boolean hasPath(Collection<?> aPathElements) {
        return this.hasPath(this.toPath(aPathElements));
    }

    default public boolean hasPath(Object ... aPathElements) {
        return this.hasPath(this.toPath(aPathElements));
    }

    default public boolean hasPath(Object aPath) {
        return !this.paths(aPath).isEmpty();
    }

    default public boolean hasPath(String aPath) {
        return !this.paths(aPath).isEmpty();
    }

    default public boolean hasPath(String ... aPathElements) {
        return this.hasPath(this.toPath(aPathElements));
    }

    default public boolean hasValueAt(Collection<?> aPathElements, int aIndex) {
        return this.hasValue(this.toPath(this.toPath(aPathElements), Integer.toString(aIndex)));
    }

    default public boolean hasValueAt(int aIndex) {
        return this.hasValueAt(this.getRootPath(), aIndex);
    }

    default public boolean hasValueAt(Object aPath) {
        return this.hasValueAt(this.toNormalizedPath(ImmutableInterOperableTable.asKey(aPath)));
    }

    default public boolean hasValueAt(Object aPath, int aIndex) {
        return this.hasValue(this.toPath(aPath, aIndex));
    }

    default public boolean hasValueAt(Object[] aPathElements, int aIndex) {
        return this.hasValue(this.toPath(aPathElements, aIndex));
    }

    default public boolean hasValueAt(String aPath) {
        String[] thePathElements = this.toPathElements(aPath);
        if (thePathElements != null && thePathElements.length > 0) {
            try {
                int index = Integer.valueOf(thePathElements[thePathElements.length - 1]);
                aPath = this.toParentPath(aPath);
                return this.hasValueAt(aPath, index);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return false;
    }

    default public boolean hasValueAt(String aPath, int aIndex) {
        return this.hasValue(this.toPath(aPath, aIndex));
    }

    default public boolean hasValueAt(String[] aPathElements, int aIndex) {
        return this.hasValue(this.toPath(aPathElements, aIndex));
    }

    default public boolean isArray() {
        return this.isArray(this.getRootPath());
    }

    default public boolean isArray(String ... aPathElements) {
        return this.isArray(this.toPath(aPathElements));
    }

    default public boolean isArray(Collection<?> aPathElements) {
        return this.isArray(this.toPath(aPathElements));
    }

    default public boolean isArray(Object aPath) {
        return this.isArray(this.toNormalizedPath(ImmutableInterOperableTable.asKey(aPath)));
    }

    default public boolean isArray(Object ... aPathElements) {
        return this.isArray(this.toPath(aPathElements));
    }

    default public boolean isArray(String aPath) {
        HashSet<Integer> theIndexes = new HashSet<Integer>();
        aPath = this.toNormalizedPath(aPath);
        int theAnnotated = 0;
        PathTable<T> theMap = this.retrieveFrom(aPath);
        for (String eEntry : theMap.children()) {
            try {
                if (!theMap.hasValue(eEntry)) {
                    return false;
                }
                if (eEntry.startsWith("" + this.getAnnotator())) {
                    ++theAnnotated;
                    continue;
                }
                int index = Integer.valueOf(eEntry);
                if (index < 0) {
                    return false;
                }
                if (theIndexes.add(index)) continue;
                return false;
            }
            catch (NumberFormatException e) {
                return false;
            }
        }
        return theMap.size() - theAnnotated != 0;
    }

    default public boolean isChild(Collection<?> aPathElements) {
        return this.isChild(this.toPath(aPathElements));
    }

    default public boolean isChild(Object ... aPathElements) {
        return this.isChild(this.toPath(aPathElements));
    }

    default public boolean isChild(String aPath) {
        return this.hasValue(aPath) || this.isDir(aPath);
    }

    default public boolean isChild(String ... aPathElements) {
        return this.hasValue(aPathElements) || this.isDir(aPathElements);
    }

    default public boolean isDir(Collection<?> aPathElements) {
        return this.isDir(this.toPath(aPathElements));
    }

    default public boolean isDir(Object aPath) {
        return this.isDir(this.toNormalizedPath(ImmutableInterOperableTable.asKey(aPath)));
    }

    default public boolean isDir(Object ... aPathElements) {
        return this.isDir(this.toPath(aPathElements));
    }

    default public boolean isDir(String aPath) {
        if (!((String)(aPath = this.toNormalizedPath((String)aPath))).endsWith("" + this.getDelimiter())) {
            aPath = (String)aPath + this.getDelimiter();
        }
        String thePath = aPath;
        String theRootPath = this.getRootPath();
        return this.keySet().stream().filter(eKey -> eKey.length() > thePath.length() && eKey.startsWith(thePath) || eKey.equals(theRootPath) && thePath.equals(theRootPath)).findFirst().map(string -> true).orElse(false);
    }

    default public boolean isDir(String ... aPathElements) {
        return this.isDir(this.toPath(aPathElements));
    }

    default public boolean isLeaf(Collection<?> aPathElements) {
        return this.isLeaf(this.toPath(aPathElements));
    }

    default public boolean isLeaf(Object aPath) {
        return this.isLeaf(this.toNormalizedPath(ImmutableInterOperableTable.asKey(aPath)));
    }

    default public boolean isLeaf(Object ... aPathElements) {
        return this.isLeaf(this.toPath(aPathElements));
    }

    default public boolean isLeaf(String aPath) {
        return this.containsKey((Object)aPath);
    }

    default public boolean isLeaf(String ... aPathElements) {
        return this.isLeaf(this.toPath(aPathElements));
    }

    default public boolean isIndexDir() {
        return this.isIndexDir(this.getRootPath());
    }

    default public boolean isIndexDir(Collection<?> aPathElements) {
        return this.isIndexDir(this.toPath(aPathElements));
    }

    default public boolean isIndexDir(Object ... aPathElements) {
        return this.isIndexDir(this.toPath(aPathElements));
    }

    default public boolean isIndexDir(String aPath) {
        aPath = this.toNormalizedPath(aPath);
        try {
            Set<String> thePaths = this.paths(aPath);
            if (thePaths.size() != 0) {
                Iterator<String> e = thePaths.iterator();
                while (e.hasNext()) {
                    int eNextDelimiterIndex;
                    String ePath = e.next();
                    if (ePath.isEmpty()) {
                        return false;
                    }
                    if (ePath.startsWith("" + this.getDelimiter())) {
                        ePath = ePath.substring(1);
                    }
                    if ((eNextDelimiterIndex = ePath.indexOf(this.getDelimiter())) != -1) {
                        ePath = ePath.substring(0, eNextDelimiterIndex);
                    }
                    if (ePath.startsWith("" + this.getAnnotator())) {
                        e.remove();
                        continue;
                    }
                    Integer.parseInt(ePath);
                }
                return !thePaths.isEmpty();
            }
            return false;
        }
        catch (Exception e) {
            return false;
        }
    }

    default public boolean isIndexDir(String ... aPathElements) {
        return this.isIndexDir(this.toPath(aPathElements));
    }

    default public boolean isEqualTo(ImmutablePathTable<?> aOther) {
        if (this.size() != aOther.size()) {
            return false;
        }
        for (String eKey : this.keySet()) {
            Object eOtherValue;
            Object eValue = this.get((Object)eKey);
            if (eValue == (eOtherValue = aOther.get((Object)eKey))) continue;
            if (eValue != null) {
                if (eValue.equals(eOtherValue)) continue;
                return false;
            }
            return false;
        }
        return true;
    }

    default public boolean hasSubDirs(Collection<?> aPathElements) {
        return this.hasSubDirs(this.toPath(aPathElements));
    }

    default public boolean hasSubDirs(Object aPath) {
        return this.hasSubDirs(this.toNormalizedPath(ImmutableInterOperableTable.asKey(aPath)));
    }

    default public boolean hasSubDirs(Object ... aPathElements) {
        return this.hasSubDirs(this.toPath(aPathElements));
    }

    default public boolean hasSubDirs(String aPath) {
        return this.dirs(aPath).size() != 0;
    }

    default public boolean hasValue(Collection<?> aPathElements) {
        return this.hasValue(this.toPath(aPathElements));
    }

    default public boolean hasValue(Object aPath) {
        return this.hasValue(this.toNormalizedPath(ImmutableInterOperableTable.asKey(aPath)));
    }

    default public boolean hasValue(Object ... aPathElements) {
        return this.hasValue(this.toPath(aPathElements));
    }

    default public boolean hasValue(String aPath) {
        aPath = this.toNormalizedPath(aPath);
        return this.containsKey((Object)aPath);
    }

    default public boolean hasValue(String ... aPathElements) {
        return this.hasValue(this.toPath(aPathElements));
    }

    default public boolean isRootPath(String aPath) {
        aPath = this.toNormalizedPath(aPath);
        String theRootPath = this.toNormalizedPath(this.getRootPath());
        return theRootPath.equals(aPath);
    }

    default public Set<String> keySet(String aPath) {
        if (!((String)(aPath = this.toNormalizedPath((String)aPath))).endsWith("" + this.getDelimiter())) {
            aPath = (String)aPath + this.getDelimiter();
        }
        String thePath = aPath;
        String theRootPath = this.getRootPath();
        LinkedHashSet<String> theKeySet = new LinkedHashSet<String>();
        this.keySet().stream().filter(eKey -> eKey.length() > thePath.length() && eKey.startsWith(thePath) || eKey.equals(theRootPath) && thePath.equals(theRootPath)).map(eKey -> eKey.substring(thePath.length())).forEach(theKeySet::add);
        return theKeySet;
    }

    default public Set<String> keySet(Collection<?> aPathElements) {
        return this.keySet(this.toPath(aPathElements));
    }

    default public Set<String> keySet(Object aPath) {
        return this.keySet(this.toNormalizedPath(ImmutableInterOperableTable.asKey(aPath)));
    }

    default public Set<String> keySet(Object ... aPathElements) {
        return this.keySet(this.toPath(aPathElements));
    }

    default public Set<String> keySet(String ... aPathElements) {
        return this.keySet(this.toPath(aPathElements));
    }

    default public int lastArrayIndex() {
        return this.lastArrayIndex(this.getRootPath());
    }

    default public int lastArrayIndex(Collection<?> aPathElements) {
        return this.lastArrayIndex(this.toPath(aPathElements));
    }

    default public int lastArrayIndex(Object aPath) {
        return this.lastArrayIndex(this.toNormalizedPath(ImmutableInterOperableTable.asKey(aPath)));
    }

    default public int lastArrayIndex(Object ... aPathElements) {
        return this.lastArrayIndex(this.toPath(aPathElements));
    }

    default public int lastArrayIndex(String aPath) {
        int theIndex = -1;
        int[] theIndexes = this.getArrayIndexes(aPath);
        if (theIndexes != null && theIndexes.length != 0) {
            theIndex = theIndexes[theIndexes.length - 1];
        }
        return theIndex;
    }

    default public int lastArrayIndex(String ... aPathElements) {
        return this.lastArrayIndex(this.toPath(aPathElements));
    }

    default public int lastDirIndex() {
        return this.lastDirIndex(this.getRootPath());
    }

    default public int lastDirIndex(Collection<?> aPathElements) {
        return this.lastDirIndex(this.toPath(aPathElements));
    }

    default public int lastDirIndex(Object aPath) {
        return this.lastDirIndex(this.toNormalizedPath(ImmutableInterOperableTable.asKey(aPath)));
    }

    default public int lastDirIndex(Object ... aPathElements) {
        return this.lastDirIndex(this.toPath(aPathElements));
    }

    default public int lastDirIndex(String aPath) {
        int theIndex = -1;
        int[] theIndexes = this.getDirIndexes(aPath);
        if (theIndexes != null && theIndexes.length != 0) {
            theIndex = theIndexes[theIndexes.length - 1];
        }
        return theIndex;
    }

    default public int lastDirIndex(String ... aPathElements) {
        return this.lastDirIndex(this.toPath(aPathElements));
    }

    default public Set<String> leaves() {
        return this.leaves(this.getRootPath());
    }

    default public Set<String> leaves(Collection<?> aPathElements) {
        return this.leaves(this.toPath(aPathElements));
    }

    default public Set<String> leaves(Object aPath) {
        return this.leaves(this.toNormalizedPath(ImmutableInterOperableTable.asKey(aPath)));
    }

    default public Set<String> leaves(Object ... aPathElements) {
        return this.leaves(this.toPath(aPathElements));
    }

    default public Set<String> leaves(String aPath) {
        aPath = this.toNormalizedPath(aPath);
        LinkedHashSet<String> theLeaves = new LinkedHashSet<String>();
        this.keySet(aPath).stream().filter(eKey -> eKey.length() > 0).filter(eKey -> eKey.indexOf(this.getDelimiter(), 0) == -1).forEach(theLeaves::add);
        return theLeaves;
    }

    default public Set<String> leaves(String ... aPathElements) {
        return this.leaves(this.toPath(aPathElements));
    }

    default public int nextArrayIndex() {
        return this.nextArrayIndex(this.getRootPath());
    }

    default public int nextArrayIndex(Collection<?> aPathElements) {
        return this.nextArrayIndex(this.toPath(aPathElements));
    }

    default public int nextArrayIndex(Object aPath) {
        return this.lastArrayIndex(this.toNormalizedPath(ImmutableInterOperableTable.asKey(aPath))) + 1;
    }

    default public int nextArrayIndex(Object ... aPathElements) {
        return this.nextArrayIndex(this.toPath(aPathElements));
    }

    default public int nextArrayIndex(String aPath) {
        try {
            return this.lastArrayIndex(aPath) + 1;
        }
        catch (IllegalArgumentException ignore) {
            return 0;
        }
    }

    default public int nextArrayIndex(String ... aPathElements) {
        return this.nextArrayIndex(this.toPath(aPathElements));
    }

    default public int nextDirIndex() {
        return this.nextDirIndex(this.getRootPath());
    }

    default public int nextDirIndex(Collection<?> aPathElements) {
        return this.nextDirIndex(this.toPath(aPathElements));
    }

    default public int nextDirIndex(Object aPath) {
        return this.lastDirIndex(this.toNormalizedPath(ImmutableInterOperableTable.asKey(aPath))) + 1;
    }

    default public int nextDirIndex(Object ... aPathElements) {
        return this.nextDirIndex(this.toPath(aPathElements));
    }

    default public int nextDirIndex(String aPath) {
        return this.lastDirIndex(aPath) + 1;
    }

    default public int nextDirIndex(String ... aPathElements) {
        return this.nextDirIndex(this.toPath(aPathElements));
    }

    default public Set<String> paths() {
        return this.keySet();
    }

    default public Set<String> paths(Collection<?> aPathElements) {
        return this.paths(this.toPath(aPathElements));
    }

    default public Set<String> paths(Object aPath) {
        return this.paths(this.toNormalizedPath(ImmutableInterOperableTable.asKey(aPath)));
    }

    default public Set<String> paths(Object ... aPathElements) {
        return this.paths(this.toPath(aPathElements));
    }

    default public Set<String> paths(String aPath) {
        return this.keySet(aPath);
    }

    default public Set<String> paths(String ... aPathElements) {
        return this.paths(this.toPath(aPathElements));
    }

    default public PathTable<T> query(Collection<?> aQueryElements) {
        return this.query(this.toPath(aQueryElements));
    }

    default public PathTable<T> query(Object ... aQueryElements) {
        return this.query(this.toPath(aQueryElements));
    }

    default public PathTable<T> query(Pattern aRegExp) {
        MapPathTable theMap = new MapPathTable(this.getType());
        for (String ePath : this.paths()) {
            if (!aRegExp.matcher(ePath).matches()) continue;
            theMap.put(ePath, this.get((Object)ePath));
        }
        return theMap;
    }

    default public PathTable<T> query(String aPathQuery) {
        MapPathTable theMap = new MapPathTable(this.getType());
        Pattern thePattern = new PathPattern(aPathQuery, this.getDelimiter()).getPattern();
        for (String ePath : this.paths()) {
            if (!thePattern.matcher(ePath).matches()) continue;
            theMap.put(ePath, this.get((Object)ePath));
        }
        return theMap;
    }

    default public PathTable<T> query(String ... aQueryElements) {
        return this.query(this.toPath(aQueryElements));
    }

    default public PathTable<T> queryBetween(Collection<?> aFromPath, Collection<?> aPathQuery, Collection<?> aToPath) {
        return this.queryBetween(this.toPath(aFromPath), this.toPath(aPathQuery), this.toPath(aToPath));
    }

    default public PathTable<T> queryBetween(Object aFromPath, Object aPathQuery, Object aToPath) {
        return this.queryBetween(this.toNormalizedPath(ImmutableInterOperableTable.asKey(aFromPath)), this.toNormalizedPath(ImmutableInterOperableTable.asKey(aPathQuery)), this.toNormalizedPath(ImmutableInterOperableTable.asKey(aToPath)));
    }

    default public PathTable<T> queryBetween(Object[] aFromPath, Object[] aPathQuery, Object[] aToPath) {
        return this.queryBetween(this.toPath(aFromPath), this.toPath(aPathQuery), this.toPath(aToPath));
    }

    default public PathTable<T> queryBetween(String aFromPath, Pattern aRegExp, String aToPath) {
        PathTable<T> theFrom = this.retrieveFrom(aFromPath);
        MapPathTable theMap = new MapPathTable(this.getType());
        for (String ePath : theFrom.keySet()) {
            if (!aRegExp.matcher(ePath).matches()) continue;
            theMap.put(ePath, theFrom.get((Object)ePath));
        }
        return theMap.retrieveTo(aToPath);
    }

    default public PathTable<T> queryBetween(String aFromPath, String aPathQuery, String aToPath) {
        PathTable<T> theFrom = this.retrieveFrom(aFromPath);
        MapPathTable theMap = new MapPathTable(this.getType());
        Pattern thePattern = new PathPattern(aPathQuery, this.getDelimiter()).getPattern();
        for (String ePath : theFrom.keySet()) {
            if (!thePattern.matcher(ePath).matches()) continue;
            theMap.put(ePath, theFrom.get((Object)ePath));
        }
        return theMap.retrieveTo(aToPath);
    }

    default public PathTable<T> queryBetween(String[] aFromPath, String[] aPathQuery, String[] aToPath) {
        return this.queryBetween(this.toPath(aFromPath), this.toPath(aPathQuery), this.toPath(aToPath));
    }

    default public PathTable<T> queryFrom(Collection<?> aPathQuery, Collection<?> aFromPath) {
        return this.queryFrom(this.toPath(aPathQuery), this.toPath(aFromPath));
    }

    default public PathTable<T> queryFrom(Object aPathQuery, Object aFromPath) {
        return this.queryFrom(this.toPath(aPathQuery), this.toPath(aFromPath));
    }

    default public PathTable<T> queryFrom(Object[] aPathQuery, Object[] aFromPath) {
        return this.queryFrom(this.toPath(aPathQuery), this.toPath(aFromPath));
    }

    default public PathTable<T> queryFrom(Pattern aRegExp, String aFromPath) {
        PathTable<T> theFrom = this.retrieveFrom(aFromPath);
        MapPathTable theMap = new MapPathTable(this.getType());
        for (String ePath : theFrom.keySet()) {
            if (!aRegExp.matcher(ePath).matches()) continue;
            theMap.put(ePath, theFrom.get((Object)ePath));
        }
        return theMap;
    }

    default public PathTable<T> queryFrom(String aPathQuery, String aFromPath) {
        PathTable<T> theFrom = this.retrieveFrom(aFromPath);
        MapPathTable theMap = new MapPathTable(this.getType());
        Pattern thePattern = new PathPattern(aPathQuery, this.getDelimiter()).getPattern();
        for (String ePath : theFrom.keySet()) {
            if (!thePattern.matcher(ePath).matches()) continue;
            theMap.put(ePath, theFrom.get((Object)ePath));
        }
        return theMap;
    }

    default public PathTable<T> queryFrom(String[] aPathQuery, String[] aFromPath) {
        return this.queryFrom(this.toPath(aPathQuery), this.toPath(aFromPath));
    }

    default public Set<String> queryPaths(Collection<?> aPathQuery) {
        return this.queryPaths(this.toPath(aPathQuery));
    }

    default public Set<String> queryPaths(Object aPathQuery) {
        return this.queryPaths(this.toPath(aPathQuery));
    }

    default public Set<String> queryPaths(Object ... aPathQuery) {
        return this.queryPaths(this.toPath(aPathQuery));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    default public Set<String> queryPaths(Pattern aRegExp) {
        LinkedHashSet<String> theSet = new LinkedHashSet<String>();
        for (String ePath : this.paths()) {
            if (!aRegExp.matcher(ePath).matches()) continue;
            LinkedHashSet<String> linkedHashSet = theSet;
            synchronized (linkedHashSet) {
                theSet.add(ePath);
            }
        }
        return theSet;
    }

    default public Set<String> queryPaths(String ... aPathQuery) {
        return this.queryPaths(this.toPath(aPathQuery));
    }

    default public Set<String> queryPaths(String aPathQuery) {
        LinkedHashSet<String> theSet = new LinkedHashSet<String>();
        Pattern thePattern = new PathPattern(aPathQuery, this.getDelimiter()).getPattern();
        for (String ePath : this.paths()) {
            if (!thePattern.matcher(ePath).matches()) continue;
            theSet.add(ePath);
        }
        return theSet;
    }

    default public PathTable<T> queryTo(Collection<?> aPathQuery, String aToPath) {
        return this.queryTo(this.toPath(aPathQuery), aToPath);
    }

    default public PathTable<T> queryTo(Object aPathQuery, String aToPath) {
        return this.queryTo(this.toPath(aPathQuery), aToPath);
    }

    default public PathTable<T> queryTo(Object[] aPathQuery, String aToPath) {
        return this.queryTo(this.toPath(aPathQuery), aToPath);
    }

    default public PathTable<T> queryTo(Pattern aRegExp, String aToPath) {
        MapPathTable theMap = new MapPathTable(this.getType());
        for (String ePath : this.paths()) {
            if (!aRegExp.matcher(ePath).matches()) continue;
            theMap.put(ePath, this.get((Object)ePath));
        }
        return theMap.retrieveTo(aToPath);
    }

    default public PathTable<T> queryTo(String aPathQuery, String aToPath) {
        MapPathTable theMap = new MapPathTable(this.getType());
        Pattern thePattern = new PathPattern(aPathQuery, this.getDelimiter()).getPattern();
        for (String ePath : this.paths()) {
            if (!thePattern.matcher(ePath).matches()) continue;
            theMap.put(ePath, this.get((Object)ePath));
        }
        return theMap.retrieveTo(aToPath);
    }

    default public PathTable<T> queryTo(String[] aPathQuery, String aToPath) {
        return this.queryTo(this.toPath(aPathQuery), aToPath);
    }

    default public PathTable<T> retrieveBetween(Collection<?> aFromPath, Collection<?> aToPath) {
        PathTable<T> thePathMap = this.retrieveFrom(aFromPath);
        return thePathMap.retrieveTo(aToPath);
    }

    default public PathTable<T> retrieveBetween(Object aFromPath, Object aToPath) {
        PathTable<T> thePathMap = this.retrieveFrom(aFromPath);
        return thePathMap.retrieveTo(aToPath);
    }

    default public PathTable<T> retrieveBetween(Object[] aFromPath, Object[] aToPath) {
        PathTable<T> thePathMap = this.retrieveFrom(aFromPath);
        return thePathMap.retrieveTo(aToPath);
    }

    default public PathTable<T> retrieveBetween(String aFromPath, String aToPath) {
        PathTable<T> thePathMap = this.retrieveFrom(aFromPath);
        return thePathMap.retrieveTo(aToPath);
    }

    default public PathTable<T> retrieveBetween(String[] aFromPath, String[] aToPath) {
        PathTable<T> thePathMap = this.retrieveFrom(aFromPath);
        return thePathMap.retrieveTo(aToPath);
    }

    default public PathTable<T> retrieveFrom(Collection<?> aPathElements) {
        return this.retrieveFrom(this.toPath(aPathElements));
    }

    default public PathTable<T> retrieveFrom(Object aFromPath) {
        return this.retrieveFrom(this.toNormalizedPath(ImmutableInterOperableTable.asKey(aFromPath)));
    }

    default public PathTable<T> retrieveFrom(Object ... aPathElements) {
        return this.retrieveFrom(this.toPath(aPathElements));
    }

    public PathTable<T> retrieveFrom(String var1);

    default public PathTable<T> retrieveFrom(String ... aPathElements) {
        return this.retrieveFrom(this.toPath(aPathElements));
    }

    default public PathTable<T> getDir(Collection<?> aPathElements) {
        return this.getDir(this.toPath(aPathElements));
    }

    default public PathTable<T> getDir(Object aPath) {
        return this.getDir(this.toNormalizedPath(ImmutableInterOperableTable.asKey(aPath)));
    }

    default public PathTable<T> getDir(Object ... aPathElements) {
        return this.getDir(this.toPath(aPathElements));
    }

    default public PathTable<T> getDir(String aPath) {
        return this.retrieveFrom(aPath);
    }

    default public PathTable<T> getDir(String ... aPathElements) {
        return this.getDir(this.toPath(aPathElements));
    }

    default public PathTable<T>[] getDirs(Collection<?> aPathElements) {
        return this.getDirs(this.toPath(aPathElements));
    }

    default public PathTable<T>[] getDirs(Object aPath) {
        return this.getDirs(this.toNormalizedPath(ImmutableInterOperableTable.asKey(aPath)));
    }

    default public PathTable<T>[] getDirs(Object ... aPathElements) {
        return this.getDirs(this.toPath(aPathElements));
    }

    default public PathTable<T>[] getDirs(String aPath) {
        PathTable[] theDirs;
        if (this.isIndexDir(aPath)) {
            int[] theIndexes = this.getDirIndexes(aPath);
            theDirs = new PathTable[theIndexes[theIndexes.length - 1] + 1];
            for (int i : theIndexes) {
                theDirs[theIndexes[i]] = this.getDirAt(aPath, theIndexes[i]);
            }
        } else {
            theDirs = new PathTable[]{this.getDir(aPath)};
        }
        return theDirs;
    }

    default public PathTable<T>[] getDirs(String ... aPathElements) {
        return this.getDirs(this.toPath(aPathElements));
    }

    default public PathTable<T> retrieveTo(Collection<?> aToPathElements) {
        return this.retrieveTo(this.toPath(aToPathElements));
    }

    default public PathTable<T> retrieveTo(Object aToPath) {
        return this.retrieveTo(this.toNormalizedPath(ImmutableInterOperableTable.asKey(aToPath)));
    }

    default public PathTable<T> retrieveTo(Object ... aToPathElements) {
        return this.retrieveTo(this.toPath(aToPathElements));
    }

    public PathTable<T> retrieveTo(String var1);

    default public PathTable<T> retrieveTo(String ... aToPathElements) {
        return this.retrieveTo(this.toPath(aToPathElements));
    }

    default public List<String> sortedKeys() {
        ArrayList<String> theKeys = new ArrayList<String>(this.keySet());
        theKeys.sort(new PathComparator(this.getDelimiter(), PathSortStrategy.DEFAULT));
        return theKeys;
    }

    default public List<String> sortedKeys(Collection<?> aPathElements) {
        return this.sortedKeys(this.toPath(aPathElements));
    }

    default public List<String> sortedKeys(Object aPath) {
        return this.sortedKeys(this.toNormalizedPath(ImmutableInterOperableTable.asKey(aPath)));
    }

    default public List<String> sortedKeys(Object ... aPathElements) {
        return this.sortedKeys(this.toPath(aPathElements));
    }

    default public List<String> sortedKeys(String ... aPathElements) {
        return this.sortedKeys(this.toPath(aPathElements));
    }

    default public List<String> sortedKeys(String aPath) {
        ArrayList<String> theKeys = new ArrayList<String>(this.keySet(aPath));
        theKeys.sort(new PathComparator(this.getDelimiter(), PathSortStrategy.DEFAULT));
        return theKeys;
    }

    default public List<String> sortedKeys(PathSortStrategy aPathSortStrategy) {
        ArrayList<String> theKeys = new ArrayList<String>(this.keySet());
        theKeys.sort(new PathComparator(this.getDelimiter(), aPathSortStrategy));
        return theKeys;
    }

    default public List<String> sortedKeys(PathSortStrategy aPathSortStrategy, Collection<?> aPathElements) {
        return this.sortedKeys(aPathSortStrategy, this.toPath(aPathElements));
    }

    default public List<String> sortedKeys(PathSortStrategy aPathSortStrategy, Object aPath) {
        return this.sortedKeys(aPathSortStrategy, this.toPath(aPath));
    }

    default public List<String> sortedKeys(PathSortStrategy aPathSortStrategy, Object ... aPathElements) {
        return this.sortedKeys(aPathSortStrategy, this.toPath(aPathElements));
    }

    default public List<String> sortedKeys(PathSortStrategy aPathSortStrategy, String ... aPathElements) {
        return this.sortedKeys(aPathSortStrategy, this.toPath(aPathElements));
    }

    default public List<String> sortedKeys(PathSortStrategy aPathSortStrategy, String aPath) {
        ArrayList<String> theKeys = new ArrayList<String>(this.keySet(aPath));
        theKeys.sort(new PathComparator(this.getDelimiter(), PathSortStrategy.DEFAULT));
        return theKeys;
    }

    default public List<String> sortedKeys(Comparator<String> aComparator) {
        ArrayList<String> theKeys = new ArrayList<String>(this.keySet());
        theKeys.sort(aComparator);
        return theKeys;
    }

    default public List<String> sortedKeys(Comparator<String> aComparator, Collection<?> aPathElements) {
        return this.sortedKeys(aComparator, this.toPath(aPathElements));
    }

    default public List<String> sortedKeys(Comparator<String> aComparator, Object aPath) {
        return this.sortedKeys(aComparator, this.toPath(aPath));
    }

    default public List<String> sortedKeys(Comparator<String> aComparator, Object ... aPathElements) {
        return this.sortedKeys(aComparator, this.toPath(aPathElements));
    }

    default public List<String> sortedKeys(Comparator<String> aComparator, String ... aPathElements) {
        return this.sortedKeys(aComparator, this.toPath(aPathElements));
    }

    default public List<String> sortedKeys(Comparator<String> aComparator, String aPath) {
        ArrayList<String> theKeys = new ArrayList<String>(this.keySet(aPath));
        theKeys.sort(aComparator);
        return theKeys;
    }

    default public Object toDataStructure() {
        return this.toDataStructure(this.getRootPath());
    }

    public Object toDataStructure(String var1);

    default public String toExternalPath(String aPath, char aDelimiter) {
        if (aPath != null) {
            aPath = this.toNormalizedPath(aPath);
            if (aDelimiter != Delimiter.PATH.getChar() && aDelimiter != Delimiter.DOS_PATH.getChar()) {
                while (aPath.startsWith("" + this.getDelimiter())) {
                    aPath = aPath.substring(1);
                }
            }
            if (aDelimiter != this.getDelimiter()) {
                aPath = aPath.replace(this.getDelimiter(), aDelimiter);
            }
        }
        return aPath;
    }

    default public <TYPE> void toInstance(String aFromPath, TYPE aInstance) {
        try {
            TypeUtility.updateInstance(this.toDataStructure(aFromPath), aInstance);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            throw new IllegalArgumentException("Cannot update the instance of type <" + aInstance.getClass().getName() + "> from path <" + aFromPath + ">!", e);
        }
    }

    default public <TYPE> void toInstance(TYPE aInstance) {
        this.toInstance(this.getRootPath(), aInstance);
    }

    default public String toLeaf(String aPath) {
        String theLeaf = null;
        String[] theElements = this.toPathElements(aPath);
        if (theElements != null && theElements.length != 0) {
            theLeaf = theElements[theElements.length - 1];
        }
        return theLeaf;
    }

    default public Map<String, ?> toMap() {
        return this.toMap(this.getRootPath());
    }

    default public Map<String, ?> toMap(String aFromPath) {
        aFromPath = StructureUtility.toGenericPath(this, aFromPath);
        HashMap theMap = new HashMap();
        Set theKeySet = this.keySet();
        ArrayList theKeys = new ArrayList(theKeySet);
        Collections.sort(theKeys);
        for (String ePath : theKeys) {
            String eTail;
            String[] ePathArray;
            if (!ePath.startsWith(aFromPath) || ePath.length() <= aFromPath.length() || (ePathArray = (eTail = ePath.substring(aFromPath.length() + 1)).split(this.getRootPath())).length <= 0) continue;
            Map<String, Object[]> eMap = theMap;
            int ePathDepth = 0;
            Iterator<String> e = Arrays.asList(ePathArray).iterator();
            while (e.hasNext()) {
                List<Object> toList;
                Object toObj;
                String ePathElement = e.next();
                ++ePathDepth;
                if (e.hasNext()) {
                    try {
                        Map toMap;
                        toObj = eMap.get(ePathElement);
                        if (toObj != null) {
                            toMap = null;
                            if (toObj instanceof Map) {
                                eMap = (Map)toObj;
                                continue;
                            }
                            if (toObj.getClass().isArray()) {
                                Object[] toArray;
                                for (Object eElement : toArray = (Object[])toObj) {
                                    if (!(eElement instanceof Map)) continue;
                                    toMap = (Map)eElement;
                                    break;
                                }
                                if (toMap == null) {
                                    toList = Arrays.asList(toArray);
                                    toMap = new HashMap();
                                    toList.add(toMap);
                                    eMap.put(ePathElement, toList.toArray());
                                    eMap = toMap;
                                    continue;
                                }
                                eMap = toMap;
                                continue;
                            }
                            ArrayList<Object> toList2 = new ArrayList<Object>();
                            toList2.add(toObj);
                            toMap = new HashMap();
                            toList2.add(toMap);
                            eMap.put(ePathElement, toList2.toArray());
                            eMap = toMap;
                            continue;
                        }
                        toMap = new HashMap();
                        eMap.put(ePathElement, (Object[])toMap);
                        eMap = toMap;
                        continue;
                    }
                    catch (ClassCastException ex) {
                        throw new IllegalStateException("There is already a value for path element <" + ePathElement + "> (at a path depth of <" + ePathDepth + ">) in the path <" + ePath + ">, unable to create an according nested Map in that position for succeeding path elements!");
                    }
                }
                toObj = eMap.get(ePathElement);
                Object fromValue = this.get((Object)ePath);
                if (toObj != null) {
                    Object toMap = null;
                    if (toObj.getClass().isArray()) {
                        Object[] toArray = (Object[])toObj;
                        List<Object> toList3 = Arrays.asList(toArray);
                        toList3.add(fromValue);
                        eMap.put(ePathElement, toList3.toArray());
                        eMap = toMap;
                        continue;
                    }
                    toList = new ArrayList();
                    toList.add(toObj);
                    toList.add(fromValue);
                    eMap.put(ePathElement, toList.toArray());
                    continue;
                }
                eMap.put(ePathElement, (Object[])fromValue);
            }
        }
        return theMap;
    }

    default public String toNormalizedPath(String aPath) {
        if (aPath != null) {
            String theDouble = "" + this.getDelimiter() + this.getDelimiter();
            while (((String)aPath).contains(theDouble)) {
                aPath = ((String)aPath).replaceAll(Pattern.quote(theDouble), "" + this.getDelimiter());
            }
            if (!((String)aPath).startsWith("" + this.getDelimiter())) {
                aPath = this.getDelimiter() + (String)aPath;
            }
            while (((String)aPath).endsWith("" + this.getDelimiter())) {
                aPath = ((String)aPath).substring(0, ((String)aPath).length() - 1);
            }
        }
        if (aPath == null || ((String)aPath).isEmpty()) {
            aPath = this.getRootPath();
        }
        return aPath;
    }

    default public String toParentPath(String aPath) {
        if ((aPath = this.toNormalizedPath(aPath)) != null && aPath.equals(this.getRootPath())) {
            throw new IllegalArgumentException("The path \"" + aPath + "\" does not have a parent path!");
        }
        int index = aPath.lastIndexOf(this.getDelimiter());
        if ((aPath = aPath.substring(0, index)).isEmpty()) {
            aPath = this.getRootPath();
        }
        return aPath;
    }

    default public String toPath(Collection<?> aPathElements) {
        if (aPathElements != null) {
            return this.toPath(aPathElements.toArray(new Object[aPathElements.size()]));
        }
        return null;
    }

    default public String toPath(Object aPath) {
        return this.toNormalizedPath(aPath instanceof String ? (String)aPath : (aPath != null ? aPath.toString() : (String)null));
    }

    default public String toPath(Object ... aPathElements) {
        StringBuilder theBuffer = new StringBuilder();
        for (Object eElement : aPathElements) {
            String eStrElement;
            if (eElement == null) continue;
            if (eElement instanceof Collection) {
                eStrElement = this.toPath((Collection)eElement);
            } else if (eElement instanceof Object[]) {
                eStrElement = this.toPath((Object[])eElement);
            } else {
                String string = eElement instanceof String ? (String)eElement : (eStrElement = eElement != null ? eElement.toString() : null);
            }
            while (eStrElement != null && eStrElement.length() > 0 && eStrElement.charAt(0) == this.getDelimiter()) {
                eStrElement = eStrElement.substring(1);
            }
            while (eStrElement != null && eStrElement.length() > 0 && eStrElement.charAt(eStrElement.length() - 1) == this.getDelimiter()) {
                eStrElement = eStrElement.substring(0, eStrElement.length() - 1);
            }
            theBuffer.append(eStrElement);
            theBuffer.append(this.getDelimiter());
        }
        return this.toNormalizedPath(theBuffer.toString());
    }

    default public String toPath(String ... aPathElements) {
        StringBuilder theBuffer = new StringBuilder();
        String[] stringArray = aPathElements;
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            String eElement;
            for (eElement = stringArray[i]; eElement != null && eElement.length() > 0 && eElement.charAt(0) == this.getDelimiter(); eElement = eElement.substring(1)) {
            }
            while (eElement != null && eElement.length() > 0 && eElement.charAt(eElement.length() - 1) == this.getDelimiter()) {
                eElement = eElement.substring(0, eElement.length() - 1);
            }
            theBuffer.append(eElement);
            theBuffer.append(this.getDelimiter());
        }
        return this.toNormalizedPath(theBuffer.toString());
    }

    default public String[] toPathElements(String aPath) {
        String[] theElements = null;
        if (aPath != null && aPath.length() != 0) {
            while (aPath.startsWith(this.getRootPath())) {
                aPath = aPath.substring(1);
            }
            while (aPath.endsWith(this.getRootPath())) {
                aPath = aPath.substring(0, aPath.length() - 1);
            }
            if (aPath.length() != 0) {
                theElements = aPath.split(Pattern.quote("" + this.getDelimiter()));
            }
        }
        return theElements;
    }

    default public List<String> toPathList(String aPath) {
        return new ArrayList<String>(Arrays.asList(this.toPathElements(aPath)));
    }

    default public Stack<String> toPathStack(String aPath) {
        Stack<String> theStack = new Stack<String>();
        String[] thePathElements = this.toPathElements(aPath);
        if (thePathElements != null) {
            theStack.addAll(Arrays.asList(thePathElements));
        }
        return theStack;
    }

    default public String toPropertyPath(String aPath) {
        if (aPath != null) {
            while (aPath.startsWith(this.getRootPath())) {
                aPath = aPath.substring(1);
            }
            while (aPath.endsWith(this.getRootPath())) {
                aPath = aPath.substring(0, aPath.length() - 1);
            }
            return aPath;
        }
        return null;
    }

    default public <TYPE> TYPE toType(Class<TYPE> aType) {
        return this.toType(this.getRootPath(), aType);
    }

    default public <TYPE> TYPE toType(Object aFromPath, Class<TYPE> aType) {
        return this.toType(this.toNormalizedPath(ImmutableInterOperableTable.asKey(aFromPath)), aType);
    }

    default public <TYPE> TYPE toType(Object[] aFromPathElements, Class<TYPE> aType) {
        return this.toType(this.toPath(aFromPathElements), aType);
    }

    default public <TYPE> TYPE toType(Class<TYPE> aType, Object ... aFromPathElements) {
        return this.toType(this.toPath(aFromPathElements), aType);
    }

    default public <TYPE> TYPE toType(String[] aFromPathElements, Class<TYPE> aType) {
        return this.toType(this.toPath(aFromPathElements), aType);
    }

    default public <TYPE> TYPE toType(Class<TYPE> aType, String ... aFromPathElements) {
        return this.toType(this.toPath(aFromPathElements), aType);
    }

    default public <TYPE> TYPE toType(Collection<?> aFromPathElements, Class<TYPE> aType) {
        return this.toType(this.toPath(aFromPathElements), aType);
    }

    default public <TYPE> TYPE toType(String aFromPath, Class<TYPE> aType) {
        try {
            Map theMap;
            Object theDataStructure = this.get((Object)aFromPath);
            if (theDataStructure != null) {
                try {
                    Class theType;
                    if (theDataStructure instanceof String) {
                        theType = Class.forName((String)theDataStructure);
                        if (theType != null && aType.isAssignableFrom(theType)) {
                            aType = theType;
                        }
                    } else if (theDataStructure instanceof Class && aType.isAssignableFrom(theType = (Class)theDataStructure)) {
                        aType = theType;
                    }
                }
                catch (Exception theType) {
                    // empty catch block
                }
            }
            theDataStructure = this.toMap(aFromPath);
            if (SimpleType.isSimpleType(aType) && this.getRootPath().equals(aFromPath) && theDataStructure instanceof Map && (theMap = (Map)theDataStructure).size() == 1 && theMap.containsKey("")) {
                return (TYPE)TypeUtility.toType(theMap.get(""), aType);
            }
            return TypeUtility.toType(theDataStructure, aType);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            throw new IllegalArgumentException("Cannot create an instance of type <" + aType.getName() + "> from path <" + aFromPath + ">!", e);
        }
    }

    public static interface MutablePathTable<T>
    extends ImmutablePathTable<T>,
    ImmutableTable.MutableTable<String, T>,
    Map<String, T> {
        default public void add(Collection<?> aPathElements, T aValue) {
            this.add(this.toPath(aPathElements), aValue);
        }

        default public void add(Object aPath, T aValue) {
            this.add(this.toPath(aPath), aValue);
        }

        default public void add(Object[] aPathElements, T aValue) {
            this.add(this.toPath(aPathElements), aValue);
        }

        default public void add(String aPath, T aValue) {
            if (this.containsKey((Object)aPath)) {
                int index;
                Object theValue = this.remove((Object)aPath);
                if (this.isArray(aPath)) {
                    index = this.lastArrayIndex(aPath);
                    if (index == -1) {
                        index = 0;
                    }
                } else {
                    index = 0;
                }
                this.putValueAt(aPath, index, theValue);
                this.appendValueTo(aPath, aValue);
            } else if (this.isArray(aPath)) {
                this.appendValueTo(aPath, aValue);
            } else {
                this.put(aPath, aValue);
            }
        }

        default public void add(String[] aPathElements, T aValue) {
            this.add(this.toPath(aPathElements), aValue);
        }

        default public void add(T aValue) {
            this.add(this.getRootPath(), aValue);
        }

        default public void appendDirTo(Collection<?> aPathElements, Object aDir) {
            this.appendDirTo(this.toPath(aPathElements), aDir);
        }

        default public void appendDirTo(Collection<?> aPathElements, ImmutablePathTable<T> aDir) {
            this.appendDirTo(this.toPath(aPathElements), aDir);
        }

        default public void appendDirTo(Object aDir) {
            this.appendDirTo(this.getRootPath(), aDir);
        }

        default public void appendDirTo(Object aPath, Object aDir) {
            this.appendDirTo(this.toPath(aPath), (ImmutablePathTable<T>)new MapPathTable(aDir, this.getDelimiter(), this.getType()));
        }

        default public void appendDirTo(Object aPath, ImmutablePathTable<T> aDir) {
            this.appendDirTo(this.toPath(aPath), aDir);
        }

        default public void appendDirTo(Object[] aPathElements, Object aDir) {
            this.appendDirTo(this.toPath(aPathElements), aDir);
        }

        default public void appendDirTo(Object[] aPathElements, ImmutablePathTable<T> aDir) {
            this.appendDirTo(this.toPath(aPathElements), aDir);
        }

        default public void appendDirTo(ImmutablePathTable<T> aDir) {
            this.appendDirTo(this.getRootPath(), aDir);
        }

        default public void appendDirTo(String aPath, Object aDir) {
            this.appendDirTo(aPath, (ImmutablePathTable<T>)new MapPathTable(aDir, this.getDelimiter(), this.getType()));
        }

        default public void appendDirTo(String aPath, ImmutablePathTable<T> aDir) {
            int nextIndex = this.nextDirIndex(aPath);
            for (String eKey : aDir.keySet()) {
                this.put(this.toPath(aPath, nextIndex, eKey), aDir.get((Object)eKey));
            }
        }

        default public void appendDirTo(String[] aPathElements, Object aDir) {
            this.appendDirTo(this.toPath(aPathElements), aDir);
        }

        default public void appendDirTo(String[] aPathElements, ImmutablePathTable<T> aDir) {
            this.appendDirTo(this.toPath(aPathElements), aDir);
        }

        default public void appendValueTo(Collection<?> aPathElements, T aValue) {
            this.appendValueTo(this.toPath(aPathElements), aValue);
        }

        default public void appendValueTo(Object aPath, T aValue) {
            this.appendValueTo(this.toPath(aPath), aValue);
        }

        default public void appendValueTo(Object[] aPathElements, T aValue) {
            this.appendValueTo(this.toPath(aPathElements), aValue);
        }

        default public void appendValueTo(String aPath, T aValue) {
            int nextIndex = this.nextArrayIndex(aPath);
            this.put(this.toPath(aPath, nextIndex), aValue);
        }

        default public void appendValueTo(String[] aPathElements, T aValue) {
            this.appendValueTo(this.toPath(aPathElements), aValue);
        }

        default public void appendValueTo(T aValue) {
            this.appendValueTo(this.getRootPath(), aValue);
        }

        default public T delete(Collection<?> aPathElements) {
            return (T)this.remove((Object)this.toPath(aPathElements));
        }

        default public T delete(Object aPath) {
            return (T)this.remove((Object)this.toPath(aPath));
        }

        default public T delete(Object[] aPathElements) {
            return (T)this.remove((Object)this.toPath(aPathElements));
        }

        @Override
        default public T delete(String aPath) {
            return (T)this.remove((Object)aPath);
        }

        default public T delete(String[] aPathElements) {
            return (T)this.remove((Object)this.toPath(aPathElements));
        }

        public void insert(Object var1);

        default public void insert(PathTable<T> aFrom) {
            this.insert((Object)aFrom);
        }

        default public void insertBetween(Collection<?> aToPathElements, Object aFrom, Collection<?> aFromPathElements) {
            this.insertBetween(this.toPath(aToPathElements), aFrom, this.toPath(aFromPathElements));
        }

        default public void insertBetween(Collection<?> aToPathElements, ImmutablePathTable<T> aFrom, Collection<?> aFromPathElements) {
            this.insertBetween(this.toPath(aToPathElements), (Object)aFrom, this.toPath(aFromPathElements));
        }

        default public void insertBetween(Object aToPath, Object aFrom, Object aFromPath) {
            this.insertBetween(this.toNormalizedPath(ImmutableInterOperableTable.asKey(aToPath)), aFrom, this.toNormalizedPath(ImmutableInterOperableTable.asKey(aFromPath)));
        }

        default public void insertBetween(Object aToPath, ImmutablePathTable<T> aFromTable, Object aFromPath) {
            this.insertBetween(this.toNormalizedPath(ImmutableInterOperableTable.asKey(aToPath)), (Object)aFromTable, this.toNormalizedPath(ImmutableInterOperableTable.asKey(aFromPath)));
        }

        default public void insertBetween(Object[] aToPathElements, Object aFrom, Object[] aFromPathElements) {
            this.insertBetween(this.toPath(aToPathElements), aFrom, this.toPath(aFromPathElements));
        }

        default public void insertBetween(Object[] aToPathElements, ImmutablePathTable<T> aFrom, Object[] aFromPathElements) {
            this.insertBetween(this.toPath(aToPathElements), (Object)aFrom, this.toPath(aFromPathElements));
        }

        public void insertBetween(String var1, Object var2, String var3);

        default public void insertBetween(String aToPath, ImmutablePathTable<T> aFrom, String aFromPath) {
            this.insertBetween(aToPath, (Object)aFrom, aFromPath);
        }

        default public void insertBetween(String[] aToPathElements, Object aFrom, String[] aFromPathElements) {
            this.insertBetween(this.toPath(aToPathElements), aFrom, this.toPath(aFromPathElements));
        }

        default public void insertBetween(String[] aToPathElements, ImmutablePathTable<T> aFrom, String[] aFromPathElements) {
            this.insertBetween(this.toPath(aToPathElements), (Object)aFrom, this.toPath(aFromPathElements));
        }

        default public void insertFrom(Object aFrom, Collection<?> aFromPathElements) {
            this.insertFrom(aFrom, this.toPath(aFromPathElements));
        }

        default public void insertFrom(Object aFrom, Object aFromPath) {
            this.insertFrom(aFrom, this.toPath(aFromPath));
        }

        default public void insertFrom(Object aFrom, Object ... aFromPathElements) {
            this.insertFrom(aFrom, this.toPath(aFromPathElements));
        }

        public void insertFrom(Object var1, String var2);

        default public void insertFrom(Object aFrom, String ... aFromPathElements) {
            this.insertFrom(aFrom, this.toPath(aFromPathElements));
        }

        default public void insertFrom(PathTable<T> aFrom, Collection<?> aFromPathElements) {
            this.insertFrom((Object)aFrom, this.toPath(aFromPathElements));
        }

        default public void insertFrom(PathTable<T> aFrom, Object aFromPath) {
            this.insertFrom((Object)aFrom, this.toPath(aFromPath));
        }

        default public void insertFrom(PathTable<T> aFrom, Object ... aFromPathElements) {
            this.insertFrom((Object)aFrom, this.toPath(aFromPathElements));
        }

        default public void insertFrom(PathTable<T> aFrom, String aFromPath) {
            this.insertFrom((Object)aFrom, aFromPath);
        }

        default public void insertFrom(PathTable<T> aFrom, String ... aFromPathElements) {
            this.insertFrom((Object)aFrom, this.toPath(aFromPathElements));
        }

        default public void insertTo(Collection<?> aToPathElements, Object aFrom) {
            this.insertTo(this.toPath(aToPathElements), aFrom);
        }

        default public void insertTo(Collection<?> aToPathElements, ImmutablePathTable<T> aFrom) {
            this.insertTo(this.toPath(aToPathElements), (Object)aFrom);
        }

        default public void insertTo(Object aToPath, Object aFrom) {
            this.insertTo(this.toNormalizedPath(ImmutableInterOperableTable.asKey(aToPath)), aFrom);
        }

        default public void insertTo(Object aToPath, ImmutablePathTable<T> aFromTable) {
            this.insertTo(this.toNormalizedPath(ImmutableInterOperableTable.asKey(aToPath)), (Object)aFromTable);
        }

        default public void insertTo(Object[] aToPathElements, Object aFrom) {
            this.insertTo(this.toPath(aToPathElements), aFrom);
        }

        default public void insertTo(Object[] aToPathElements, ImmutablePathTable<T> aFrom) {
            this.insertTo(this.toPath(aToPathElements), (Object)aFrom);
        }

        public void insertTo(String var1, Object var2);

        default public void insertTo(String aToPath, ImmutablePathTable<T> aFrom) {
            this.insertTo(aToPath, (Object)aFrom);
        }

        default public void insertTo(String[] aToPathElements, Object aFrom) {
            this.insertTo(this.toPath(aToPathElements), aFrom);
        }

        default public void insertTo(String[] aToPathElements, ImmutablePathTable<T> aFrom) {
            this.insertTo(this.toPath(aToPathElements), (Object)aFrom);
        }

        public void merge(Object var1);

        default public void merge(PathTable<T> aFrom) {
            this.merge((Object)aFrom);
        }

        default public void mergeBetween(Collection<?> aToPathElements, Object aFrom, Collection<?> aFromPathElements) {
            this.mergeBetween(this.toPath(aToPathElements), aFrom, this.toPath(aFromPathElements));
        }

        default public void mergeBetween(Collection<?> aToPathElements, ImmutablePathTable<T> aFrom, Collection<?> aFromPathElements) {
            this.mergeBetween(this.toPath(aToPathElements), (Object)aFrom, this.toPath(aFromPathElements));
        }

        default public void mergeBetween(Object aToPath, Object aFromObj, Object aFromPath) {
            this.mergeBetween(this.toNormalizedPath(ImmutableInterOperableTable.asKey(aToPath)), aFromObj, this.toNormalizedPath(ImmutableInterOperableTable.asKey(aFromPath)));
        }

        default public void mergeBetween(Object aToPath, ImmutablePathTable<T> aFromTable, Object aFromPath) {
            this.mergeBetween(this.toNormalizedPath(ImmutableInterOperableTable.asKey(aToPath)), (Object)aFromTable, this.toNormalizedPath(ImmutableInterOperableTable.asKey(aFromPath)));
        }

        default public void mergeBetween(Object[] aToPathElements, Object aFrom, Object[] aFromPathElements) {
            this.mergeBetween(this.toPath(aToPathElements), aFrom, this.toPath(aFromPathElements));
        }

        default public void mergeBetween(Object[] aToPathElements, ImmutablePathTable<T> aFrom, Object[] aFromPathElements) {
            this.mergeBetween(this.toPath(aToPathElements), (Object)aFrom, this.toPath(aFromPathElements));
        }

        public void mergeBetween(String var1, Object var2, String var3);

        default public void mergeBetween(String aToPath, ImmutablePathTable<T> aFrom, String aFromPath) {
            this.mergeBetween(aToPath, (Object)aFrom, aFromPath);
        }

        default public void mergeBetween(String[] aToPathElements, Object aFrom, String[] aFromPathElements) {
            this.mergeBetween(this.toPath(aToPathElements), aFrom, this.toPath(aFromPathElements));
        }

        default public void mergeBetween(String[] aToPathElements, ImmutablePathTable<T> aFrom, String[] aFromPathElements) {
            this.mergeBetween(this.toPath(aToPathElements), (Object)aFrom, this.toPath(aFromPathElements));
        }

        default public void mergeFrom(Object aFrom, Collection<?> aFromPathElements) {
            this.mergeFrom(aFrom, this.toPath(aFromPathElements));
        }

        default public void mergeFrom(Object aFrom, Object aFromPath) {
            this.mergeFrom(aFrom, this.toPath(aFromPath));
        }

        default public void mergeFrom(Object aFrom, Object ... aFromPathElements) {
            this.mergeFrom(aFrom, this.toPath(aFromPathElements));
        }

        public void mergeFrom(Object var1, String var2);

        default public void mergeFrom(Object aFrom, String ... aFromPathElements) {
            this.mergeFrom(aFrom, this.toPath(aFromPathElements));
        }

        default public void mergeFrom(PathTable<T> aFrom, Collection<?> aFromPathElements) {
            this.mergeFrom((Object)aFrom, this.toPath(aFromPathElements));
        }

        default public void mergeFrom(PathTable<T> aFrom, Object aFromPath) {
            this.mergeFrom((Object)aFrom, this.toPath(aFromPath));
        }

        default public void mergeFrom(PathTable<T> aFrom, Object ... aFromPathElements) {
            this.mergeFrom((Object)aFrom, this.toPath(aFromPathElements));
        }

        default public void mergeFrom(PathTable<T> aFrom, String aFromPath) {
            this.mergeFrom((Object)aFrom, aFromPath);
        }

        default public void mergeFrom(PathTable<T> aFrom, String ... aFromPathElements) {
            this.mergeFrom((Object)aFrom, this.toPath(aFromPathElements));
        }

        default public void mergeTo(Collection<?> aToPathElements, Object aFrom) {
            this.mergeTo(this.toPath(aToPathElements), aFrom);
        }

        default public void mergeTo(Collection<?> aToPathElements, ImmutablePathTable<T> aFrom) {
            this.mergeTo(this.toPath(aToPathElements), (Object)aFrom);
        }

        default public void mergeTo(Object aToPath, Object aFromObj) {
            this.mergeTo(this.toNormalizedPath(ImmutableInterOperableTable.asKey(aToPath)), aFromObj);
        }

        default public void mergeTo(Object aToPath, ImmutablePathTable<T> aFromTable) {
            this.mergeTo(this.toNormalizedPath(ImmutableInterOperableTable.asKey(aToPath)), (Object)aFromTable);
        }

        default public void mergeTo(Object[] aToPathElements, Object aFrom) {
            this.mergeTo(this.toPath(aToPathElements), aFrom);
        }

        default public void mergeTo(Object[] aToPathElements, ImmutablePathTable<T> aFrom) {
            this.mergeTo(this.toPath(aToPathElements), (Object)aFrom);
        }

        public void mergeTo(String var1, Object var2);

        default public void mergeTo(String aToPath, ImmutablePathTable<T> aFrom) {
            this.mergeTo(aToPath, (Object)aFrom);
        }

        default public void mergeTo(String[] aToPathElements, Object aFrom) {
            this.mergeTo(this.toPath(aToPathElements), aFrom);
        }

        default public void mergeTo(String[] aToPathElements, ImmutablePathTable<T> aFrom) {
            this.mergeTo(this.toPath(aToPathElements), (Object)aFrom);
        }

        @Override
        default public T put(Collection<?> aPathElements, T aValue) {
            return this.put(this.toPath(aPathElements), aValue);
        }

        @Override
        default public T put(Object[] aPathElements, T aValue) {
            return this.put(this.toPath(aPathElements), aValue);
        }

        @Override
        default public T put(Relation<String, T> aRelation) {
            return (T)this.put((String)aRelation.getKey(), aRelation.getValue());
        }

        @Override
        default public T put(String[] aPathElements, T aValue) {
            return this.put(this.toPath(aPathElements), aValue);
        }

        default public T[] putArray(Collection<?> aPathElements, Collection<T> aValues) {
            return this.putArray(this.toPath(aPathElements), aValues);
        }

        default public T[] putArray(Collection<?> aPathElements, T[] aValues) {
            return this.putArray(this.toPath(aPathElements), aValues);
        }

        default public T[] putArray(Collection<T> aValues) {
            return this.putArray("", aValues);
        }

        default public T[] putArray(Object aPath, Collection<T> aValues) {
            return this.putArray(this.toPath(aPath), aValues);
        }

        default public T[] putArray(Object aPath, T[] aValues) {
            return this.putArray(this.toPath(aPath), aValues);
        }

        default public T[] putArray(Object[] aPathElements, Collection<T> aValues) {
            return this.putArray(this.toPath(aPathElements), aValues);
        }

        default public T[] putArray(Object[] aPathElements, T[] aValues) {
            return this.putArray(this.toPath(aPathElements), aValues);
        }

        default public T[] putArray(String aPath, Collection<T> aValues) {
            aPath = this.toNormalizedPath(aPath);
            T[] theResult = this.getArray(aPath);
            this.removeFrom(aPath);
            if (aValues != null && aValues.size() != 0) {
                int index = 0;
                Iterator<T> e = aValues.iterator();
                while (e.hasNext()) {
                    this.putValueAt(aPath, index++, e.next());
                }
            }
            return theResult;
        }

        default public T[] putArray(String aPath, T[] aValues) {
            aPath = this.toNormalizedPath(aPath);
            T[] theResult = this.getArray(aPath);
            this.removeFrom(aPath);
            if (aValues != null && aValues.length != 0) {
                for (int i = 0; i < aValues.length; ++i) {
                    this.putValueAt(aPath, i, aValues[i]);
                }
            }
            return theResult;
        }

        default public T[] putArray(String[] aPathElements, Collection<T> aValues) {
            return this.putArray(this.toPath(aPathElements), aValues);
        }

        default public T[] putArray(String[] aPathElements, T[] aValues) {
            return this.putArray(this.toPath(aPathElements), aValues);
        }

        default public T[] putArray(T[] aValues) {
            return this.putArray("", aValues);
        }

        default public PathTable<T> putDirAt(Collection<?> aPathElements, int aIndex, Object aDir) {
            return this.putDirAt(this.toPath(aPathElements), aIndex, aDir);
        }

        default public PathTable<T> putDirAt(Collection<?> aPathElements, int aIndex, ImmutablePathTable<T> aDir) {
            return this.putDirAt(this.toPath(aPathElements), aIndex, aDir);
        }

        default public PathTable<T> putDirAt(int aIndex, Object aDir) {
            return this.putDirAt(this.getRootPath(), aIndex, aDir);
        }

        default public PathTable<T> putDirAt(int aIndex, ImmutablePathTable<T> aDir) {
            return this.putDirAt(this.getRootPath(), aIndex, aDir);
        }

        default public PathTable<T> putDirAt(Object aPath, int aIndex, Object aDir) {
            return this.putDirAt(this.toPath(aPath), aIndex, aDir);
        }

        default public PathTable<T> putDirAt(Object aPath, int aIndex, ImmutablePathTable<T> aDir) {
            return this.putDirAt(this.toPath(aPath), aIndex, aDir);
        }

        default public PathTable<T> putDirAt(Object[] aPathElements, int aIndex, Object aDir) {
            return this.putDirAt(this.toPath(aPathElements), aIndex, aDir);
        }

        default public PathTable<T> putDirAt(Object[] aPathElements, int aIndex, ImmutablePathTable<T> aDir) {
            return this.putDirAt(this.toPath(aPathElements), aIndex, aDir);
        }

        default public PathTable<T> putDirAt(String aPath, int aIndex, Object aDir) {
            PathTable<T> theReplaced = this.removeDirAt(aPath, aIndex);
            this.insertTo(this.toPath(aPath, aIndex), aDir);
            return theReplaced;
        }

        default public PathTable<T> putDirAt(String aPath, int aIndex, ImmutablePathTable<T> aDir) {
            PathTable<T> theReplaced = this.removeDirAt(aPath, aIndex);
            this.insertTo(this.toPath(aPath, aIndex), aDir);
            return theReplaced;
        }

        default public PathTable<T> putDirAt(String[] aPathElements, int aIndex, Object aDir) {
            return this.putDirAt(this.toPath(aPathElements), aIndex, aDir);
        }

        default public PathTable<T> putDirAt(String[] aPathElements, int aIndex, ImmutablePathTable<T> aDir) {
            return this.putDirAt(this.toPath(aPathElements), aIndex, aDir);
        }

        default public T putValueAt(Collection<?> aPathElements, int aIndex, T aValue) {
            String thePath = this.toPath(aPathElements, aIndex);
            return this.put(thePath, aValue);
        }

        default public T putValueAt(int aIndex, T aValue) {
            String thePath = this.toPath((Object)aIndex);
            return this.put(thePath, aValue);
        }

        default public T putValueAt(Object aPath, int aIndex, T aValue) {
            String thePath = this.toPath(aPath, aIndex);
            return this.put(thePath, aValue);
        }

        default public T putValueAt(Object[] aPathElements, int aIndex, T aValue) {
            String thePath = this.toPath(aPathElements, aIndex);
            return this.put(thePath, aValue);
        }

        default public T putValueAt(String aPath, int aIndex, T aValue) {
            String thePath = this.toPath(aPath, aIndex);
            return this.put(thePath, aValue);
        }

        default public T putValueAt(String[] aPathElements, int aIndex, T aValue) {
            String thePath = this.toPath(aPathElements, aIndex);
            return this.put(thePath, aValue);
        }

        default public T remove(Object ... aPathElements) {
            return (T)this.remove((Object)this.toPath(aPathElements));
        }

        default public T remove(String ... aPathElements) {
            return (T)this.remove((Object)this.toPath(aPathElements));
        }

        default public T remove(String aPathElement1, String aPathElement2) {
            return (T)this.remove((Object)this.toPath(aPathElement1, aPathElement2));
        }

        default public PathTable<T> removeAll(Collection<?> aPathQueryElements) {
            return this.removeAll(this.toPath(aPathQueryElements));
        }

        default public PathTable<T> removeAll(Object ... aPathQueryElements) {
            return this.removeAll(this.toPath(aPathQueryElements));
        }

        default public PathTable<T> removeAll(Object aPathQuery) {
            return this.removeAll(this.toPath(aPathQuery));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        default public PathTable<T> removeAll(Pattern aRegExp) {
            HashSet<String> theSet = new HashSet<String>();
            for (String ePath : this.paths()) {
                if (!aRegExp.matcher(ePath).matches()) continue;
                HashSet<String> hashSet = theSet;
                synchronized (hashSet) {
                    theSet.add(ePath);
                }
            }
            return this.removePaths(theSet);
        }

        default public PathTable<T> removeAll(String ... aPathQueryElements) {
            return this.removeAll(this.toPath(aPathQueryElements));
        }

        default public PathTable<T> removeAll(String aPathQuery) {
            HashSet<String> theSet = new HashSet<String>();
            Pattern thePattern = new PathPattern(aPathQuery, this.getDelimiter()).getPattern();
            for (String ePath : this.paths()) {
                if (!thePattern.matcher(ePath).matches()) continue;
                theSet.add(ePath);
            }
            return this.removePaths(theSet);
        }

        default public PathTable<T> removeDirAt(int aIndex) {
            return this.removeDirAt(this.getRootPath(), aIndex);
        }

        default public PathTable<T> removeDirAt(Object aPath, int aIndex) {
            return this.removeDirAt(this.toPath(aPath), aIndex);
        }

        default public PathTable<T> removeDirAt(Object[] aPathElements, int aIndex) {
            return this.removeDirAt(this.toPath(aPathElements), aIndex);
        }

        default public PathTable<T> removeDirAt(String aPath, int aIndex) {
            return this.removeFrom(this.toPath(aPath, aIndex));
        }

        default public PathTable<T> removeDirAt(String[] aPathElements, int aIndex) {
            return this.removeDirAt(this.toPath(aPathElements), aIndex);
        }

        default public PathTable<T> removeFrom(Collection<?> aPathElements) {
            return this.removeFrom(this.toPath(aPathElements));
        }

        default public PathTable<T> removeFrom(Object ... aPathElements) {
            return this.removeFrom(this.toPath(aPathElements));
        }

        default public PathTable<T> removeFrom(Object aPath) {
            return this.removeFrom(this.toPath(aPath));
        }

        default public PathTable<T> removeFrom(String aPath) {
            MapPathTable theRemoved = new MapPathTable(this.getDelimiter(), this.getType());
            aPath = this.toNormalizedPath((String)aPath) + this.getDelimiter();
            Iterator<String> e = this.paths().iterator();
            while (e.hasNext()) {
                String eKey = e.next();
                if (!eKey.startsWith((String)aPath)) continue;
                theRemoved.put(eKey.substring(((String)aPath).length()), this.get((Object)eKey));
                e.remove();
            }
            return theRemoved;
        }

        default public PathTable<T> removeFrom(String ... aPathElements) {
            return this.removeFrom(this.toPath(aPathElements));
        }

        default public PathTable<T> removePaths(Collection<?> aPaths) {
            MapPathTable theRemoved = new MapPathTable(this.getDelimiter(), this.getType());
            for (Object ePath : aPaths) {
                theRemoved.put(ePath instanceof String ? (String)ePath : this.toPath(ePath), this.remove(ePath));
            }
            return theRemoved;
        }

        default public PathTable<T> removePaths(String ... aPaths) {
            MapPathTable theRemoved = new MapPathTable(this.getDelimiter(), this.getType());
            for (String ePath : aPaths) {
                theRemoved.put(ePath, this.remove((Object)ePath));
            }
            return theRemoved;
        }

        default public T removeValueAt(int aIndex) {
            return this.removeValueAt(this.getRootPath(), aIndex);
        }

        default public T removeValueAt(Object aPath, int aIndex) {
            return this.removeValueAt(this.toPath(aPath), aIndex);
        }

        default public T removeValueAt(Object[] aPathElements, int aIndex) {
            return this.removeValueAt(this.toPath(aPathElements), aIndex);
        }

        default public T removeValueAt(String aPath, int aIndex) {
            return (T)this.remove((Object)this.toPath(aPath, aIndex));
        }

        default public T removeValueAt(String[] aPathElements, int aIndex) {
            return this.removeValueAt(this.toPath(aPathElements), aIndex);
        }

        default public <TYPE> void fromType(TYPE aType) {
            this.fromType(this.getRootPath(), aType);
        }

        default public <TYPE> void fromType(Object aFromPath, TYPE aType) {
            this.fromType(this.toPath(aFromPath), aType);
        }

        default public <TYPE> void fromType(Object[] aFromPathElements, TYPE aType) {
            this.fromType(this.toPath(aFromPathElements), aType);
        }

        default public <TYPE> void fromType(TYPE aType, Object ... aFromPathElements) {
            this.fromType(this.toPath(aFromPathElements), aType);
        }

        default public <TYPE> void fromType(String[] aFromPathElements, TYPE aType) {
            this.fromType(this.toPath(aFromPathElements), aType);
        }

        default public <TYPE> void fromType(TYPE aType, String ... aFromPathElements) {
            this.fromType(this.toPath(aFromPathElements), aType);
        }

        default public <TYPE> void fromType(Collection<?> aFromPathElements, TYPE aType) {
            this.fromType(this.toPath(aFromPathElements), aType);
        }

        default public <TYPE> void fromType(String aFromPath, TYPE aType) {
            this.insertTo(aFromPath, aType);
        }

        default public String toSourceCode() {
            return this.toSourceCode(null, null);
        }

        default public String toSourceCode(String aClassName, String aPackage) {
            if (aClassName == null || aClassName.isEmpty()) {
                aClassName = "null";
            }
            StringBuilder theBuffer = new StringBuilder();
            if (aPackage != null && aPackage.length() != 0) {
                theBuffer.append("package " + aPackage + ";" + System.lineSeparator());
            }
            theBuffer.append(System.lineSeparator());
            theBuffer.append("import " + this.getClass().getName() + ";" + System.lineSeparator());
            theBuffer.append("import " + this.getType().getName() + ";" + System.lineSeparator());
            theBuffer.append(System.lineSeparator());
            theBuffer.append("public class " + aClassName + " extends " + this.getClass().getSimpleName() + " {" + System.lineSeparator());
            theBuffer.append(System.lineSeparator());
            ArrayList theKeys = new ArrayList(this.keySet());
            Collections.sort(theKeys);
            HashSet<String> theArrays = new HashSet<String>();
            for (String eKey : theKeys) {
                boolean isArray = false;
                if (this.hasParentPath(eKey)) {
                    String eParent = this.toParentPath(eKey);
                    if (theArrays.contains(eParent)) continue;
                    if (this.isArray(eParent)) {
                        theArrays.add(eParent);
                        eKey = eParent;
                        isArray = true;
                    }
                }
                StringBuilder ePropertyBuffer = new StringBuilder();
                boolean hadDelimiter = false;
                for (int i = 0; i < eKey.length(); ++i) {
                    char eChar = eKey.charAt(i);
                    if (eChar == this.getDelimiter()) {
                        hadDelimiter = true;
                        continue;
                    }
                    if (!Character.isAlphabetic(eChar) && !Character.isDigit(eChar)) continue;
                    if (hadDelimiter) {
                        ePropertyBuffer.append(Character.toUpperCase(eChar));
                    } else {
                        ePropertyBuffer.append(eChar);
                    }
                    hadDelimiter = false;
                }
                String ePropertyName = ePropertyBuffer.toString();
                if (isArray) {
                    theBuffer.append("\tpublic " + this.getType().getSimpleName() + "[] get" + ePropertyName + "() {" + System.lineSeparator());
                    theBuffer.append("\t\treturn getArray( \"" + eKey + "\" );" + System.lineSeparator());
                    theBuffer.append("\t}" + System.lineSeparator());
                    theBuffer.append(System.lineSeparator());
                    theBuffer.append("\tpublic void set" + ePropertyName + "(  " + this.getType().getSimpleName() + "[] aValues ) {" + System.lineSeparator());
                    theBuffer.append("\t\tputArray( \"" + eKey + "\", aValues );" + System.lineSeparator());
                    theBuffer.append("\t}" + System.lineSeparator());
                    theBuffer.append(System.lineSeparator());
                    continue;
                }
                theBuffer.append("\tpublic " + this.getType().getSimpleName() + " get" + ePropertyName + "() {" + System.lineSeparator());
                theBuffer.append("\t\treturn get( \"" + eKey + "\" );" + System.lineSeparator());
                theBuffer.append("\t}" + System.lineSeparator());
                theBuffer.append(System.lineSeparator());
                theBuffer.append("\tpublic void set" + ePropertyName + "( " + this.getType().getSimpleName() + " aValue ) {" + System.lineSeparator());
                theBuffer.append("\t\tput( \"" + eKey + "\", aValue );" + System.lineSeparator());
                theBuffer.append("\t}" + System.lineSeparator());
                theBuffer.append(System.lineSeparator());
            }
            theBuffer.append("}");
            return theBuffer.toString();
        }
    }
}

