/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.security.alt.chaos;

import java.io.UnsupportedEncodingException;
import org.refcodes.codec.BaseBuilder;
import org.refcodes.codec.BaseMetricsConfig;
import org.refcodes.data.Encoding;
import org.refcodes.security.EncryptEncodingException;
import org.refcodes.security.Encrypter;
import org.refcodes.security.EncryptionException;
import org.refcodes.security.alt.chaos.ChaosEncrypter;
import org.refcodes.security.alt.chaos.ChaosKey;

public class ChaosTextEncrypter
implements Encrypter<String, String, EncryptionException> {
    private ChaosEncrypter _chaosEncrypter;
    private final BaseBuilder _baseCodec = new BaseBuilder().withBaseMetrics(BaseMetricsConfig.BASE64);

    public ChaosTextEncrypter(ChaosKey aKey) {
        this._chaosEncrypter = new ChaosEncrypter(aKey);
    }

    public ChaosTextEncrypter(ChaosKey aKey, boolean isVerify) {
        this._chaosEncrypter = new ChaosEncrypter(aKey, isVerify);
    }

    @Override
    public String toEncrypted(String aDecrypted) throws EncryptionException {
        byte[] theInput;
        try {
            theInput = aDecrypted.getBytes(Encoding.UTF_8.getCode());
        }
        catch (UnsupportedEncodingException e) {
            throw new EncryptEncodingException("The required encoding <{0}> is not supported!", Encoding.UTF_8.getCode(), e);
        }
        byte[] theOutput = new byte[theInput.length];
        this.toEncrypted(theInput, 0, theInput.length, theOutput, 0);
        return this._baseCodec.toEncodedText(theOutput);
    }

    @Override
    public int toEncrypted(byte[] aInput, int aInputOffset, int aInputLength, byte[] aOutput, int aOutputOffset) throws EncryptionException {
        return this._chaosEncrypter.toEncrypted(aInput, aInputOffset, aInputLength, aOutput, aOutputOffset);
    }

    @Override
    public void dispose() {
        ChaosEncrypter theChaosEncrypter = this._chaosEncrypter;
        if (theChaosEncrypter != null) {
            try {
                theChaosEncrypter.dispose();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this._chaosEncrypter = null;
        }
    }
}

