/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.security.alt.chaos;

import java.io.IOException;
import java.io.OutputStream;
import java.security.SecureRandom;
import org.refcodes.security.EncryptionException;
import org.refcodes.security.EncryptionOutputStream;
import org.refcodes.security.alt.chaos.ChaosEncrypter;
import org.refcodes.security.alt.chaos.ChaosKey;

public class ChaosEncryptionOutputStream
extends EncryptionOutputStream {
    public ChaosEncryptionOutputStream(OutputStream aOutputStream, ChaosKey aKey) throws IOException {
        this(aOutputStream, aKey, false);
    }

    public ChaosEncryptionOutputStream(OutputStream aOutputStream, ChaosKey aKey, boolean isVerify) throws IOException {
        super(ChaosEncryptionOutputStream.toOutputStream(aOutputStream, aKey), ChaosEncryptionOutputStream.toChaosEncrypter(aOutputStream, aKey, isVerify));
    }

    private static OutputStream toOutputStream(OutputStream aOutputStream, ChaosKey aKey) throws IOException {
        return (aKey = aKey.nextVariableLengthChild()) == null ? aOutputStream : new ChaosEncryptionOutputStream(aOutputStream, aKey);
    }

    private static ChaosEncrypter toChaosEncrypter(OutputStream aOutputStream, ChaosKey aKey, boolean isVerify) throws IOException {
        int theFixedLengthChildDepth = aKey.fixedLengthChildDepth();
        ChaosEncrypter theEncrypter = new ChaosEncrypter(aKey, theFixedLengthChildDepth, isVerify);
        try {
            if (aKey.getOptions().hasRndPrefix()) {
                SecureRandom rnd = new SecureRandom();
                byte[] thePrefix = new byte[aKey.getOptions().getRndPrefixSize()];
                rnd.nextBytes(thePrefix);
                thePrefix = theEncrypter.toEncrypted(thePrefix);
                aOutputStream.write(thePrefix);
                aOutputStream.flush();
            }
            if (aKey.getOptions().isSalted()) {
                ChaosKey theSaltKey = ChaosKey.createRndKey();
                byte[] theSalt = theEncrypter.toEncrypted(theSaltKey.getEncoded());
                aOutputStream.write(theSalt);
                aOutputStream.flush();
                return new ChaosEncrypter(theSaltKey, theFixedLengthChildDepth, theEncrypter, isVerify);
            }
        }
        catch (EncryptionException e) {
            throw new IllegalStateException("Encountered an illegal sate while encrypting!", e);
        }
        return theEncrypter;
    }
}

