/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.schema;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.refcodes.exception.ExceptionAccessor;
import org.refcodes.mixin.AliasAccessor;
import org.refcodes.mixin.ChildrenAccessor;
import org.refcodes.mixin.DescriptionAccessor;
import org.refcodes.mixin.HashAccessor;
import org.refcodes.mixin.IdentifierAccessor;
import org.refcodes.mixin.InstanceAccessor;
import org.refcodes.mixin.KeyAccessor;
import org.refcodes.mixin.StereotypeAccessor;
import org.refcodes.mixin.TypeAccessor;
import org.refcodes.mixin.ValueAccessor;
import org.refcodes.schema.SchemaNotation;
import org.refcodes.schema.SchemaVisitor;

public class Schema
extends HashMap<String, Object>
implements ChildrenAccessor<Schema[]>,
IdentifierAccessor,
AliasAccessor,
TypeAccessor,
HashAccessor,
DescriptionAccessor,
KeyAccessor<String>,
StereotypeAccessor<String>,
ExceptionAccessor<Throwable>,
ValueAccessor<Object> {
    private static final long serialVersionUID = 1L;
    public static final String ASSOCIATION = "ASSOCIATION";
    public static final String IDENTIFIER = "IDENTIFIER";
    public static final String ALIAS = "ALIAS";
    public static final String KEY = "KEY";
    public static final String TYPE = "TYPE";
    public static final String HASH = "HASH";
    public static final String VALUE = "VALUE";
    public static final String DESCRIPTION = "DESCRIPTION";
    public static final String EXCEPTION = "EXCEPTION";
    public static final String STEREOTYPE = "STEREOTYPE";
    public static final char HASH_SEPARATOR = '@';
    protected Schema[] _children = null;

    protected Schema() {
    }

    private Schema(Schema aSchema, Schema[] aChildren) {
        if (aSchema != null) {
            this.putAll(aSchema);
        }
        this._children = aChildren;
    }

    protected Schema(Builder aBuilder) {
        this(aBuilder.schema, aBuilder.children.toArray(new Schema[aBuilder.children.size()]));
        this.putAll(aBuilder.properties);
        String theAlias = (String)this.get(ALIAS);
        String theIdentifier = (String)this.get(IDENTIFIER);
        Class theType = (Class)this.get(TYPE);
        this.init(theAlias, theIdentifier, theType);
    }

    protected void init(String aAlias, String aIdentifier, Class<?> aType) {
        this.put(ALIAS, aAlias == null ? this.toAlias() : aAlias);
        this.put(IDENTIFIER, aIdentifier == null ? this.toIdentifier() : aIdentifier);
        this.put(TYPE, aType == null ? this.toType() : aType);
    }

    @Override
    public String getIdentifier() {
        return this.toIdentifier();
    }

    @Override
    public String getAlias() {
        return this.toAlias();
    }

    @Override
    public String getKey() {
        return (String)this.get(KEY);
    }

    public Class<?> getType() {
        return (Class)this.get(TYPE);
    }

    @Override
    public Object getValue() {
        return this.get(VALUE);
    }

    @Override
    public int getHash() {
        return this.getOr(HASH, Integer.class, -1);
    }

    @Override
    public String getStereotype() {
        return (String)this.get(STEREOTYPE);
    }

    @Override
    public Throwable getException() {
        return (Throwable)this.get(EXCEPTION);
    }

    @Override
    public String getDescription() {
        return (String)this.get(DESCRIPTION);
    }

    @Override
    public Schema[] getChildren() {
        return this._children;
    }

    public <T> T get(String aKey, Class<T> aType) {
        Object value = this.get(aKey);
        return aType.isInstance(value) ? (T)aType.cast(value) : null;
    }

    public <T> T getOr(String aKey, Class<T> aType, T aValue) {
        Object theValue = this.get(aKey);
        return aType.isInstance(theValue) ? aType.cast(theValue) : aValue;
    }

    public String toLabel() {
        String theIdentifier = (String)this.get(IDENTIFIER);
        if (theIdentifier != null) {
            int i = theIdentifier.lastIndexOf(64);
            return i != -1 ? theIdentifier.substring(0, i) : theIdentifier;
        }
        if (this.getType() != null) {
            return this.getType().getSimpleName();
        }
        if (this.getAlias() != null) {
            return this.getAlias();
        }
        if (this.getKey() != null) {
            return this.getKey();
        }
        return this.getIdentifier();
    }

    public <T> T visit(SchemaVisitor<T> aVisitor) {
        return aVisitor.visit(this);
    }

    public String toNotation(SchemaNotation aNotation) {
        return aNotation.visit(this);
    }

    @Override
    public String toString() {
        return this.toNotation(SchemaNotation.JSON);
    }

    public static Builder builder() {
        return new Builder();
    }

    protected static String toObjectId(Object aObj) {
        return aObj.getClass().getName() + "@" + Integer.toHexString(System.identityHashCode(aObj));
    }

    protected static String toSimpleObjectId(Object aObj) {
        return aObj.getClass().getSimpleName() + "@" + Integer.toHexString(System.identityHashCode(aObj));
    }

    private String toAlias() {
        String theIdentifier;
        String theAlias = (String)this.get(ALIAS);
        if (theAlias == null && (theIdentifier = (String)this.get(IDENTIFIER)) != null) {
            int i = theIdentifier.lastIndexOf(64);
            theAlias = i != -1 ? theIdentifier.substring(0, i) : theIdentifier;
        }
        return theAlias;
    }

    private String toIdentifier() {
        String theIdentifier = (String)this.get(IDENTIFIER);
        if (theIdentifier == null) {
            String theAlias = (String)this.get(ALIAS);
            String theKey = (String)this.get(KEY);
            Class theType = (Class)this.get(TYPE);
            Integer theHash = (Integer)this.get(HASH);
            if (theAlias == null && theKey == null && theType == null) {
                throw new IllegalArgumentException("At least one of the options <alias>, <key> or <type> must not be null for determining the schema's identifier!");
            }
            StringBuilder theBuilder = new StringBuilder();
            if (theAlias != null) {
                theBuilder.append(theAlias);
            } else if (theKey != null) {
                theBuilder.append(theKey);
            } else if (theType != null) {
                theBuilder.append(theType.getSimpleName());
            }
            theBuilder.append('@');
            if (theHash != null) {
                theBuilder.append(Integer.toHexString(theHash));
            } else {
                theBuilder.append(Integer.toHexString(System.identityHashCode(this)));
            }
            return theBuilder.toString();
        }
        return theIdentifier;
    }

    private Class<?> toType() {
        Object theValue;
        Class<?> theType = (Class<?>)this.get(TYPE);
        if (theType == null && (theValue = this.get(VALUE)) != null) {
            theType = theValue.getClass();
        }
        return theType;
    }

    public static class Builder
    implements IdentifierAccessor.IdentifierBuilder<Builder>,
    AliasAccessor.AliasBuilder<Builder>,
    KeyAccessor.KeyBuilder<String, Builder>,
    TypeAccessor.TypeBuilder<Class<?>, Builder>,
    HashAccessor.HashBuilder<Builder>,
    ValueAccessor.ValueBuilder<Object, Builder>,
    DescriptionAccessor.DescriptionBuilder<Builder>,
    ChildrenAccessor.ChildrenBuilder<Schema[], Builder>,
    InstanceAccessor.InstanceBuilder<Object, Builder>,
    StereotypeAccessor.StereotypeBuilder<String, Builder>,
    ExceptionAccessor.ExceptionBuilder<Throwable, Builder> {
        private Schema schema;
        private final List<Schema> children = new ArrayList<Schema>();
        private final Map<String, Object> properties = new HashMap<String, Object>();

        protected Builder() {
        }

        @Override
        public Builder withIdentifier(String aIdentifier) {
            this.properties.put(Schema.IDENTIFIER, aIdentifier);
            return this;
        }

        @Override
        public Builder withAlias(String aAlias) {
            this.properties.put(Schema.ALIAS, aAlias);
            return this;
        }

        @Override
        public Builder withKey(String aKey) {
            this.properties.put(Schema.KEY, aKey);
            return this;
        }

        @Override
        public Builder withType(Class aType) {
            this.properties.put(Schema.TYPE, aType);
            return this;
        }

        @Override
        public Builder withHash(int aHash) {
            this.properties.put(Schema.HASH, aHash);
            return this;
        }

        @Override
        public Builder withInstance(Object aInstance) {
            String identifier = (String)this.properties.get(Schema.IDENTIFIER);
            if (identifier == null) {
                Class<?> type = aInstance.getClass();
                int hash = System.identityHashCode(aInstance);
                this.properties.put(Schema.TYPE, type);
                this.properties.put(Schema.HASH, hash);
                this.properties.put(Schema.IDENTIFIER, type.getSimpleName() + "@" + Integer.toHexString(hash));
            }
            return this;
        }

        @Override
        public Builder withValue(Object aValue) {
            this.properties.put(Schema.VALUE, aValue);
            return this;
        }

        @Override
        public Builder withStereotype(String aStereotype) {
            this.properties.put(Schema.STEREOTYPE, aStereotype);
            return this;
        }

        @Override
        public Builder withException(Throwable aException) {
            this.properties.put(Schema.EXCEPTION, aException);
            return this;
        }

        @Override
        public Builder withDescription(String aDescription) {
            this.properties.put(Schema.DESCRIPTION, aDescription);
            return this;
        }

        @Override
        public Builder withChildren(Schema ... aChildren) {
            return this.withChildren((Collection<? extends Schema>)Arrays.asList(Objects.requireNonNull(aChildren, "aChildren")));
        }

        @Override
        public Builder withChildren(Collection<? extends Schema> aChildren) {
            Objects.requireNonNull(aChildren, "aChildren");
            this.children.clear();
            this.children.addAll(aChildren);
            return this;
        }

        public Builder withAddChildren(Schema ... aChildren) {
            return this.withAddChildren(Arrays.asList(Objects.requireNonNull(aChildren, "aChildren")));
        }

        public Builder withAddChildren(Collection<? extends Schema> aChildren) {
            this.children.addAll(Objects.requireNonNull(aChildren, "aChildren"));
            return this;
        }

        public Builder withSchema(Schema aSchema) {
            this.schema = aSchema;
            return this;
        }

        public Builder withProperty(String aKey, Object aValue) {
            this.properties.put(aKey, aValue);
            return this;
        }

        public Schema build() {
            return new Schema(this);
        }
    }
}

