/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.schema;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collections;
import org.refcodes.mixin.Bytes;
import org.refcodes.numerical.NumericalUtility;
import org.refcodes.schema.Schema;
import org.refcodes.schema.SchemaVisitor;

public class JsonVisitor
implements SchemaVisitor<String> {
    static final String INDENT = "  ";
    private final JsonMode _jsonMode;

    public JsonVisitor() {
        this(JsonMode.COMPACT);
    }

    public JsonVisitor(JsonMode aJsonMode) {
        this._jsonMode = aJsonMode;
    }

    @Override
    public String visit(Schema aSchema) {
        if (aSchema != null) {
            StringBuilder theBuffer = new StringBuilder();
            theBuffer.append(this.toKey(aSchema.toLabel()));
            theBuffer.append(": {");
            ArrayList theKeys = new ArrayList(aSchema.keySet());
            Collections.sort(theKeys);
            for (String eKey : theKeys) {
                Object eValue = aSchema.get(eKey);
                if (eValue == null) continue;
                eValue = this.toString(eValue);
                JsonVisitor.appendAttribute(INDENT + this.toKey(eKey) + ": " + String.valueOf(eValue), theBuffer);
            }
            if (aSchema.getChildren() != null && aSchema.getChildren().length != 0) {
                for (Schema eChild : aSchema.getChildren()) {
                    String eResult = this.visit(eChild);
                    eResult = eResult.indent(INDENT.length()).stripTrailing();
                    if (theBuffer.charAt(theBuffer.length() - 1) == '\"' || theBuffer.charAt(theBuffer.length() - 1) == '}') {
                        theBuffer.append(',');
                    }
                    theBuffer.append(System.lineSeparator());
                    theBuffer.append(eResult);
                }
            }
            if (theBuffer.charAt(theBuffer.length() - 1) != '{') {
                theBuffer.append(System.lineSeparator());
            }
            theBuffer.append("}");
            return theBuffer.toString();
        }
        return "null";
    }

    private String toKey(String aKey) {
        return switch (this._jsonMode.ordinal()) {
            default -> throw new MatchException(null, null);
            case 1 -> aKey;
            case 0 -> "\"" + aKey + "\"";
        };
    }

    protected String toString(Object aValue) {
        if (aValue != null && aValue.getClass().isArray()) {
            Object theValue = "{ ";
            int theLength = Array.getLength(aValue);
            for (int i = 0; i < theLength; ++i) {
                theValue = (String)theValue + this.toString(Array.get(aValue, i));
                if (i >= theLength - 1) continue;
                theValue = (String)theValue + ", ";
            }
            return (String)theValue + " }";
        }
        if (aValue instanceof String || aValue != null && aValue.getClass().isEnum()) {
            return "\"" + String.valueOf(aValue) + "\"";
        }
        if (aValue instanceof Character) {
            return "'" + String.valueOf(aValue) + "'";
        }
        if (aValue instanceof Byte) {
            return NumericalUtility.toHexString((byte)((Byte)aValue));
        }
        if (aValue instanceof Class) {
            return "\"" + ((Class)aValue).getName() + "\"";
        }
        if (aValue instanceof Exception) {
            return "\"" + String.valueOf(aValue) + "\"";
        }
        if (aValue instanceof Bytes) {
            Bytes bytes = (Bytes)aValue;
            return this.toString(bytes.toBytes());
        }
        return aValue != null ? aValue.toString() : null;
    }

    private static void appendAttribute(String aText, StringBuilder aBuffer) {
        if (aBuffer.charAt(aBuffer.length() - 1) != '{') {
            aBuffer.append(',');
        }
        aBuffer.append(System.lineSeparator());
        aBuffer.append(aText);
    }

    public static enum JsonMode {
        STRICT,
        COMPACT;

    }
}

