/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.runtime;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.management.ManagementFactory;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.refcodes.data.DaemonLoopSleepTime;
import org.refcodes.data.Literal;
import org.refcodes.mixin.ResultAccessor;
import org.refcodes.numerical.NumericalUtility;
import org.refcodes.runtime.EnvironmentVariable;
import org.refcodes.runtime.Execution;
import org.refcodes.runtime.OperatingSystem;
import org.refcodes.runtime.Shell;
import org.refcodes.runtime.SystemContext;
import org.refcodes.runtime.SystemProperty;
import org.refcodes.runtime.Terminal;

public final class Host {
    private static File _currentDir = null;
    private static String _uname = null;
    private static boolean _hasUname = false;

    private Host() {
    }

    public static String getComputerName() {
        try {
            return InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            String theName = EnvironmentVariable.COMPUTERNAME.getValue();
            if (theName == null || theName.isEmpty()) {
                theName = EnvironmentVariable.HOSTNAME.getValue();
            }
            if (theName != null && theName.length() > 0) {
                return theName;
            }
            return Literal.LOCALHOST.getValue();
        }
    }

    public static String getUname() {
        if (_hasUname) {
            return _uname;
        }
        try {
            _uname = Host.exec(DaemonLoopSleepTime.NORM.getTimeMillis(), "uname -a");
        }
        catch (IOException | InterruptedException ignore) {
            try {
                _uname = Host.exec(DaemonLoopSleepTime.NORM.getTimeMillis(), "bash", "-c", "uname -a");
            }
            catch (IOException | InterruptedException exception) {
                // empty catch block
            }
        }
        _hasUname = true;
        return _uname;
    }

    public static String exec(int aTimeoutMillis, String aCommandLine) throws IOException, InterruptedException {
        ProcessBuilder theProcessBuilder = new ProcessBuilder(aCommandLine);
        Process theProcess = theProcessBuilder.start();
        String theOut = new ProcessResult(theProcess, aTimeoutMillis).toString();
        return theOut;
    }

    public static String exec(int aTimeoutMillis, String ... aCommandLine) throws IOException, InterruptedException {
        ProcessBuilder theProcessBuilder = new ProcessBuilder(aCommandLine);
        Process theProcess = theProcessBuilder.start();
        String theOut = new ProcessResult(theProcess, aTimeoutMillis).toString();
        return theOut;
    }

    public static String exec(String aCommandLine) throws IOException {
        ProcessBuilder theProcessBuilder = new ProcessBuilder(aCommandLine);
        Process theProcess = theProcessBuilder.start();
        String theOut = new ProcessResult(theProcess).toString();
        return theOut;
    }

    public static String exec(String ... aCommandLine) throws IOException {
        ProcessBuilder theProcessBuilder = new ProcessBuilder(aCommandLine);
        Process theProcess = theProcessBuilder.start();
        String theOut = new ProcessResult(theProcess).toString();
        return theOut;
    }

    public static Map<String, String> toSystemInfo() {
        int i;
        HashMap<String, String> theInfo = new HashMap<String, String>();
        theInfo.put("applicationId", NumericalUtility.toHexString(":", NumericalUtility.toBytes(SystemContext.APPLICATION.toContextId())));
        int[] theIds = SystemContext.APPLICATION.toContextIds(3);
        Object[] theIdTexts = new String[3];
        for (i = 0; i < 3; ++i) {
            theIdTexts[i] = NumericalUtility.toHexString(":", NumericalUtility.toBytes(theIds[i]));
        }
        theInfo.put("applicationIds", Arrays.toString(theIdTexts));
        theInfo.put("applicationString", NumericalUtility.toHexString(":", SystemContext.APPLICATION.toContextString().getBytes()));
        theInfo.put("fileEncoding", SystemProperty.FILE_ENCODING.getValue());
        theInfo.put("hostId", NumericalUtility.toHexString(":", NumericalUtility.toBytes(SystemContext.HOST.toContextId())));
        theIds = SystemContext.HOST.toContextIds(3);
        for (i = 0; i < 3; ++i) {
            theIdTexts[i] = NumericalUtility.toHexString(":", NumericalUtility.toBytes(theIds[i]));
        }
        theInfo.put("hostIds", Arrays.toString(theIdTexts));
        theInfo.put("hostString", NumericalUtility.toHexString(":", SystemContext.HOST.toContextString().getBytes()));
        theInfo.put("userId", NumericalUtility.toHexString(":", NumericalUtility.toBytes(SystemContext.USER.toContextId())));
        theIds = SystemContext.USER.toContextIds(3);
        for (i = 0; i < 3; ++i) {
            theIdTexts[i] = NumericalUtility.toHexString(":", NumericalUtility.toBytes(theIds[i]));
        }
        theInfo.put("userIds", Arrays.toString(theIdTexts));
        theInfo.put("userString", NumericalUtility.toHexString(":", SystemContext.USER.toContextString().getBytes()));
        theInfo.put("computerName", Host.getComputerName());
        try {
            theInfo.put("ipAddress", NumericalUtility.toHexString(":", Host.toHostIpAddress()));
        }
        catch (SocketException | UnknownHostException e) {
            theInfo.put("ipAddress", e.getMessage());
        }
        theInfo.put("isAnsiTerminalPreferred", "" + Terminal.isAnsiTerminalEnabled());
        theInfo.put("isAnsiTerminal", "" + Terminal.isAnsiTerminal());
        theInfo.put("isCygwinTerminal", "" + Terminal.isCygwinTerminal());
        theInfo.put("isLineBreakRequired", "" + Terminal.isLineBreakRequired(Terminal.getWidth()));
        theInfo.put("launcherDir", Execution.toLauncherDir().getAbsolutePath());
        theInfo.put("lineBreak", Terminal.getLineBreak().replaceAll("\\n", "\\\\n").replaceAll("\\r", "\\\\r"));
        try {
            theInfo.put("macAddress", NumericalUtility.toHexString(":", Host.toHostMacAddress()));
        }
        catch (SocketException | UnknownHostException e) {
            theInfo.put("macAddress", e.getMessage());
        }
        theInfo.put("mainClass", Execution.getMainClass().getName());
        theInfo.put("operatingSystem", String.valueOf(OperatingSystem.toOperatingSystem()));
        theInfo.put("operatingSystemVersion", OperatingSystem.toOperatingSystem().getVersion());
        theInfo.put("preferredTerminalHeight", Integer.toString(Terminal.toHeuristicHeight()));
        theInfo.put("preferredTerminalWidth", Integer.toString(Terminal.toHeuristicWidth()));
        theInfo.put("shell", String.valueOf(Shell.toShell()));
        theInfo.put("systemConsole", System.console() != null ? System.console().toString() : null);
        theInfo.put("terminalCharSetCapabilities", Terminal.toCharSetCapability().name());
        theInfo.put("terminalEncoding", Terminal.getEncoding());
        theInfo.put("tempDir", Host.getTempDir());
        theInfo.put("terminal", String.valueOf(Terminal.toTerminal()));
        theInfo.put("terminalEncoding", Terminal.getEncoding());
        theInfo.put("terminalHeight", Integer.toString(Terminal.getHeight()));
        theInfo.put("terminalWidth", Integer.toString(Terminal.getWidth()));
        theInfo.put("uname", Host.getUname());
        theInfo.put("documentArrayIndex", Boolean.toString(SystemProperty.DOCUMENT_ARRAY_INDEX.isEnabled()));
        theInfo.put("documentEnvelope", Boolean.toString(SystemProperty.DOCUMENT_ENVELOPE.isEnabled()));
        return theInfo;
    }

    public static String getTempDir() {
        String theTempDir = SystemProperty.TEMP_DIR.getValue();
        if (theTempDir == null || theTempDir.isEmpty()) {
            theTempDir = EnvironmentVariable.TMPDIR.getValue();
        }
        return theTempDir;
    }

    public static String toPrettySystemInfo() {
        StringBuilder theBuffer = new StringBuilder();
        Map<String, String> theInfo = Host.toSystemInfo();
        int maxLength = -1;
        for (String eKey : theInfo.keySet()) {
            if (eKey.length() <= maxLength) continue;
            maxLength = eKey.length();
        }
        ArrayList<String> theKeys = new ArrayList<String>(theInfo.keySet());
        Collections.sort(theKeys);
        for (String eKey : theKeys) {
            Object tmpKey = eKey;
            while (((String)tmpKey).length() < maxLength) {
                tmpKey = (String)tmpKey + " ";
            }
            theBuffer.append((String)tmpKey + " = " + theInfo.get(eKey) + Terminal.getLineBreak());
        }
        return theBuffer.toString();
    }

    public static byte[] toHostIpAddress() throws SocketException, UnknownHostException {
        Enumeration<NetworkInterface> eNetworks = NetworkInterface.getNetworkInterfaces();
        while (eNetworks.hasMoreElements()) {
            NetworkInterface eNetwork = eNetworks.nextElement();
            Enumeration<InetAddress> eAddresses = eNetwork.getInetAddresses();
            while (eAddresses.hasMoreElements()) {
                try {
                    InetAddress eAddress = eAddresses.nextElement();
                    if (eAddress.isAnyLocalAddress() || eAddress.isLoopbackAddress()) continue;
                    return eAddress.getAddress();
                }
                catch (IllegalArgumentException illegalArgumentException) {
                }
            }
        }
        return InetAddress.getLocalHost().getAddress();
    }

    public static byte[] toHostMacAddress() throws SocketException, UnknownHostException {
        Enumeration<NetworkInterface> eNetworks = NetworkInterface.getNetworkInterfaces();
        while (eNetworks.hasMoreElements()) {
            NetworkInterface eNetwork = eNetworks.nextElement();
            byte[] eAddress = eNetwork.getHardwareAddress();
            if (eAddress == null || eAddress.length == 0) continue;
            return eAddress;
        }
        try {
            return NetworkInterface.getByInetAddress(InetAddress.getLocalHost()).getHardwareAddress();
        }
        catch (SocketException | UnknownHostException e) {
            throw e;
        }
        catch (Exception e) {
            throw new UnknownHostException("Unable to determine host address: " + e.getMessage());
        }
    }

    public static Long getPid() {
        Long thePid;
        block4: {
            thePid = null;
            try {
                thePid = Long.parseLong(SystemProperty.PROCESS_ID.getValue());
            }
            catch (NumberFormatException e1) {
                String theJvmName = ManagementFactory.getRuntimeMXBean().getName();
                if (theJvmName.indexOf(64) == -1) break block4;
                try {
                    thePid = Long.parseLong(theJvmName.substring(0, theJvmName.indexOf(64)));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
        return thePid;
    }

    public static Process killProcess(long aPid) throws IOException {
        Process theProcess = null;
        switch (OperatingSystem.toOperatingSystem()) {
            case WINDOWS: {
                String[] theCmd = new String[]{"taskkill", "/F", "/PID", Long.toString(aPid)};
                theProcess = Runtime.getRuntime().exec(theCmd);
                break;
            }
            case UNIX: {
                String[] theCmd = new String[]{"kill", "-9", Long.toString(aPid)};
                theProcess = Runtime.getRuntime().exec(theCmd);
                break;
            }
        }
        return theProcess;
    }

    public static boolean kill(Long aPid) throws IOException, InterruptedException {
        Process theProcess = Host.killProcess(aPid);
        if (theProcess != null) {
            theProcess.waitFor();
            return theProcess.exitValue() == 0;
        }
        return false;
    }

    public static File toUserWorkingDir() {
        String theCurrentDir;
        if (_currentDir == null && (theCurrentDir = SystemProperty.USER_DIR.getValue()) != null && theCurrentDir.length() != 0) {
            File theCurrentFile = new File(theCurrentDir);
            if (theCurrentFile.exists() && theCurrentFile.isDirectory()) {
                _currentDir = theCurrentFile;
            } else {
                theCurrentDir = EnvironmentVariable.USER_DIR.getValue();
                if (theCurrentDir != null && theCurrentDir.length() != 0 && (theCurrentFile = new File(theCurrentDir)).exists() && theCurrentFile.isDirectory()) {
                    _currentDir = theCurrentFile;
                }
            }
        }
        return _currentDir;
    }

    private static class ProcessResult
    implements ResultAccessor<String, RuntimeException> {
        private final String _result;

        public ProcessResult(Process aProcess) throws IOException {
            try {
                aProcess.waitFor();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this._result = this.toResult(aProcess);
        }

        public ProcessResult(Process aProcess, int aTimeoutMillis) throws InterruptedException, IOException {
            if (aTimeoutMillis != -1) {
                aProcess.waitFor(aTimeoutMillis, TimeUnit.MILLISECONDS);
                if (aProcess.isAlive()) {
                    try {
                        aProcess.destroy();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    throw new InterruptedException("Killed process <" + aProcess.toString() + ">!");
                }
            } else {
                aProcess.waitFor();
            }
            this._result = this.toResult(aProcess);
        }

        @Override
        public String getResult() {
            return this._result;
        }

        @Override
        public boolean hasResult() {
            return this._result != null;
        }

        public String toString() {
            return this._result;
        }

        private String toResult(Process aProcess) throws IOException {
            try {
                StringBuilder theOutBuilder = new StringBuilder();
                try (BufferedReader theOutReader = new BufferedReader(new InputStreamReader(aProcess.getInputStream()));){
                    String eLine;
                    while ((eLine = theOutReader.readLine()) != null) {
                        theOutBuilder.append(eLine);
                    }
                }
                return theOutBuilder.toString();
            }
            catch (IOException e) {
                StringBuilder theErrBuilder = new StringBuilder();
                try (BufferedReader theErrReader = new BufferedReader(new InputStreamReader(aProcess.getInputStream()));){
                    if (theErrReader != null) {
                        String eErr;
                        while ((eErr = theErrReader.readLine()) != null) {
                            theErrBuilder.append(eErr);
                        }
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (theErrBuilder.length() != 0) {
                    throw new IOException(theErrBuilder.toString(), e);
                }
                throw e;
            }
        }
    }
}

