/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.runtime;

import org.refcodes.data.Delimiter;
import org.refcodes.internal.IdentifierUtility;
import org.refcodes.mixin.KeyAccessor;
import org.refcodes.mixin.ValueAccessor;

public enum EnvironmentVariable implements KeyAccessor<String>,
ValueAccessor.ValueProperty<String>
{
    ANSICON("ANSICON"),
    COMPUTERNAME("COMPUTERNAME"),
    CONSOLE_ANSI("CONSOLE_ANSI"),
    CONSOLE_CONEMU_ANSI("ConEmuANSI"),
    CONSOLE_HEIGHT("CONSOLE_HEIGHT"),
    CONSOLE_LINE_BREAK("CONSOLE_LINE_BREAK"),
    CONSOLE_WIDTH("CONSOLE_WIDTH"),
    HOST_SEED("HOST_SEED"),
    HOSTNAME("HOSTNAME"),
    HTTP_PROXY("HTTP_PROXY"),
    HTTPS_PROXY("HTTPS_PROXY"),
    LANG("LANG"),
    LOGGER_LAYOUT("LOGGER_LAYOUT"),
    LOGGER_STYLE("LOGGER_STYLE"),
    NO_PROXY("NO_PROXY"),
    NUMBER_OF_PROCESSORS("NUMBER_OF_PROCESSORS"),
    PROCESSOR_ARCHITECTURE("PROCESSOR_ARCHITECTURE"),
    PROCESSOR_ARCHITEW6432("PROCESSOR_ARCHITEW6432"),
    STRUCT_KEEP_MAPS("STRUCT_KEEPMAPS"),
    TERM("TERM"),
    TERMINAL_COLUMNS("COLUMNS"),
    TERMINAL_ENCODING("terminalEncoding"),
    TERMINAL_LINES("LINES"),
    TMPDIR("TMPDIR"),
    USER_DIR("PWD"),
    USER_HOME("HOME"),
    USER_NAME("USER");

    private final String _name;

    private EnvironmentVariable(String aName) {
        this._name = aName;
    }

    @Override
    public String getKey() {
        return this._name;
    }

    @Override
    public String getValue() {
        String theValue = System.getenv(this._name.toUpperCase());
        if ((theValue == null || theValue.isEmpty()) && ((theValue = System.getenv(this._name.toLowerCase())) == null || theValue.isEmpty())) {
            theValue = System.getenv(this._name);
        }
        return theValue;
    }

    @Override
    public void setValue(String aValue) {
        String theValue = System.getenv(this._name.toUpperCase());
        if (theValue == null || theValue.isEmpty()) {
            theValue = System.getenv(this._name.toLowerCase());
            if (theValue != null && theValue.length() != 0) {
                System.getenv().put(this._name.toLowerCase(), aValue);
                return;
            }
            theValue = System.getenv(this._name);
            if (theValue != null && theValue.length() != 0) {
                System.getenv().put(this._name, aValue);
                return;
            }
        }
        System.getenv().put(this._name.toUpperCase(), aValue);
    }

    public static String toEnvironmentVariableName(String aKey) {
        if (aKey == null || aKey.isEmpty()) {
            return aKey;
        }
        String theKey = IdentifierUtility.toNormalized(aKey, Delimiter.SNAKE_CASE.getChar());
        return theKey != null ? theKey.toUpperCase() : theKey;
    }
}

