/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.runtime;

import org.refcodes.data.Delimiter;
import org.refcodes.data.Literal;
import org.refcodes.generator.Generator;
import org.refcodes.generator.UniqueIdGenerator;
import org.refcodes.mixin.IdAccessor;

public enum Correlation implements IdAccessor.IdProperty<String>
{
    REQUEST(24),
    SESSION(24);

    private ThreadLocal<String> _correlationId = new ThreadLocal();
    private Generator<String> _generator;

    private Correlation(int aIdlength) {
        this._generator = new UniqueIdGenerator(aIdlength);
    }

    @Override
    public void setId(String aCorrelationId) {
        this._correlationId.set(aCorrelationId);
    }

    @Override
    public String getId() {
        return this._correlationId.get();
    }

    public String pullId() {
        String theId = this._correlationId.get();
        if (theId == null) {
            theId = this._generator.next();
            this._correlationId.set(theId);
        }
        return theId;
    }

    public String nextId() {
        String theNext = this._generator.next();
        this._correlationId.set(theNext);
        return theNext;
    }

    public static String toFullCorrelationId() {
        Object theFullCorrelationId = "";
        Correlation[] correlations = Correlation.values();
        for (int i = correlations.length - 1; i >= 0; --i) {
            String eId;
            if (((String)theFullCorrelationId).length() != 0) {
                theFullCorrelationId = (String)theFullCorrelationId + Delimiter.CORRELATION_ID.getChar();
            }
            if ((eId = correlations[i].getId()) == null) {
                eId = Literal.UNKNOWN.getValue();
            }
            theFullCorrelationId = (String)theFullCorrelationId + eId;
        }
        return theFullCorrelationId;
    }

    public static boolean hasAnyCorrelationId() {
        for (Correlation aCorrelation : Correlation.values()) {
            if (aCorrelation.getId() == null) continue;
            return true;
        }
        return false;
    }
}

