/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.rest;

import java.io.InputStream;
import java.net.InetSocketAddress;
import org.refcodes.mixin.WildcardSubstitutes;
import org.refcodes.observer.ActionEvent;
import org.refcodes.rest.RestServer;
import org.refcodes.web.HttpMethod;
import org.refcodes.web.HttpServerRequest;
import org.refcodes.web.LocalAddressAccessor;
import org.refcodes.web.RealmAccessor;
import org.refcodes.web.RemoteAddressAccessor;
import org.refcodes.web.RequestHeaderFields;
import org.refcodes.web.Url;

public class RestRequestEvent
extends HttpServerRequest
implements ActionEvent<HttpMethod, RestServer>,
WildcardSubstitutes,
RemoteAddressAccessor,
LocalAddressAccessor,
RealmAccessor {
    private final InetSocketAddress _remoteAddress;
    private final InetSocketAddress _localAddress;
    private final WildcardSubstitutes _wildcardSubstitutes;
    private final String _realm;

    public RestRequestEvent(InetSocketAddress aLocalAddress, InetSocketAddress aRemoteAddress, HttpMethod aHttpMethod, Url aUrl, WildcardSubstitutes aWildcardSubstitutes, RequestHeaderFields aHeaderFields, InputStream aHttpInputStream, RestServer aRestServer) {
        super(aHttpMethod, aUrl, aHeaderFields, aHttpInputStream, aRestServer);
        this._wildcardSubstitutes = aWildcardSubstitutes;
        this._remoteAddress = aRemoteAddress;
        this._localAddress = aLocalAddress;
        this._realm = aRestServer.getRealm();
    }

    @Override
    public HttpMethod getAction() {
        return this.getHttpMethod();
    }

    @Override
    public RestServer getSource() {
        return (RestServer)this._mediaTypeFactoryLookup;
    }

    @Override
    public String[] getWildcardReplacements() {
        return this._wildcardSubstitutes.getWildcardReplacements();
    }

    @Override
    public String getWildcardReplacementAt(int aIndex) {
        return this._wildcardSubstitutes.getWildcardReplacementAt(aIndex);
    }

    @Override
    public String getWildcardReplacement(String aWildcardName) {
        return this._wildcardSubstitutes.getWildcardReplacement(aWildcardName);
    }

    @Override
    public String[] getWildcardReplacements(String ... aWildcardNames) {
        return this._wildcardSubstitutes.getWildcardReplacements(aWildcardNames);
    }

    @Override
    public String[] getWildcardReplacementsAt(int ... aIndexes) {
        return this._wildcardSubstitutes.getWildcardReplacementsAt(aIndexes);
    }

    @Override
    public InetSocketAddress getRemoteAddress() {
        return this._remoteAddress;
    }

    @Override
    public InetSocketAddress getLocalAddress() {
        return this._localAddress;
    }

    @Override
    public String getRealm() {
        return this._realm;
    }

    @Override
    public String[] getWildcardNames() {
        return this._wildcardSubstitutes.getWildcardNames();
    }
}

