/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.rest;

import java.net.InetSocketAddress;
import org.refcodes.mixin.WildcardSubstitutes;
import org.refcodes.observer.ActionEvent;
import org.refcodes.rest.RestServer;
import org.refcodes.web.BasicAuthCredentials;
import org.refcodes.web.BasicAuthRequest;
import org.refcodes.web.HttpMethod;
import org.refcodes.web.LocalAddressAccessor;
import org.refcodes.web.RealmAccessor;
import org.refcodes.web.RemoteAddressAccessor;
import org.refcodes.web.Url;

public class BasicAuthEvent
extends BasicAuthRequest
implements ActionEvent<HttpMethod, RestServer>,
WildcardSubstitutes,
RealmAccessor,
LocalAddressAccessor,
RemoteAddressAccessor {
    private final InetSocketAddress _localAddress;
    private final InetSocketAddress _remoteAddress;
    private final RestServer _restServer;
    private final WildcardSubstitutes _wildcardSubstitutes;
    private final String _realm;

    public BasicAuthEvent(InetSocketAddress aLocalAddress, InetSocketAddress aRemoteAddress, HttpMethod aHttpMethod, Url aUrl, WildcardSubstitutes aWildcardSubstitutes, BasicAuthCredentials aCredentials, String aRealm, RestServer aRestServer) {
        super(aHttpMethod, aUrl, aCredentials);
        this._restServer = aRestServer;
        this._localAddress = aLocalAddress;
        this._remoteAddress = aRemoteAddress;
        this._wildcardSubstitutes = aWildcardSubstitutes;
        this._realm = aRealm;
    }

    @Override
    public HttpMethod getAction() {
        return this.getHttpMethod();
    }

    @Override
    public String[] getWildcardReplacements() {
        return this._wildcardSubstitutes.getWildcardReplacements();
    }

    @Override
    public String getWildcardReplacementAt(int aIndex) {
        return this._wildcardSubstitutes.getWildcardReplacementAt(aIndex);
    }

    @Override
    public String getWildcardReplacement(String aWildcardName) {
        return this._wildcardSubstitutes.getWildcardReplacement(aWildcardName);
    }

    @Override
    public String[] getWildcardReplacements(String ... aWildcardNames) {
        return this._wildcardSubstitutes.getWildcardReplacements(aWildcardNames);
    }

    @Override
    public String[] getWildcardReplacementsAt(int ... aIndexes) {
        return this._wildcardSubstitutes.getWildcardReplacementsAt(aIndexes);
    }

    @Override
    public InetSocketAddress getRemoteAddress() {
        return this._remoteAddress;
    }

    @Override
    public InetSocketAddress getLocalAddress() {
        return this._localAddress;
    }

    @Override
    public String getRealm() {
        return this._realm;
    }

    @Override
    public RestServer getSource() {
        return this._restServer;
    }

    @Override
    public String[] getWildcardNames() {
        return this._wildcardSubstitutes.getWildcardNames();
    }
}

