/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.properties;

import java.io.IOException;
import java.text.ParseException;
import java.util.Timer;
import java.util.TimerTask;
import org.refcodes.component.StartException;
import org.refcodes.component.StopException;
import org.refcodes.controlflow.ThreadMode;
import org.refcodes.data.IoPollLoopTime;
import org.refcodes.properties.AbstractImmutableResourcePropertiesDecorator;
import org.refcodes.properties.ImmutableResourceProperties;
import org.refcodes.properties.ImmutableScheduledResourceProperties;
import org.refcodes.properties.ReloadMode;

public class ImmutableScheduledResourcePropertiesDecorator
extends AbstractImmutableResourcePropertiesDecorator<ImmutableResourceProperties>
implements ImmutableScheduledResourceProperties {
    private PropertiesScheduler _scheduler;

    public ImmutableScheduledResourcePropertiesDecorator(ImmutableResourceProperties aProperties) throws IOException, ParseException {
        this(aProperties, IoPollLoopTime.NORM.getTimeMillis(), ReloadMode.ORPHAN_REMOVAL);
    }

    public ImmutableScheduledResourcePropertiesDecorator(ImmutableResourceProperties aProperties, int aScheduleTimeMillis) throws IOException, ParseException {
        this(aProperties, aScheduleTimeMillis, ReloadMode.ORPHAN_REMOVAL);
    }

    public ImmutableScheduledResourcePropertiesDecorator(ImmutableResourceProperties aProperties, int aScheduleTimeMillis, ReloadMode aReloadMode) throws IOException, ParseException {
        this(aProperties, aScheduleTimeMillis, aReloadMode, ThreadMode.DAEMON);
    }

    public ImmutableScheduledResourcePropertiesDecorator(ImmutableResourceProperties aProperties, int aScheduleTimeMillis, ReloadMode aReloadMode, ThreadMode aThreadMode) throws IOException, ParseException {
        super(aProperties);
        this.reload(aReloadMode);
        this._scheduler = new PropertiesScheduler(aProperties, aScheduleTimeMillis, aReloadMode, aThreadMode);
        this.startUnchecked();
    }

    public ImmutableScheduledResourcePropertiesDecorator(ImmutableResourceProperties aProperties, int aScheduleTimeMillis, ThreadMode aThreadMode) throws IOException, ParseException {
        this(aProperties, aScheduleTimeMillis, ReloadMode.ORPHAN_REMOVAL, aThreadMode);
    }

    public ImmutableScheduledResourcePropertiesDecorator(ImmutableResourceProperties aProperties, ReloadMode aReloadMode) throws IOException, ParseException {
        this(aProperties, IoPollLoopTime.NORM.getTimeMillis(), aReloadMode);
    }

    public ImmutableScheduledResourcePropertiesDecorator(ImmutableResourceProperties aProperties, ReloadMode aReloadMode, ThreadMode aThreadMode) throws IOException, ParseException {
        this(aProperties, IoPollLoopTime.NORM.getTimeMillis(), aReloadMode, aThreadMode);
    }

    public ImmutableScheduledResourcePropertiesDecorator(ImmutableResourceProperties aProperties, ThreadMode aThreadMode) throws IOException, ParseException {
        this(aProperties, IoPollLoopTime.NORM.getTimeMillis(), ReloadMode.ORPHAN_REMOVAL, aThreadMode);
    }

    @Override
    public synchronized void dispose() {
        if (this._scheduler != null) {
            this._scheduler.dispose();
            this._scheduler = null;
        }
    }

    @Override
    public synchronized void start() throws StartException {
        this._scheduler.start();
    }

    @Override
    public synchronized void stop() throws StopException {
        this._scheduler.stop();
    }

    static class PropertiesScheduler {
        private Timer _timer = null;
        private final ReloadMode _reloadMode;
        private final int _scheduleTimeMillis;
        private ImmutableResourceProperties _properties;
        private final ThreadMode _threadMode;

        PropertiesScheduler(ImmutableResourceProperties aProperties, int aScheduleTimeMillis, ReloadMode aReloadMode, ThreadMode aThreadMode) {
            this._reloadMode = aReloadMode;
            this._scheduleTimeMillis = aScheduleTimeMillis;
            this._properties = aProperties;
            this._threadMode = aThreadMode;
        }

        public synchronized void dispose() {
            Timer theTimer = this._timer;
            if (theTimer != null) {
                theTimer.cancel();
            }
            this._timer = null;
            this._properties = null;
        }

        public synchronized void start() throws StartException {
            if (this._timer != null) {
                throw new StartException("Unable to start the scheduler which has not been stopped before!");
            }
            this._timer = new Timer(this._threadMode == ThreadMode.DAEMON);
            this._timer.schedule(new TimerTask(){

                @Override
                public void run() {
                    try {
                        _properties.reload(_reloadMode);
                    }
                    catch (IOException | IllegalStateException | ParseException exception) {
                        // empty catch block
                    }
                }
            }, this._scheduleTimeMillis, (long)this._scheduleTimeMillis);
        }

        public synchronized void stop() throws StopException {
            if (this._timer == null) {
                throw new StopException("Unable to stop the scheduler which has not been started again!");
            }
            this._timer.cancel();
            this._timer = null;
        }
    }
}

