/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.properties;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.refcodes.exception.IntegrityException;
import org.refcodes.properties.ImmutableProperties;
import org.refcodes.properties.ImmutablePropertiesPrecedence;
import org.refcodes.properties.MapProperties;
import org.refcodes.properties.Properties;

public class ImmutablePropertiesPrecedenceComposite
implements ImmutablePropertiesPrecedence {
    protected List<ImmutableProperties> _immutableProperties;

    public ImmutablePropertiesPrecedenceComposite(List<ImmutableProperties> aProperties) {
        this._immutableProperties = aProperties;
    }

    public ImmutablePropertiesPrecedenceComposite(ImmutableProperties ... aProperties) {
        this._immutableProperties = new ArrayList<ImmutableProperties>(Arrays.asList(aProperties));
    }

    @Override
    public boolean containsKey(Object aKey) {
        return this._immutableProperties.stream().filter(_propertie -> _propertie.containsKey(aKey)).findFirst().map(immutableProperties -> true).orElse(false);
    }

    @Override
    public boolean containsProperties(ImmutableProperties aProperties) {
        return this._immutableProperties.contains(aProperties);
    }

    @Override
    public String get(Object aKey) {
        for (ImmutableProperties _propertie : this._immutableProperties) {
            ImmutableProperties eProperties = _propertie;
            if (!eProperties.containsKey(aKey)) continue;
            return (String)eProperties.get(aKey);
        }
        return null;
    }

    @Override
    public char getDelimiter() {
        Character theDelimiter = null;
        for (ImmutableProperties _propertie : this._immutableProperties) {
            char eDelimiter = _propertie.getDelimiter();
            if (theDelimiter != null && !theDelimiter.equals(Character.valueOf(eDelimiter))) {
                throw new IntegrityException("The encapsulated properties define different ambiguous delimiter <" + theDelimiter + "> and <" + eDelimiter + "> definitions.");
            }
            theDelimiter = Character.valueOf(eDelimiter);
        }
        return theDelimiter.charValue();
    }

    @Override
    public boolean isEmpty() {
        return this._immutableProperties.stream().filter(_propertie -> !_propertie.isEmpty()).findFirst().map(immutableProperties -> false).orElse(true);
    }

    @Override
    public Set<String> keySet() {
        LinkedHashSet<String> theSet = new LinkedHashSet<String>();
        for (ImmutableProperties _propertie : this._immutableProperties) {
            theSet.addAll(_propertie.keySet());
        }
        return theSet;
    }

    @Override
    public Properties retrieveFrom(String aFromPath) {
        MapProperties theBuilder = new MapProperties();
        for (int i = this._immutableProperties.size() - 1; i >= 0; --i) {
            theBuilder.insert(this._immutableProperties.get(i).retrieveFrom(aFromPath));
        }
        return theBuilder;
    }

    @Override
    public Properties retrieveTo(String aToPath) {
        MapProperties theBuilder = new MapProperties();
        for (int i = this._immutableProperties.size() - 1; i >= 0; --i) {
            theBuilder.insert(this._immutableProperties.get(i).retrieveTo(aToPath));
        }
        return theBuilder;
    }

    @Override
    public int size() {
        int size = 0;
        for (ImmutableProperties _propertie : this._immutableProperties) {
            size += _propertie.size();
        }
        return size;
    }

    @Override
    public Object toDataStructure(String aFromPath) {
        MapProperties theProperties = new MapProperties();
        for (int i = this._immutableProperties.size() - 1; i >= 0; --i) {
            theProperties.insert(this._immutableProperties.get(i).retrieveFrom(aFromPath));
        }
        return theProperties.toDataStructure();
    }

    @Override
    public Collection<String> values() {
        ArrayList<String> theCollection = new ArrayList<String>();
        for (ImmutableProperties _propertie : this._immutableProperties) {
            theCollection.addAll(_propertie.values());
        }
        return theCollection;
    }
}

