/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.properties;

import org.refcodes.data.Delimiters;
import org.refcodes.mixin.ArrayIndexAccessor;
import org.refcodes.mixin.DelimitersAccessor;
import org.refcodes.mixin.EnvelopeAccessor;
import org.refcodes.properties.DocumentMetrics;

public class DocumentMetricsBuilder
implements DocumentMetrics {
    private static final char[] DEFAULT_DELIMITERS = Delimiters.PROPERTIES.getChars();
    private static final boolean DEFAULT_ENVELOPE = false;
    private static final boolean DEFAULT_ARRAY_INDEX = false;
    private final boolean _isArrayIndex;
    private final boolean _isEnvelope;
    private final char[] _delimiters;

    private DocumentMetricsBuilder(Builder builder) {
        this._isArrayIndex = builder.isArrayIndex;
        this._isEnvelope = builder.isEnvelope;
        this._delimiters = builder.delimiters;
    }

    @Override
    public boolean hasArrayIndex() {
        return this._isArrayIndex;
    }

    @Override
    public boolean hasEnvelope() {
        return this._isEnvelope;
    }

    @Override
    public char[] getDelimiters() {
        return this._delimiters;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder
    implements ArrayIndexAccessor.ArrayIndexBuilder<Builder>,
    EnvelopeAccessor.EnvelopeBuilder<Builder>,
    DelimitersAccessor.DelimitersBuilder<Builder> {
        private boolean isArrayIndex = false;
        private boolean isEnvelope = false;
        private char[] delimiters = DEFAULT_DELIMITERS;

        private Builder() {
        }

        @Override
        public Builder withArrayIndex(boolean isArrayIndex) {
            this.isArrayIndex = isArrayIndex;
            return this;
        }

        @Override
        public Builder withEnvelope(boolean isEnvelope) {
            this.isEnvelope = isEnvelope;
            return this;
        }

        @Override
        public Builder withDelimiters(char ... aDelimiters) {
            this.delimiters = aDelimiters;
            return this;
        }

        public DocumentMetrics build() {
            return new DocumentMetricsBuilder(this);
        }
    }
}

