/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.observer;

import org.refcodes.matcher.Matcher;
import org.refcodes.matcher.MatcherSchema;
import org.refcodes.matcher.MatcherSugar;
import org.refcodes.observer.ActionEqualWithEventMatcher;
import org.refcodes.observer.AliasEqualWithEventMatcher;
import org.refcodes.observer.CatchAllEventMatcher;
import org.refcodes.observer.CatchNoneEventMatcher;
import org.refcodes.observer.ChannelEqualWithEventMatcher;
import org.refcodes.observer.EventMatcher;
import org.refcodes.observer.GroupEqualWithEventMatcher;
import org.refcodes.observer.MetaDataActionEvent;
import org.refcodes.observer.MetaDataEvent;
import org.refcodes.observer.PublisherTypeOfEventMatcher;
import org.refcodes.observer.UniversalIdEqualWithEventMatcher;

public class EventMatcherSugar {
    private EventMatcherSugar() {
        throw new IllegalStateException("Utility class");
    }

    public static <E extends MetaDataEvent<?, ?>> EventMatcher<E> catchAll() {
        return new CatchAllEventMatcher();
    }

    public static <E extends MetaDataEvent<?, ?>> EventMatcher<E> catchNone() {
        return new CatchNoneEventMatcher();
    }

    public static <E extends MetaDataEvent<?, ?>> EventMatcher<E> isAssignableFrom(Class<?> aEventType) {
        return new EventMatcherWrapper(MatcherSugar.isAssignableFrom(aEventType));
    }

    public static <E extends MetaDataEvent<?, ?>, PT> EventMatcher<E> publisherIsAssignableFrom(Class<? extends PT> aPublisherType) {
        return new PublisherTypeOfEventMatcher(aPublisherType);
    }

    @SafeVarargs
    public static <E extends MetaDataEvent<?, ?>> EventMatcher<E> or(EventMatcher<E> ... aEventMatchers) {
        return new EventMatcherWrapper<E>(MatcherSugar.or(aEventMatchers));
    }

    @SafeVarargs
    public static <E extends MetaDataEvent<?, ?>> EventMatcher<E> and(EventMatcher<E> ... aEventMatchers) {
        return new EventMatcherWrapper<E>(MatcherSugar.and(aEventMatchers));
    }

    public static <E extends MetaDataEvent<?, ?>> EventMatcher<E> aliasEqualWith(String aAlias) {
        return new AliasEqualWithEventMatcher(aAlias);
    }

    public static <E extends MetaDataEvent<?, ?>> EventMatcher<E> groupEqualWith(String aGroup) {
        return new GroupEqualWithEventMatcher(aGroup);
    }

    public static <E extends MetaDataEvent<?, ?>> EventMatcher<E> channelEqualWith(String aChannel) {
        return new ChannelEqualWithEventMatcher(aChannel);
    }

    public static <E extends MetaDataEvent<?, ?>> EventMatcher<E> universalIdEqualWith(String aUid) {
        return new UniversalIdEqualWithEventMatcher(aUid);
    }

    public static <E extends MetaDataActionEvent<A, ?, ?>, A> EventMatcher<E> actionEqualWith(A aAction) {
        return new ActionEqualWithEventMatcher(aAction);
    }

    static class EventMatcherWrapper<E extends MetaDataEvent<?, ?>>
    implements EventMatcher<E> {
        private final Matcher<E> _eventMatcher;

        public EventMatcherWrapper(Matcher<E> aMatcher) {
            assert (aMatcher != null);
            this._eventMatcher = aMatcher;
        }

        @Override
        public boolean isMatching(E aEvent) {
            return this._eventMatcher.isMatching(aEvent);
        }

        @Override
        public MatcherSchema toSchema() {
            return MatcherSchema.builder().withInstance(this).withSchema(this._eventMatcher.toSchema()).build();
        }

        @Override
        public String getAlias() {
            return this._eventMatcher.getAlias();
        }
    }
}

