/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.net;

import org.refcodes.net.IpAddress;

public interface IpAddressAccessor {
    public int[] getIpAddress();

    default public String toCidrNotation() {
        int[] theIpAddress = this.getIpAddress();
        if (theIpAddress == null) {
            return null;
        }
        if (theIpAddress.length == 0) {
            return "";
        }
        try {
            return IpAddress.toString(theIpAddress);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalStateException("Cannot create CIDR notation for IP address <" + String.valueOf(theIpAddress) + ">!", e);
        }
    }

    public static interface IpAddressProperty
    extends IpAddressAccessor,
    IpAddressMutator {
        default public int[] letIpAddress(int[] aIpAddress) {
            this.setIpAddress(aIpAddress);
            return aIpAddress;
        }
    }

    public static interface IpAddressBuilder<B extends IpAddressBuilder<B>> {
        public B withIpAddress(int[] var1);

        public B withCidrNotation(String var1);
    }

    public static interface IpAddressMutator {
        public void setIpAddress(int[] var1);

        default public void fromCidrNotation(String aCidrNotation) {
            this.setIpAddress(IpAddress.fromAnyCidrNotation(aCidrNotation));
        }
    }
}

