/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.net;

import java.io.IOException;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import java.util.StringTokenizer;
import org.refcodes.data.Delimiter;
import org.refcodes.exception.UnhandledEnumBugException;
import org.refcodes.runtime.Host;

public enum IpAddress {
    IPV4(4, new int[]{0, 0, 0, 0}, new int[]{127, 0, 0, 1}, new int[]{255, 255, 255, 255}, "0.0.0.0", "127.0.0.1", "localhost", '.'),
    IPV6(16, new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1}, null, "::", "::1", "localhost", ':');

    private int _length;
    private int[] _unspecified;
    private String _cidrUnspecified;
    private int[] _localhost;
    private String _cidrLocalhost;
    private String _localhostAlias;
    private char _cidrDelimiter;
    private int[] _broadcast;

    private IpAddress(int aLength, int[] aUnspecified, int[] aLocalhost, int[] aBroadcast, String aCidrUnspecified, String aCidrLocalhost, String aLocalhostAlias, char aCidrDelimiter) {
        this._length = aLength;
        this._unspecified = aUnspecified;
        this._localhost = aLocalhost;
        this._cidrUnspecified = aCidrUnspecified;
        this._cidrLocalhost = aCidrLocalhost;
        this._localhostAlias = aLocalhostAlias;
        this._cidrDelimiter = aCidrDelimiter;
        this._broadcast = aBroadcast;
    }

    public int getLength() {
        return this._length;
    }

    public int[] getUnspecified() {
        return (int[])this._unspecified.clone();
    }

    public String getCidrUnspecified() {
        return this._cidrUnspecified;
    }

    public int[] getLocalhost() {
        return (int[])this._localhost.clone();
    }

    public int[] getBroadcast() {
        return (int[])this._broadcast.clone();
    }

    public String getCidrLocalhost() {
        return this._cidrLocalhost;
    }

    public String getLocalhostAlias() {
        return this._localhostAlias;
    }

    public char getCidrDelimiter() {
        return this._cidrDelimiter;
    }

    public String toCidrNotation(int[] theIpAddress) {
        if (theIpAddress == null) {
            return null;
        }
        if (theIpAddress.length == 0) {
            return "";
        }
        if (theIpAddress.length == this._length) {
            block15: {
                int i;
                block14: {
                    for (i = 0; i < this._localhost.length; ++i) {
                        if (theIpAddress[i] == this._localhost[i]) {
                            continue;
                        }
                        break block14;
                    }
                    return this._cidrLocalhost;
                }
                for (i = 0; i < this._unspecified.length; ++i) {
                    if (theIpAddress[i] == this._unspecified[i]) {
                        continue;
                    }
                    break block15;
                }
                return this._cidrUnspecified;
            }
            StringBuilder theBuffer = new StringBuilder();
            for (int i = 0; i < this._length; ++i) {
                switch (this.ordinal()) {
                    case 0: {
                        Object eValue = Integer.toString(theIpAddress[i]);
                        theBuffer.append((String)eValue);
                        break;
                    }
                    case 1: {
                        Object eValue = Integer.toHexString(theIpAddress[i]);
                        if (((String)eValue).length() < 2) {
                            eValue = "0" + (String)eValue;
                        }
                        theBuffer.append((String)eValue);
                        break;
                    }
                    default: {
                        throw new UnhandledEnumBugException(this);
                    }
                }
                if (i >= this._length - 1 || this == IPV6 && i % 2 == 0) continue;
                theBuffer.append(this._cidrDelimiter);
            }
            return theBuffer.toString();
        }
        StringBuilder theBuffer = new StringBuilder();
        for (int i = 0; i < theIpAddress.length - 1; ++i) {
            theBuffer.append(Integer.toString(theIpAddress[i]));
            if (i >= theIpAddress.length - 1) continue;
            theBuffer.append(Delimiter.ARRAY.getChar());
        }
        throw new IllegalArgumentException("The IP-Address <" + theBuffer.toString() + "> (in decimal) is neither of format IPv4 nor of format IPv6!");
    }

    public int[] fromCidrNotation(String aCidrNotation) {
        if (aCidrNotation == null) {
            return null;
        }
        if (aCidrNotation.isEmpty()) {
            return this._unspecified;
        }
        if (this._cidrLocalhost.equals(aCidrNotation) || this._localhostAlias.equals(aCidrNotation)) {
            return this._localhost;
        }
        if (this._cidrUnspecified.equals(aCidrNotation)) {
            return this._unspecified;
        }
        if (aCidrNotation.indexOf(this._cidrDelimiter) != -1) {
            int i;
            StringTokenizer theTokenizer = new StringTokenizer(aCidrNotation, "" + this._cidrDelimiter);
            int[] theIpAddress = new int[this._length];
            block4: for (i = 0; theTokenizer.hasMoreElements() && i < this._length; ++i) {
                Object eToken = theTokenizer.nextToken();
                switch (this.ordinal()) {
                    case 0: {
                        theIpAddress[i] = Integer.valueOf((String)eToken);
                        if (theIpAddress[i] <= 255 && theIpAddress[i] >= 0) continue block4;
                        throw new IllegalArgumentException("The value <" + theIpAddress[i] + "> at element index [" + i + "] (with a 2-digit hex value, e.g.'00' or 'FF' per element, beginning with index 0) for IP-Address <" + aCidrNotation + "> is out range!");
                    }
                    case 1: {
                        if (((String)eToken).length() > 4) {
                            throw new IllegalArgumentException("The value tupel <" + (String)eToken + "> beginning at elelment index [" + i + "] (with a 2-digit hex value, e.g.'00' or 'FF' per element, beginning with index 0) for IP-Address <" + aCidrNotation + "> has a wrong format!");
                        }
                        while (((String)eToken).length() < 4) {
                            eToken = "0" + (String)eToken;
                        }
                        theIpAddress[i] = Integer.valueOf(((String)eToken).substring(0, 2), 16);
                        if (theIpAddress[i] > 255 || theIpAddress[i] < 0) {
                            throw new IllegalArgumentException("The value <" + theIpAddress[i] + "> at element index [" + i + "] (with a 2-digit hex value, e.g.'00' or 'FF' per element, beginning with index 0) for IP-Address <" + aCidrNotation + "> is out range!");
                        }
                        theIpAddress[++i] = Integer.valueOf(((String)eToken).substring(2, 4), 16);
                        if (theIpAddress[i] <= 255 && theIpAddress[i] >= 0) continue block4;
                        throw new IllegalArgumentException("The value <" + theIpAddress[i] + "> at element index [" + i + "] (with 2-digit hex value, e.g.'00' or 'FF' per element, beginning with index 0) for IP-Address <" + aCidrNotation + "> is out range!");
                    }
                    default: {
                        throw new UnhandledEnumBugException(this);
                    }
                }
            }
            if (i == this._length) {
                return theIpAddress;
            }
        }
        throw new IllegalArgumentException("The String passed as IP-Address <" + aCidrNotation + "> is not an IP-Address!");
    }

    public static String toString(int[] aIpAddress) {
        if (aIpAddress == null) {
            return null;
        }
        if (aIpAddress.length == 0) {
            return "";
        }
        for (IpAddress eAddress : IpAddress.values()) {
            if (aIpAddress.length != eAddress.getLength()) continue;
            return eAddress.toCidrNotation(aIpAddress);
        }
        StringBuilder theBuffer = new StringBuilder();
        for (int i = 0; i < aIpAddress.length - 1; ++i) {
            theBuffer.append(Integer.toString(aIpAddress[i]));
            if (i >= aIpAddress.length - 1) continue;
            theBuffer.append(Delimiter.ARRAY.getChar());
        }
        throw new IllegalArgumentException("The IP-Address <" + theBuffer.toString() + "> (in decimal) is neither of format IPv4 nor of format IPv6!");
    }

    public static boolean isLocalhost(int[] aIpAddress) {
        return Arrays.equals(IPV4.getLocalhost(), aIpAddress) || Arrays.equals(IPV6.getLocalhost(), aIpAddress);
    }

    public static boolean isLoopback(int[] aIpAddress) {
        if (aIpAddress.length == IPV4.getLength()) {
            if (aIpAddress[0] == IPV4.getLocalhost()[0]) {
                return true;
            }
        } else if (aIpAddress.length == IPV6.getLength()) {
            for (int i = 0; i < IPV6.getLocalhost().length - 1; ++i) {
                if (aIpAddress[i] == IPV6.getLocalhost()[i]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static boolean isBroadcast(int[] aIpAddress) {
        if (aIpAddress.length == IPV4.getLength()) {
            for (int i = 0; i < IPV4.getBroadcast().length; ++i) {
                if (IPV4.getBroadcast()[i] == aIpAddress[i]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static int[] fromAnyCidrNotation(String aCidrNotation) {
        if (aCidrNotation == null) {
            return null;
        }
        for (IpAddress eAddress : IpAddress.values()) {
            if (aCidrNotation.indexOf(eAddress.getCidrDelimiter()) == -1) continue;
            return eAddress.fromCidrNotation(aCidrNotation);
        }
        throw new IllegalArgumentException("The IP-Address <" + aCidrNotation + "> is neither of format IPv4 nor of format IPv6!");
    }

    public static int[] toHostIpAddress() throws IOException {
        Enumeration<NetworkInterface> eNetworks = NetworkInterface.getNetworkInterfaces();
        while (eNetworks.hasMoreElements()) {
            NetworkInterface eNetwork = eNetworks.nextElement();
            if (eNetwork.getDisplayName() != null && eNetwork.getDisplayName().toLowerCase().contains("Loopback")) continue;
            Enumeration<InetAddress> eAddresses = eNetwork.getInetAddresses();
            while (eAddresses.hasMoreElements()) {
                try {
                    InetAddress nextElement = eAddresses.nextElement();
                    int[] eIpAddress = IpAddress.fromAnyCidrNotation(nextElement.getHostAddress());
                    if (IpAddress.isLoopback(eIpAddress)) continue;
                    return eIpAddress;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                }
            }
        }
        return IpAddress.fromAnyCidrNotation(InetAddress.getLocalHost().getHostAddress());
    }

    public static boolean isAnyCidrNotation(String aCidrNotation) {
        try {
            return IpAddress.fromAnyCidrNotation(aCidrNotation) != null;
        }
        catch (IllegalArgumentException irgnore) {
            return false;
        }
    }

    public boolean isCidrNotation(String aCidrNotation) {
        try {
            return this.fromCidrNotation(aCidrNotation) != null;
        }
        catch (IllegalArgumentException irgnore) {
            return false;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static Set<String> toVisibleIpAddresses() {
        HashSet<String> theCidrNotations = new HashSet<String>();
        ArrayList<Object> theExecs = new ArrayList<Object>();
        theExecs.add("arp -a");
        try {
            void var3_6;
            int[] theIpAddress = IpAddress.toHostIpAddress();
            String string = "";
            if (theIpAddress.length == IPV4.getLength()) {
                for (int i = 0; i < theIpAddress.length - 1; ++i) {
                    String string2 = (String)var3_6 + theIpAddress[i];
                    if (i >= theIpAddress.length - 2) continue;
                    String string3 = string2 + IPV4.getCidrDelimiter();
                }
            }
            theExecs.add("nmap -sn -oG ip.txt " + (String)var3_6 + ".1-255");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            for (String string : theExecs) {
                String[] theElements;
                String theResult = Host.exec(string);
                for (String eElement : theElements = theResult.split(" +")) {
                    try {
                        int[] eIpAddress = IpAddress.fromAnyCidrNotation(eElement);
                        if (eIpAddress == null || IpAddress.isLocalhost(eIpAddress) || IpAddress.isBroadcast(eIpAddress) || eElement.equals(IpAddress.toString(IpAddress.toHostIpAddress()))) continue;
                        theCidrNotations.add(eElement);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        // empty catch block
                    }
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return theCidrNotations;
    }
}

