/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.logger.ext.slf4j;

import org.refcodes.exception.UnhandledEnumBugException;
import org.refcodes.exception.UnhandledValueBugException;
import org.refcodes.logger.LogPriority;
import org.refcodes.logger.RuntimeLogger;
import org.refcodes.logger.RuntimeLoggerAccessor;
import org.slf4j.Marker;
import org.slf4j.event.Level;
import org.slf4j.helpers.LegacyAbstractLogger;
import org.slf4j.spi.LocationAwareLogger;

public final class RuntimeLoggerAdapter
extends LegacyAbstractLogger
implements LocationAwareLogger,
RuntimeLoggerAccessor {
    private static final long serialVersionUID = 1L;
    final transient RuntimeLogger logger;

    public RuntimeLoggerAdapter(RuntimeLogger logger) {
        this.logger = logger;
        this.name = logger.getName();
    }

    @Override
    public boolean isTraceEnabled() {
        return this.logger.isLogTrace();
    }

    @Override
    public void trace(String msg) {
        this.logger.trace(msg);
    }

    @Override
    public void trace(String format, Object arg) {
        this.logger.trace(format, arg);
    }

    @Override
    public void trace(String format, Object arg1, Object arg2) {
        this.logger.trace(format, arg1, arg2);
    }

    @Override
    public void trace(String format, Object ... args) {
        this.logger.trace(format, args);
    }

    @Override
    public void trace(String msg, Throwable t) {
        this.logger.trace(msg, t);
    }

    @Override
    public boolean isDebugEnabled() {
        return this.logger.isLogDebug();
    }

    @Override
    public void debug(String msg) {
        this.logger.debug(msg);
    }

    @Override
    public void debug(String format, Object arg) {
        this.logger.debug(format, arg);
    }

    @Override
    public void debug(String format, Object arg1, Object arg2) {
        this.logger.debug(format, arg1, arg2);
    }

    @Override
    public void debug(String format, Object ... args) {
        this.logger.debug(format, args);
    }

    @Override
    public void debug(String msg, Throwable t) {
        this.logger.debug(msg, t);
    }

    @Override
    public boolean isInfoEnabled() {
        return this.logger.isLogInfo();
    }

    @Override
    public void info(String msg) {
        this.logger.info(msg);
    }

    @Override
    public void info(String format, Object arg) {
        this.logger.info(format, arg);
    }

    @Override
    public void info(String format, Object arg1, Object arg2) {
        this.logger.info(format, arg1, arg2);
    }

    @Override
    public void info(String format, Object ... args) {
        this.logger.info(format, args);
    }

    @Override
    public void info(String msg, Throwable t) {
        this.logger.info(msg, t);
    }

    @Override
    public boolean isWarnEnabled() {
        return this.logger.isLogWarn();
    }

    @Override
    public void warn(String msg) {
        this.logger.warn(msg);
    }

    @Override
    public void warn(String format, Object arg) {
        this.logger.warn(format, arg);
    }

    @Override
    public void warn(String format, Object arg1, Object arg2) {
        this.logger.warn(format, arg1, arg2);
    }

    @Override
    public void warn(String format, Object ... args) {
        this.logger.warn(format, args);
    }

    @Override
    public void warn(String msg, Throwable t) {
        this.logger.warn(msg, t);
    }

    @Override
    public boolean isErrorEnabled() {
        return this.logger.isLogError();
    }

    @Override
    public void error(String msg) {
        this.logger.error(msg);
    }

    @Override
    public void error(String format, Object arg) {
        this.logger.error(format, arg);
    }

    @Override
    public void error(String format, Object arg1, Object arg2) {
        this.logger.error(format, arg1, arg2);
    }

    @Override
    public void error(String format, Object ... args) {
        this.logger.error(format, args);
    }

    @Override
    public void error(String msg, Throwable t) {
        this.logger.error(msg, t);
    }

    @Override
    public void log(Marker aMarker, String aCallerFQCN, int aLevel, String aMessage, Object[] aArgs, Throwable aThrowable) {
        this.logger.log(switch (aLevel) {
            case 0 -> LogPriority.TRACE;
            case 10 -> LogPriority.DEBUG;
            case 20 -> LogPriority.INFO;
            case 30 -> LogPriority.WARN;
            case 40 -> LogPriority.ERROR;
            default -> throw new UnhandledValueBugException(aLevel);
        }, aMessage, aArgs, (Object)aThrowable);
    }

    @Override
    public RuntimeLogger getRuntimeLogger() {
        return this.logger;
    }

    @Override
    protected String getFullyQualifiedCallerName() {
        return this.logger.getName();
    }

    @Override
    protected void handleNormalizedLoggingCall(Level aLevel, Marker aMarker, String aMsg, Object[] aArguments, Throwable aThrowable) {
        this.logger.log(switch (aLevel) {
            case Level.DEBUG -> LogPriority.DEBUG;
            case Level.ERROR -> LogPriority.ERROR;
            case Level.INFO -> LogPriority.INFO;
            case Level.TRACE -> LogPriority.TRACE;
            case Level.WARN -> LogPriority.WARN;
            default -> throw new UnhandledEnumBugException(aLevel);
        }, aMsg, aThrowable, aArguments);
    }
}

