/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.logger.alt.slf4j;

import org.refcodes.logger.DefaultRuntimeLogger;
import org.refcodes.logger.IllegalRecordRuntimeException;
import org.refcodes.logger.LogPriority;
import org.refcodes.logger.Logger;
import org.refcodes.logger.LoggerField;
import org.refcodes.logger.RuntimeLogger;
import org.refcodes.logger.RuntimeLoggerSingleton;
import org.refcodes.mixin.NameAccessor;
import org.refcodes.runtime.Execution;
import org.refcodes.tabular.ColumnMismatchException;
import org.refcodes.tabular.Record;
import org.slf4j.LoggerFactory;

public class Slf4jLogger
implements Logger<Object>,
NameAccessor.NameMutator {
    private transient org.slf4j.Logger _logger;

    public Slf4jLogger() {
        StackTraceElement theCaller = Execution.probeTillNoneLoggerElement(DefaultRuntimeLogger.class, RuntimeLogger.class, RuntimeLoggerSingleton.class, Slf4jLogger.class);
        this._logger = LoggerFactory.getLogger(theCaller.getClassName());
    }

    public Slf4jLogger(String aName) {
        this._logger = LoggerFactory.getLogger(aName);
    }

    @Override
    public void log(Record<? extends Object> aRecord) {
        try {
            LogPriority thePriority = (LogPriority)((Object)LoggerField.LOG_PRIORITY.getColumn().get(aRecord));
            String theLogMessage = (String)LoggerField.LOG_MESSAGE.getColumn().get(aRecord);
            Exception theException = (Exception)LoggerField.LOG_NONE_STACKTRRACE_EXCEPTION.getColumn().get(aRecord);
            switch (thePriority) {
                case PANIC: {
                    this._logger.error(theLogMessage, theException);
                    break;
                }
                case ALERT: {
                    this._logger.error(theLogMessage, theException);
                    break;
                }
                case CRITICAL: {
                    this._logger.error(theLogMessage, theException);
                    break;
                }
                case ERROR: {
                    this._logger.error(theLogMessage, theException);
                    break;
                }
                case WARN: {
                    this._logger.warn(theLogMessage, theException);
                    break;
                }
                case NOTICE: {
                    this._logger.info(theLogMessage, theException);
                    break;
                }
                case INFO: {
                    this._logger.info(theLogMessage, theException);
                    break;
                }
                case DEBUG: {
                    this._logger.debug(theLogMessage, theException);
                    break;
                }
                case TRACE: {
                    this._logger.trace(theLogMessage, theException);
                    break;
                }
                case NONE: {
                    break;
                }
            }
        }
        catch (ClassCastException | ColumnMismatchException e) {
            throw new IllegalRecordRuntimeException(aRecord, (Throwable)e);
        }
    }

    @Override
    public void setName(String aName) {
        this._logger = LoggerFactory.getLogger(aName);
    }
}

