/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.logger;

import java.util.Collections;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.logging.Handler;
import java.util.logging.LogRecord;
import org.refcodes.logger.LogPriority;
import org.refcodes.logger.RuntimeLogger;
import org.refcodes.logger.RuntimeLoggerFactorySingleton;

public class RuntimeLoggerHandler
extends Handler {
    private final Set<String> _julLoggerNames = Collections.newSetFromMap(new WeakHashMap());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void publish(LogRecord aRecord) {
        String theLoggerName = aRecord.getLoggerName();
        RuntimeLogger theRuntimeLogger = RuntimeLoggerFactorySingleton.createRuntimeLogger(theLoggerName);
        if (!this._julLoggerNames.contains(theLoggerName)) {
            Set<String> set = this._julLoggerNames;
            synchronized (set) {
                if (!this._julLoggerNames.contains(theLoggerName)) {
                    this._julLoggerNames.add(theLoggerName);
                    theRuntimeLogger.log(LogPriority.DEBUG, "Created JUL logger <" + theLoggerName + "> ...");
                }
            }
        }
        theRuntimeLogger.log(aRecord);
    }

    @Override
    public void flush() {
    }

    @Override
    public void close() {
    }
}

