/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.logger;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import org.refcodes.data.Delimiter;
import org.refcodes.logger.DefaultRuntimeLogger;
import org.refcodes.logger.LoggerInstantiationRuntimeException;
import org.refcodes.logger.RuntimeLogger;
import org.refcodes.logger.RuntimeLoggerFactory;
import org.refcodes.logger.SystemLogger;
import org.refcodes.mixin.NameAccessor;
import org.refcodes.properties.ImmutableProperties;
import org.refcodes.properties.MapProperties;
import org.refcodes.properties.Properties;
import org.refcodes.properties.ext.application.CliApplicationProperties;
import org.refcodes.runtime.Execution;

public class DefaultRuntimeLoggerFactory
implements RuntimeLoggerFactory {
    private static final String NAME_PROPERTY = "name";
    private static final String CONFIG_LOCATOR = "runtimelogger";
    private static final DefaultRuntimeLogger FALLBACK_RUNTIME_LOGGER = new DefaultRuntimeLogger(new SystemLogger());
    private static final String SKIP_LOGGER_CONFIG_FILE_LIB = "org.apache.commons.configuration.DefaultFileSystem";
    private static final Map<String, ImmutableProperties> CONFIG_TO_PROPERTIES = new WeakHashMap<String, ImmutableProperties>();
    private final ConcurrentHashMap<String, RuntimeLogger> _nameToRuntimeLoggerMap = new ConcurrentHashMap();

    protected DefaultRuntimeLoggerFactory() {
    }

    @Override
    public RuntimeLogger create() {
        String theClassName = Execution.getCallerStackTraceElement(DefaultRuntimeLoggerFactory.class).getClassName();
        return this.create(theClassName);
    }

    @Override
    public RuntimeLogger create(String aIdentifier) {
        Objects.requireNonNull(aIdentifier, "aIdentifier");
        RuntimeLogger theRuntimeLogger = this._nameToRuntimeLoggerMap.get(aIdentifier);
        if (theRuntimeLogger != null) {
            return theRuntimeLogger;
        }
        ArrayList<String> theNames = new ArrayList<String>();
        RuntimeLogger theRootLogger = this._nameToRuntimeLoggerMap.get("root");
        if (theRootLogger == null) {
            try {
                theRootLogger = DefaultRuntimeLoggerFactory.fromConfigurationFile("root", CONFIG_LOCATOR);
            }
            catch (LoggerInstantiationRuntimeException e) {
                SystemLogger theLogger = new SystemLogger();
                theRootLogger = new DefaultRuntimeLogger(theLogger);
                theRootLogger.warn("Using fallback logger as the <runtimelogger.*> file does neither contain a valid runtime logger configuration for the namespace <" + aIdentifier + "> (or its children) nor for the root logger: " + e.getMessage());
            }
            if (theRootLogger == null) {
                throw new LoggerInstantiationRuntimeException("The <{0}(.*)> file does neither contain a valid runtime logger configuration for the namespace <{1}> (or its children) nor for the root logger!", CONFIG_LOCATOR, aIdentifier);
            }
            this._nameToRuntimeLoggerMap.putIfAbsent("root", theRootLogger);
        }
        String eIdentifier = aIdentifier.replace(Delimiter.INNER_CLASS.getChar(), Delimiter.PACKAGE_HIERARCHY.getChar());
        int i = aIdentifier.length();
        while (i > 0) {
            eIdentifier = eIdentifier.substring(0, i);
            theNames.add(eIdentifier);
            theRuntimeLogger = this._nameToRuntimeLoggerMap.get(eIdentifier);
            if (theRuntimeLogger != null) break;
            try {
                theRuntimeLogger = DefaultRuntimeLoggerFactory.fromConfigurationFile(eIdentifier, CONFIG_LOCATOR);
                break;
            }
            catch (LoggerInstantiationRuntimeException loggerInstantiationRuntimeException) {
                i = eIdentifier.lastIndexOf(Delimiter.NAMESPACE.getChar());
            }
        }
        if (theRuntimeLogger == null) {
            if (SKIP_LOGGER_CONFIG_FILE_LIB.equals(aIdentifier)) {
                return FALLBACK_RUNTIME_LOGGER;
            }
            if (!"root".equals(aIdentifier)) {
                theRuntimeLogger = theRootLogger;
            }
        }
        for (String eName : theNames) {
            this._nameToRuntimeLoggerMap.putIfAbsent(eName, theRuntimeLogger);
        }
        RuntimeLogger theRaceWinner = this._nameToRuntimeLoggerMap.get(aIdentifier);
        return theRaceWinner != null ? theRaceWinner : theRuntimeLogger;
    }

    public static RuntimeLogger fromConfigurationFile(String aNamespace, String aConfigFileName) {
        try {
            ImmutableProperties theImmutableProperties = CONFIG_TO_PROPERTIES.get(aConfigFileName);
            if (theImmutableProperties == null) {
                theImmutableProperties = new CliApplicationProperties().withResourceFilePath(aConfigFileName);
                CONFIG_TO_PROPERTIES.put(aConfigFileName, theImmutableProperties);
            }
            String thePath = aNamespace.replace(Delimiter.PACKAGE_HIERARCHY.getChar(), Delimiter.PATH.getChar());
            Properties theRootProperties = theImmutableProperties.retrieveFrom("root");
            if ("root".equals(aNamespace)) {
                theImmutableProperties = theRootProperties;
            } else {
                MapProperties theNewProperties = new MapProperties(theImmutableProperties.retrieveFrom(thePath));
                Iterator e = theNewProperties.keySet().iterator();
                while (e.hasNext()) {
                    String[] ePathElements = theNewProperties.toPathElements((String)e.next());
                    if (ePathElements != null && ePathElements.length != 0 && CONFIG_LOCATOR.equals(ePathElements[0])) continue;
                    e.remove();
                }
                if (!theNewProperties.isEmpty()) {
                    for (String eKey : theRootProperties.keySet()) {
                        if (theNewProperties.containsKey((Object)eKey)) continue;
                        theNewProperties.put(eKey, (String)theRootProperties.get((Object)eKey));
                    }
                }
                theImmutableProperties = theNewProperties;
            }
            RuntimeLogger theRuntimeLogger = theImmutableProperties.toType(CONFIG_LOCATOR, RuntimeLogger.class);
            if (theRuntimeLogger instanceof NameAccessor.NameMutator) {
                String theName = (String)theImmutableProperties.get(CONFIG_LOCATOR, NAME_PROPERTY);
                if (theName == null || theName.isEmpty()) {
                    ((NameAccessor.NameMutator)((Object)theRuntimeLogger)).setName(aNamespace);
                } else {
                    ((NameAccessor.NameMutator)((Object)theRuntimeLogger)).setName(theName);
                }
            }
            return theRuntimeLogger;
        }
        catch (Exception e) {
            throw new LoggerInstantiationRuntimeException("Cannot create logger from configuration file <{0}> with namespace (for package) <{1}>!", aConfigFileName, aNamespace, e);
        }
    }
}

