/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.io;

import java.io.IOException;
import java.io.OutputStream;

public class OutputStreamComposite
extends OutputStream {
    private final OutputStream[] _outputStreams;

    public OutputStreamComposite(OutputStream ... aOutputStreams) {
        this._outputStreams = aOutputStreams;
    }

    @Override
    public void write(int b) throws IOException {
        for (OutputStream eStream : this._outputStreams) {
            eStream.write(b);
        }
    }

    @Override
    public void write(byte[] b) throws IOException {
        for (OutputStream eStream : this._outputStreams) {
            eStream.write(b);
        }
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        for (OutputStream eStream : this._outputStreams) {
            eStream.write(b, off, len);
        }
    }

    @Override
    public void flush() throws IOException {
        for (OutputStream eStream : this._outputStreams) {
            eStream.flush();
        }
    }

    @Override
    public void close() throws IOException {
        super.close();
        for (OutputStream eStream : this._outputStreams) {
            eStream.close();
        }
    }
}

