/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.io;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Random;
import org.refcodes.data.Delimiter;
import org.refcodes.data.Encoding;
import org.refcodes.data.FilenameExtension;
import org.refcodes.data.Scheme;
import org.refcodes.runtime.Host;
import org.refcodes.textual.CsvBuilder;
import org.refcodes.textual.CsvEscapeMode;
import org.refcodes.textual.RandomTextGenerartor;
import org.refcodes.textual.RandomTextMode;

public final class FileUtility {
    private static final Random RND = new Random();

    private FileUtility() {
    }

    public static boolean isEqual(File aFileA, File aFileB) throws IOException {
        if (aFileA.length() != aFileB.length()) {
            return false;
        }
        try (BufferedInputStream theExpectedInputStream = new BufferedInputStream(new FileInputStream(aFileA));
             BufferedInputStream theCompareInputStream = new BufferedInputStream(new FileInputStream(aFileB));){
            int expected;
            while ((expected = ((InputStream)theExpectedInputStream).read()) != -1) {
                int compare = ((InputStream)theCompareInputStream).read();
                if (expected == compare) continue;
                boolean bl = false;
                return bl;
            }
        }
        return true;
    }

    public static URL createNestedJarFileUrl(URL aJarUrl, File aToDir) throws IOException {
        if (aJarUrl.getProtocol().equals(Scheme.FILE.getName())) {
            return aJarUrl;
        }
        if (!aJarUrl.getProtocol().equals(Scheme.JAR.getName())) {
            return null;
        }
        String theJarPath = new CsvBuilder().withCsvEscapeMode(CsvEscapeMode.ESCAPED).withFields(FileUtility.toJarHierarchy(aJarUrl)).withDelimiter(Delimiter.SYSTEM_FILE_PATH.getChar()).toRecord();
        File theJarDir = new File(aToDir, theJarPath);
        if (!theJarDir.exists() && !theJarDir.mkdirs()) {
            throw new IOException("Failed to create contents directory for archive, path=" + theJarDir.getAbsolutePath());
        }
        JarURLConnection theJarConnection = (JarURLConnection)aJarUrl.openConnection();
        String theEntyName = theJarConnection.getEntryName();
        File theEntryFile = new File(theJarDir, theEntyName);
        if (theEntyName.endsWith(String.valueOf(Delimiter.PATH))) {
            theEntryFile.mkdirs();
        } else {
            File theJarParentDir = theEntryFile.getParentFile();
            if (!theJarParentDir.exists() && !theJarParentDir.mkdirs()) {
                throw new IOException("Failed to create parent directory for archive, path=" + theJarParentDir.getAbsolutePath());
            }
            try (InputStream theJarInputStream = theJarConnection.getInputStream();
                 BufferedOutputStream theOutputStream = new BufferedOutputStream(new FileOutputStream(theEntryFile));){
                int eRead;
                byte[] theBuffer = new byte[4096];
                while ((eRead = theJarInputStream.read(theBuffer)) > 0) {
                    theOutputStream.write(theBuffer, 0, eRead);
                }
            }
        }
        return theEntryFile.toURI().toURL();
    }

    public static File createRandomTempFile(long aBytes) throws IOException {
        return FileUtility.createRandomTempFile(FileUtility.toTempBaseFileName(), aBytes, RandomTextMode.ASCII, true);
    }

    public static File createRandomTempFile(long aBytes, boolean isDeleteOnExit) throws IOException {
        return FileUtility.createRandomTempFile(FileUtility.toTempBaseFileName(), aBytes, RandomTextMode.ASCII, isDeleteOnExit);
    }

    public static File createRandomTempFile(long aBytes, RandomTextMode aRandomTextMode) throws IOException {
        return FileUtility.createRandomTempFile(FileUtility.toTempBaseFileName(), aBytes, aRandomTextMode, true);
    }

    public static File createRandomTempFile(long aBytes, RandomTextMode aRandomTextMode, boolean isDeleteOnExit) throws IOException {
        return FileUtility.createRandomTempFile(FileUtility.toTempBaseFileName(), aBytes, aRandomTextMode, isDeleteOnExit);
    }

    public static File createRandomTempFile(String aBaseFileName, long aBytes) throws IOException {
        return FileUtility.createRandomTempFile(aBaseFileName, aBytes, RandomTextMode.ASCII, true);
    }

    public static File createRandomTempFile(String aBaseFileName, long aBytes, boolean isDeleteOnExit) throws IOException {
        return FileUtility.createRandomTempFile(aBaseFileName, aBytes, RandomTextMode.ASCII, isDeleteOnExit);
    }

    public static File createRandomTempFile(String aBaseFileName, long aBytes, RandomTextMode aRandomTextMode) throws IOException {
        return FileUtility.createRandomTempFile(aBaseFileName, aBytes, aRandomTextMode, true);
    }

    public static File createRandomTempFile(String aBaseFileName, long aBytes, RandomTextMode aRandomTextMode, boolean isDeleteOnExit) throws IOException {
        int theLength = aRandomTextMode.getCharSet().length;
        File theTmpFile = new File(Host.getTempDir(), (aBaseFileName != null ? aBaseFileName : FileUtility.toTempBaseFileName()) + FilenameExtension.TEMP.getFilenameSuffix());
        if (isDeleteOnExit) {
            theTmpFile.deleteOnExit();
        }
        try (FileOutputStream theFileOut = new FileOutputStream(theTmpFile);
             BufferedOutputStream theBufOut = new BufferedOutputStream(theFileOut);){
            for (long i = 0L; i < aBytes; ++i) {
                ((OutputStream)theBufOut).write(aRandomTextMode.getCharSet()[RND.nextInt(theLength)]);
            }
        }
        return theTmpFile;
    }

    public static File createTempFile(long aBytes, byte aValue) throws IOException {
        return FileUtility.createTempFile(FileUtility.toTempBaseFileName(), aBytes, aValue, true);
    }

    public static File createTempFile(long aBytes, byte aValue, boolean isDeleteOnExit) throws IOException {
        return FileUtility.createTempFile(FileUtility.toTempBaseFileName(), aBytes, aValue, isDeleteOnExit);
    }

    public static File createTempFile(String aBaseFileName, long aBytes, byte aValue) throws IOException {
        return FileUtility.createTempFile(aBaseFileName, aBytes, aValue, true);
    }

    public static File createTempFile(String aBaseFileName, long aBytes, byte aValue, boolean isDeleteOnExit) throws IOException {
        File theTmpFile = new File(Host.getTempDir(), (aBaseFileName != null ? aBaseFileName : FileUtility.toTempBaseFileName()) + FilenameExtension.TEMP.getFilenameSuffix());
        if (isDeleteOnExit) {
            theTmpFile.deleteOnExit();
        }
        try (FileOutputStream theFileOut = new FileOutputStream(theTmpFile);
             BufferedOutputStream theBufOut = new BufferedOutputStream(theFileOut);){
            for (long i = 0L; i < aBytes; ++i) {
                ((OutputStream)theBufOut).write(aValue);
            }
        }
        return theTmpFile;
    }

    public static File createTempFile() throws IOException {
        return FileUtility.createTempFile(FileUtility.toTempBaseFileName(), true);
    }

    public static File createTempFile(boolean isDeleteOnExit) throws IOException {
        return FileUtility.createTempFile(FileUtility.toTempBaseFileName(), isDeleteOnExit);
    }

    public static File createTempFile(String aBaseFileName) throws IOException {
        return FileUtility.createTempFile(aBaseFileName, true);
    }

    public static File createTempFile(String aBaseFileName, boolean isDeleteOnExit) throws IOException {
        File theTmpFile = new File(Host.getTempDir(), (aBaseFileName != null ? aBaseFileName : FileUtility.toTempBaseFileName()) + FilenameExtension.TEMP.getFilenameSuffix());
        if (isDeleteOnExit) {
            theTmpFile.deleteOnExit();
        }
        return theTmpFile;
    }

    public static File openTempFile(String aBaseFileName) throws IOException {
        File theTmpFile = new File(Host.getTempDir(), aBaseFileName + FilenameExtension.TEMP.getFilenameSuffix());
        return theTmpFile;
    }

    public static URL getNestedJarFileUrl(URL aJarUrl, File aToDir) throws IOException {
        if (aJarUrl.getProtocol().equals(Scheme.FILE.getName())) {
            return aJarUrl;
        }
        if (!aJarUrl.getProtocol().equals(Scheme.JAR.getName())) {
            return null;
        }
        String theJarPath = new CsvBuilder().withCsvEscapeMode(CsvEscapeMode.ESCAPED).withFields(FileUtility.toJarHierarchy(aJarUrl)).withDelimiter(Delimiter.SYSTEM_FILE_PATH.getChar()).toRecord();
        File theJarDir = new File(aToDir, theJarPath);
        if (!theJarDir.exists()) {
            return null;
        }
        JarURLConnection theJarConnection = (JarURLConnection)aJarUrl.openConnection();
        String theEntyName = theJarConnection.getEntryName();
        File theEntryFile = new File(theJarDir, theEntyName);
        if (!theEntryFile.exists()) {
            return null;
        }
        return theEntryFile.toURI().toURL();
    }

    public static InputStream getResourceAsStream(Class<?> aClass, String aPath) {
        InputStream theInputStream = aClass.getResourceAsStream(aPath);
        if (theInputStream == null) {
            theInputStream = Thread.currentThread().getContextClassLoader().getResourceAsStream(aPath);
        }
        if (theInputStream == null) {
            theInputStream = aClass.getClassLoader().getResourceAsStream(aPath);
        }
        return theInputStream;
    }

    public static String[] toJarHierarchy(URL aJarUrl) {
        if (!aJarUrl.getProtocol().equals(Scheme.JAR.getName())) {
            return null;
        }
        ArrayList<String> theList = new ArrayList<String>();
        try {
            String theJarPath = URLDecoder.decode(aJarUrl.getFile(), Encoding.UTF_8.getCode());
            int i = Scheme.JAR.firstMarkerIndex(theJarPath);
            while (i != -1) {
                String eJarFile = theJarPath.substring(0, i);
                int j = eJarFile.lastIndexOf(47);
                if (j != -1) {
                    eJarFile = eJarFile.substring(j + 1);
                }
                theList.add(eJarFile);
                theJarPath = theJarPath.substring(i);
                i = Scheme.JAR.firstMarkerIndex(theJarPath);
            }
            return theList.toArray(new String[theList.size()]);
        }
        catch (UnsupportedEncodingException e) {
            return null;
        }
    }

    public static URL toNestedJarFileUrl(URL aJarUrl, File aToDir) throws IOException {
        URL theUrl = FileUtility.getNestedJarFileUrl(aJarUrl, aToDir);
        return theUrl != null ? theUrl : FileUtility.createNestedJarFileUrl(aJarUrl, aToDir);
    }

    public static URL toParentJarUrl() {
        URL theUrl = FileUtility.class.getProtectionDomain().getCodeSource().getLocation();
        if (!theUrl.getProtocol().equals(Scheme.JAR.getName())) {
            return null;
        }
        try {
            String theJarPath = URLDecoder.decode(theUrl.getFile(), Encoding.UTF_8.getCode());
            theJarPath = Scheme.JAR.toUrl(theJarPath);
            return FileUtility.toURL(theJarPath);
        }
        catch (UnsupportedEncodingException | MalformedURLException e) {
            return null;
        }
    }

    public static String toTempBaseFileName() {
        return "temp-" + System.currentTimeMillis() + "-" + RandomTextGenerartor.asString(8, RandomTextMode.LOWER_CASE_ALPHANUMERIC);
    }

    public static String toTempFileName() {
        return FileUtility.toTempBaseFileName() + FilenameExtension.TEMP.getFilenameSuffix();
    }

    private static URL toURL(String aStr) throws MalformedURLException {
        try {
            return URI.create(aStr).toURL();
        }
        catch (IllegalArgumentException e) {
            throw new MalformedURLException(e.getMessage());
        }
    }
}

