/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.io;

import java.io.IOException;
import java.util.ArrayList;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.refcodes.component.AbstractConnectable;
import org.refcodes.controlflow.RetryCounter;
import org.refcodes.data.IoRetryCount;
import org.refcodes.data.SleepLoopTime;
import org.refcodes.io.BytesDestination;

public abstract class AbstractBytesDestination
extends AbstractConnectable
implements BytesDestination {
    private static final Logger LOGGER = Logger.getLogger(AbstractBytesDestination.class.getName());
    public static final int DATAGRAM_QUEUE_SIZE = 1024;
    protected LinkedBlockingQueue<Byte> _datagramQueue;

    public AbstractBytesDestination() {
        this._datagramQueue = new LinkedBlockingQueue(1024);
    }

    public AbstractBytesDestination(int aCapacity) {
        this._datagramQueue = aCapacity == 0 ? new LinkedBlockingQueue() : new LinkedBlockingQueue(aCapacity);
    }

    @Override
    public byte receiveByte() throws IOException {
        try {
            return this._datagramQueue.take();
        }
        catch (InterruptedException e) {
            throw new IOException("Cannot receive data as of unexpected interruption!", e);
        }
    }

    @Override
    public byte[] receiveAllBytes() throws IOException {
        ArrayList theBytes = new ArrayList();
        this._datagramQueue.drainTo(theBytes);
        byte[] theDatagrams = new byte[theBytes.size()];
        for (int i = 0; i < theDatagrams.length; ++i) {
            theDatagrams[i] = (Byte)theBytes.get(i);
        }
        return theDatagrams;
    }

    @Override
    public byte[] receiveBytes(int aLength) throws IOException {
        ArrayList theBytes = new ArrayList();
        this._datagramQueue.drainTo(theBytes, aLength);
        byte[] theDatagrams = new byte[theBytes.size()];
        for (int i = 0; i < theDatagrams.length; ++i) {
            theDatagrams[i] = (Byte)theBytes.get(i);
        }
        return theDatagrams;
    }

    protected void pushDatagram(byte aDatagram) throws IOException {
        RetryCounter theRetryCounter = new RetryCounter(IoRetryCount.MAX.getValue());
        try {
            while (!this._datagramQueue.offer(aDatagram, SleepLoopTime.MAX.getTimeMillis(), TimeUnit.MILLISECONDS) && theRetryCounter.nextRetry()) {
                LOGGER.log(Level.WARNING, "Trying to offer (add) a datagram to the datagram queue, though the queue is full, this is retry # <" + theRetryCounter.getRetryCount() + ">, aborting after <" + theRetryCounter.getRetryNumber() + "> retries. Retrying now after a delay of <" + SleepLoopTime.MAX.getTimeMillis() / 1000 + "> seconds...");
                if (theRetryCounter.hasNextRetry()) continue;
                throw new IOException("Unable to process the datagram after <" + theRetryCounter.getRetryNumber() + "> retries, aborting retries, dismissing datagram \"" + aDatagram + "\"!");
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    protected void pushDatagrams(byte[] aDatagrams) throws IOException {
        for (byte eData : aDatagrams) {
            this.pushDatagram(eData);
        }
    }

    protected void pushDatagrams(byte[] aDatagrams, int aOffset, int aLength) throws IOException {
        for (int i = aOffset; i < aOffset + aLength; ++i) {
            this.pushDatagram(aDatagrams[i]);
        }
    }
}

