/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.internal;

public class IdentifierUtility {
    public static final char[] REGEX_SPECIAL_CHARS = new char[]{'.', '^', '$', '*', '+', '?', '(', ')', '[', '{', '\\', '|'};

    private IdentifierUtility() {
    }

    public static String toNormalized(String aText, char aSeparator) {
        if (aText == null || aText.isEmpty()) {
            return null;
        }
        String theRegexSeparator = IdentifierUtility.isRegexChar(aSeparator) ? "\\" + aSeparator : "" + aSeparator;
        String theRegexDoubleSeparator = theRegexSeparator + theRegexSeparator;
        String theDoubleSeparator = "" + aSeparator + aSeparator;
        String theSeparator = "" + aSeparator;
        StringBuilder theBuffer = new StringBuilder();
        while (aText.length() > 0 && !Character.isAlphabetic(aText.charAt(0)) && !Character.isDigit(aText.charAt(0))) {
            aText = aText.substring(1);
        }
        while (aText.length() > 0 && !Character.isAlphabetic(aText.charAt(aText.length() - 1)) && !Character.isDigit(aText.charAt(aText.length() - 1))) {
            aText = aText.substring(0, aText.length() - 1);
        }
        if (aText.isEmpty()) {
            return null;
        }
        theBuffer.append(aText.charAt(0));
        for (int i = 1; i < aText.length(); ++i) {
            if (Character.isLowerCase(aText.charAt(i - 1)) && Character.isUpperCase(aText.charAt(i))) {
                theBuffer.append(aSeparator);
            }
            if (!Character.isAlphabetic(aText.charAt(i)) && !Character.isDigit(aText.charAt(i))) {
                theBuffer.append(aSeparator);
                continue;
            }
            if (Character.isDigit(aText.charAt(i)) && theBuffer.length() != 0 && Character.isAlphabetic(theBuffer.charAt(theBuffer.length() - 1))) {
                theBuffer.append(aSeparator);
            } else if (Character.isAlphabetic(aText.charAt(i)) && theBuffer.length() != 0 && Character.isDigit(theBuffer.charAt(theBuffer.length() - 1))) {
                theBuffer.append(aSeparator);
            }
            theBuffer.append(aText.charAt(i));
        }
        String theNormalized = theBuffer.toString();
        while (theNormalized.contains(theDoubleSeparator)) {
            theNormalized = theNormalized.replaceAll(theRegexDoubleSeparator, theSeparator);
        }
        return theNormalized.toLowerCase();
    }

    private static boolean isRegexChar(char aChar) {
        for (char eChar : REGEX_SPECIAL_CHARS) {
            if (eChar != aChar) continue;
            return true;
        }
        return false;
    }
}

