/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.graphical;

import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import javax.imageio.ImageIO;
import org.refcodes.graphical.RgbPixel;
import org.refcodes.graphical.RgbPixelImpl;
import org.refcodes.graphical.RgbPixmap;

public class RgbPixmapImpl
implements RgbPixmap {
    protected RgbPixel[][] _pixels = null;

    public RgbPixmapImpl() {
    }

    public RgbPixmapImpl(RgbPixel[][] aPixels) {
        this._pixels = aPixels;
    }

    public RgbPixmapImpl(int aWidth, int aHeight) {
        this._pixels = new RgbPixel[aWidth][aHeight];
    }

    public RgbPixmapImpl(BufferedImage aImage) {
        this(aImage, -1, -1);
    }

    public RgbPixmapImpl(URL aImageUrl) throws IOException {
        this(aImageUrl, -1, -1);
    }

    public RgbPixmapImpl(File aImageFile) throws IOException {
        this(aImageFile, -1, -1);
    }

    public RgbPixmapImpl(InputStream aImageInputStream) throws IOException {
        this(aImageInputStream, -1, -1);
    }

    public RgbPixmapImpl(URL aImageUrl, int aWidth, int aHeight) throws IOException {
        this(ImageIO.read(aImageUrl), aWidth, aHeight);
    }

    public RgbPixmapImpl(File aImageFile, int aWidth, int aHeight) throws IOException {
        this(new FileInputStream(aImageFile), aWidth, aHeight);
    }

    public RgbPixmapImpl(InputStream aImageInputStream, int aWidth, int aHeight) throws IOException {
        this(ImageIO.read(aImageInputStream), aWidth, aHeight);
    }

    public RgbPixmapImpl(BufferedImage aImage, int aWidth, int aHeight) {
        int theToWidth = aWidth;
        int theToHeight = aHeight;
        int theFromWidth = aImage.getWidth();
        int theFromHeight = aImage.getHeight();
        if (theToWidth == -1 && theToHeight != -1) {
            theToWidth = (int)((float)theFromWidth / (float)theFromHeight * (float)theToHeight);
        }
        if (theToWidth != -1 && theToHeight == -1) {
            theToHeight = (int)((float)theToWidth / (float)theFromWidth * (float)theFromHeight);
        }
        if (theToWidth == -1 && theToHeight == -1) {
            theToWidth = theFromWidth;
            theToHeight = theFromHeight;
        }
        BufferedImage theScaled = new BufferedImage(theToWidth, theToHeight, aImage.getType());
        AffineTransform theTransform = new AffineTransform();
        theTransform.scale(theToWidth, theToHeight);
        AffineTransformOp theScaleOperation = new AffineTransformOp(theTransform, 2);
        theScaled = theScaleOperation.filter(aImage, theScaled);
        this._pixels = new RgbPixel[theToWidth][theToHeight];
        for (int x = 0; x < theToWidth; ++x) {
            for (int y = 0; y < theToHeight; ++y) {
                this._pixels[x][y] = new RgbPixelImpl(aImage.getRGB(x, y));
            }
        }
    }

    public RgbPixel[][] getPixels() {
        return this._pixels;
    }

    @Override
    public int getWidth() {
        return this._pixels.length;
    }

    @Override
    public int getHeight() {
        return this._pixels[0].length;
    }

    @Override
    public RgbPixel getPixelAt(int aPosX, int aPosY) {
        return this._pixels[aPosX][aPosY];
    }
}

