/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.generator;

import java.text.ParseException;
import org.refcodes.generator.AlphabetCounter;
import org.refcodes.generator.AlphabetCounterMetrics;
import org.refcodes.generator.Counter;
import org.refcodes.generator.IdCounter;
import org.refcodes.generator.IdCounterComposite;

public class AlphabetCounterComposite
extends IdCounterComposite {
    public AlphabetCounterComposite(String ... aAlphabetExpressions) throws ParseException {
        super(AlphabetCounterComposite.toAlphabetCounters(aAlphabetExpressions));
    }

    public AlphabetCounterComposite(AlphabetCounterMetrics ... aAlphabetCounterMetrics) {
        super(AlphabetCounterComposite.toAlphabetCounters(aAlphabetCounterMetrics));
    }

    public AlphabetCounterComposite(AlphabetCounter ... aAlphabetCounter) {
        super(aAlphabetCounter);
    }

    public String[] nextCounters() {
        return (String[])super.nextCounters();
    }

    @Override
    public AlphabetCounter[] getChildren() {
        Counter<T>[] theCounters = super.getChildren();
        AlphabetCounter[] theAlphabetCounters = new AlphabetCounter[theCounters.length];
        for (int i = 0; i < theAlphabetCounters.length; ++i) {
            theAlphabetCounters[i] = (AlphabetCounter)theCounters[i];
        }
        return theAlphabetCounters;
    }

    public String[] toAlphabetExpressions() {
        AlphabetCounter[] theCounters = this.getChildren();
        String[] theExpressions = new String[theCounters.length];
        for (int i = 0; i < theExpressions.length; ++i) {
            theExpressions[i] = theCounters[i].toAlphabetExpression();
        }
        return theExpressions;
    }

    public String toString() {
        AlphabetCounter[] theCounters;
        Object theResult = "";
        for (AlphabetCounter eCounter : theCounters = this.getChildren()) {
            theResult = (String)theResult + eCounter.toString();
        }
        return theResult;
    }

    private static IdCounter[] toAlphabetCounters(String[] aAlphabetExpressions) throws ParseException {
        IdCounter[] theCounters = new IdCounter[aAlphabetExpressions.length];
        for (int i = 0; i < aAlphabetExpressions.length; ++i) {
            theCounters[i] = new AlphabetCounter(new AlphabetCounterMetrics(aAlphabetExpressions[i]));
        }
        return theCounters;
    }

    private static IdCounter[] toAlphabetCounters(AlphabetCounterMetrics ... aAlphabetCounterMetrics) {
        IdCounter[] theCounters = new IdCounter[aAlphabetCounterMetrics.length];
        for (int i = 0; i < aAlphabetCounterMetrics.length; ++i) {
            theCounters[i] = new AlphabetCounter(aAlphabetCounterMetrics[i]);
        }
        return theCounters;
    }
}

