/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.factory;

import org.refcodes.exception.UnmarshalException;

@FunctionalInterface
public interface UnmarshalFactory<MAR> {
    public <UN> UN toUnmarshaled(MAR var1, Class<UN> var2) throws UnmarshalException;

    default public Object toUnmarshaled(MAR aMarshaled, Class<?> ... aTypes) throws UnmarshalException {
        for (Class<?> eType : aTypes) {
            try {
                return this.toUnmarshaled(aMarshaled, (Class)eType);
            }
            catch (UnmarshalException unmarshalException) {
            }
        }
        throw new UnmarshalException("Unable to unmarshal the context of type <" + aMarshaled.getClass().getName() + "> to fit into one of the provided types!");
    }

    public static interface UnmarshalFactoryComposite<MAR, COMP>
    extends UnmarshalFactory<MAR>,
    UnmarshalFactoryComplement<COMP> {

        public static interface ConfigurableUnmarshalFactoryComposite<MAR, COMP, OPTS>
        extends UnmarshalFactoryComposite<MAR, COMP>,
        ConfigurableUnmarshalFactory<MAR, OPTS>,
        UnmarshalFactoryComplement.ConfigurableUnmarshalFactoryComplement<COMP, OPTS> {
        }
    }

    public static interface UnmarshalFactoryComplement<COMP> {
        public <UN> UN fromMarshaled(COMP var1, Class<UN> var2) throws UnmarshalException;

        public Object fromMarshaled(COMP var1, Class<?> ... var2) throws UnmarshalException;

        public static interface ConfigurableUnmarshalFactoryComplement<COMP, OPTS>
        extends UnmarshalFactoryComplement<COMP> {
            public <UN> UN fromMarshaled(COMP var1, Class<UN> var2, OPTS var3) throws UnmarshalException;

            public Object fromMarshaled(COMP var1, OPTS var2, Class<?> ... var3) throws UnmarshalException;
        }
    }

    @FunctionalInterface
    public static interface ConfigurableUnmarshalFactory<MAR, OPTS>
    extends UnmarshalFactory<MAR> {
        @Override
        default public <UN> UN toUnmarshaled(MAR aMarshaled, Class<UN> aType) throws UnmarshalException {
            return this.toUnmarshaled(aMarshaled, aType, (OPTS)null);
        }

        public <UN> UN toUnmarshaled(MAR var1, Class<UN> var2, OPTS var3) throws UnmarshalException;

        default public Object toUnmarshaled(MAR aMarshaled, OPTS aOptions, Class<?> ... aTypes) throws UnmarshalException {
            for (Class<?> eType : aTypes) {
                try {
                    return this.toUnmarshaled(aMarshaled, eType, aOptions);
                }
                catch (UnmarshalException unmarshalException) {
                }
            }
            throw new UnmarshalException("Unable to unmarshal the context of type <" + aMarshaled.getClass().getName() + "> to fit into one of the provided types!");
        }
    }
}

