/*
 * Decompiled with CFR 0.152.
 */
package club.funcodes.autochat.service;

import club.funcodes.autochat.service.ClientStateElizaResponse;
import club.funcodes.autochat.service.ElizaDecorator;
import club.funcodes.autochat.service.ElizaService;
import club.funcodes.autochat.service.ElizaState;
import club.funcodes.autochat.service.ServerSessionElizaResponse;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

public class InMemoryElizaService
implements ElizaService,
AutoCloseable {
    private Map<String, ElizaState> _sessions = new HashMap<String, ElizaState>();
    private ScheduledExecutorService _scheduler = Executors.newSingleThreadScheduledExecutor();

    public InMemoryElizaService() {
        this._scheduler.scheduleAtFixedRate(this::doSessionCleanup, 10L, 10L, TimeUnit.MINUTES);
    }

    @Override
    public ServerSessionElizaResponse createConversationSession(List<Locale> aLocales, String aMessage) {
        return this.createConversationSession(aLocales, UUID.randomUUID().toString(), aMessage);
    }

    @Override
    public ServerSessionElizaResponse continueConversationForSession(String aSessionId, String aMessage) {
        String theOutput = this.onMessageHook(aMessage);
        if (theOutput == null) {
            ElizaState theState = this._sessions.get(aSessionId);
            ElizaDecorator theEliza = new ElizaDecorator(theState);
            theOutput = theEliza.processInput(aMessage);
            this._sessions.put(aSessionId, theEliza.toState());
        }
        return new ServerSessionElizaResponse(theOutput, aSessionId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasConversationSession(String aSessionId) {
        Map<String, ElizaState> map = this._sessions;
        synchronized (map) {
            return this._sessions.containsKey(aSessionId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ServerSessionElizaResponse createConversationSession(List<Locale> aLocales, String aSessionId, String aMessage) {
        Map<String, ElizaState> map = this._sessions;
        synchronized (map) {
            if (this.hasConversationSession(aSessionId)) {
                throw new IllegalStateException("The provided session with ID <" + aSessionId + "> is already in use.");
            }
            ElizaDecorator theEliza = new ElizaDecorator(aLocales);
            String theOutput = this.onMessageHook(aMessage);
            if (theOutput == null) {
                theOutput = theEliza.processInput(aMessage);
            }
            ClientStateElizaResponse theResponse = new ClientStateElizaResponse(theOutput, theEliza.toState());
            this._sessions.put(aSessionId, theResponse.getState());
            return new ServerSessionElizaResponse(theResponse.getAnswer(), aSessionId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void doSessionCleanup() {
        Map<String, ElizaState> map = this._sessions;
        synchronized (map) {
            HashSet<String> theKeys = new HashSet<String>(this._sessions.keySet());
            for (String eKey : theKeys) {
                ElizaState eState = this._sessions.get(eKey);
                if (eState == null || !eState.isExpired()) continue;
                this._sessions.remove(eKey);
            }
        }
    }

    @Override
    public void close() throws Exception {
        this._scheduler.shutdownNow();
    }
}

