/*
 * Decompiled with CFR 0.152.
 */
package club.funcodes.autochat.service;

public class ElizaState {
    private static final int MIN_SESSION_EXPIRATION_TIME_MILLIS = 604800000;
    private String _stateData;
    private long _lastUpdateTime;

    public ElizaState() {
        this._lastUpdateTime = System.currentTimeMillis();
    }

    public ElizaState(String aStateBlob) {
        this._stateData = aStateBlob;
        this._lastUpdateTime = System.currentTimeMillis();
    }

    public ElizaState(String aStateBlob, long aLastUpdateTime) {
        this._stateData = aStateBlob;
        this._lastUpdateTime = aLastUpdateTime;
    }

    public String getStateData() {
        return this._stateData;
    }

    public void setStateData(String aStateData) {
        this._stateData = aStateData;
        this._lastUpdateTime = System.currentTimeMillis();
    }

    public boolean isExpired() {
        return this._lastUpdateTime + 604800000L < System.currentTimeMillis();
    }

    public long getLastUpdateTime() {
        return this._lastUpdateTime;
    }

    public void setLastUpdateTime(long aLastUpdateTime) {
        this._lastUpdateTime = aLastUpdateTime;
    }

    public String toString() {
        String theStateText = this._stateData.length() > 23 ? this._stateData.substring(0, 20) + "..." : this._stateData;
        return "ElizaState [_stateData=" + theStateText + ", expired=" + this.isExpired() + ", lastUpdateTime=" + this._lastUpdateTime + "]";
    }
}

