/*
 * Decompiled with CFR 0.152.
 */
package club.funcodes.autochat.eliza;

import club.funcodes.autochat.eliza.Decomp;
import club.funcodes.autochat.eliza.DecompList;
import club.funcodes.autochat.eliza.EString;
import club.funcodes.autochat.eliza.Key;
import club.funcodes.autochat.eliza.KeyList;
import club.funcodes.autochat.eliza.KeyStack;
import club.funcodes.autochat.eliza.Mem;
import club.funcodes.autochat.eliza.PrePostList;
import club.funcodes.autochat.eliza.ReasembList;
import club.funcodes.autochat.eliza.SynList;
import club.funcodes.autochat.eliza.WordList;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;

public class Eliza {
    static final String DEFAULT_ELIZA_SCRIPT = "eliza.script";
    private boolean _finished = false;
    private String _finl = "Goodbye.";
    private String _initial = "Hello.";
    private KeyList _keys = new KeyList();
    private KeyStack _keyStack = new KeyStack();
    private DecompList _lastDecomp;
    private ReasembList _lastReasemb;
    private Mem _mem = new Mem();
    private PrePostList _post = new PrePostList();
    private PrePostList _pre = new PrePostList();
    private final boolean _printInitialFinal = false;
    private final boolean _printKeys = false;
    private final boolean _printPrePost = false;
    private final boolean _printSyns = false;
    private WordList _quit = new WordList();
    private SynList _syns = new SynList();

    protected Eliza() {
    }

    public Eliza(String aScriptName) {
        try {
            if (!this.readScript(aScriptName)) {
                throw new IllegalArgumentException("Cannot read any content from script <" + aScriptName + ">!");
            }
        }
        catch (IOException e) {
            new IllegalArgumentException("Cannot read script <" + aScriptName + ">!", e);
        }
    }

    public void collect(String aLine) {
        String[] lines = new String[4];
        if (EString.match(aLine, "*reasmb: *", lines)) {
            if (this._lastReasemb == null) {
                System.out.println("Error: no last reasemb");
                return;
            }
            this._lastReasemb.add(lines[1]);
        } else if (EString.match(aLine, "*decomp: *", lines)) {
            if (this._lastDecomp == null) {
                System.out.println("Error: no last decomp");
                return;
            }
            this._lastReasemb = new ReasembList();
            String temp = new String(lines[1]);
            if (EString.match(temp, "$ *", lines)) {
                this._lastDecomp.add(lines[0], true, this._lastReasemb);
            } else {
                this._lastDecomp.add(temp, false, this._lastReasemb);
            }
        } else if (EString.match(aLine, "*key: * #*", lines)) {
            this._lastDecomp = new DecompList();
            this._lastReasemb = null;
            int n = 0;
            if (lines[2].length() != 0) {
                try {
                    n = Integer.parseInt(lines[2]);
                }
                catch (NumberFormatException e) {
                    System.out.println("Number is wrong in key: " + lines[2]);
                }
            }
            this._keys.add(lines[1], n, this._lastDecomp);
        } else if (EString.match(aLine, "*key: *", lines)) {
            this._lastDecomp = new DecompList();
            this._lastReasemb = null;
            this._keys.add(lines[1], 0, this._lastDecomp);
        } else if (EString.match(aLine, "*synon: * *", lines)) {
            WordList words = new WordList();
            words.add(lines[1]);
            aLine = lines[2];
            while (EString.match(aLine, "* *", lines)) {
                words.add(lines[0]);
                aLine = lines[1];
            }
            words.add(aLine);
            this._syns.add(words);
        } else if (EString.match(aLine, "*pre: * *", lines)) {
            this._pre.add(lines[1], lines[2]);
        } else if (EString.match(aLine, "*post: * *", lines)) {
            this._post.add(lines[1], lines[2]);
        } else if (EString.match(aLine, "*initial: *", lines)) {
            this._initial = lines[1];
        } else if (EString.match(aLine, "*final: *", lines)) {
            this._finl = lines[1];
        } else if (EString.match(aLine, "*quit: *", lines)) {
            this._quit.add(" " + lines[1] + " ");
        } else {
            System.out.println("Unrecognized input: " + aLine);
        }
    }

    public boolean finished() {
        return this._finished;
    }

    public boolean parseScript(String aScript) throws IOException {
        this.clearScript();
        String[] lines = aScript.split("\\r?\\n");
        if (lines == null || lines.length == 0) {
            System.err.println("Cannot parse Eliza script!");
            return false;
        }
        for (int i = 0; i < lines.length; ++i) {
            this.collect(lines[i]);
        }
        return true;
    }

    public void print() {
    }

    public String processInput(String aLine) {
        Key dummy;
        String reply;
        aLine = EString.translate(aLine, "ABCDEFGHIJKLMNOPQRSTUVWXYZ\u00c4\u00d6\u00dc", "abcdefghijklmnopqrstuvwxyz\u00e4\u00f6\u00fc");
        aLine = EString.translate(aLine, "@#$%^&*()_-+=~`{[}]|:;<>\\\"", "                          ");
        aLine = EString.translate(aLine, ",?!", "...");
        aLine = EString.compress(aLine);
        String[] lines = new String[2];
        while (EString.match(aLine, "*.*", lines)) {
            reply = this.sentence(lines[0]);
            if (reply != null) {
                return reply.replaceAll("  ", " ").replaceAll(" ,", ",");
            }
            aLine = EString.trim(lines[1]);
        }
        if (aLine.length() != 0 && (reply = this.sentence(aLine)) != null) {
            return reply.replaceAll("  ", " ").replaceAll(" ,", ",");
        }
        String m = this._mem.get();
        if (m != null) {
            return m;
        }
        Key key = this._keys.getKey("xnone");
        if (key != null && (reply = this.decompose(key, aLine, dummy = null)) != null) {
            return reply.replaceAll("  ", " ").replaceAll(" ,", ",");
        }
        return "I am at a loss for words.";
    }

    public boolean readDefaultScript() {
        this.clearScript();
        try {
            return this.readScript(DEFAULT_ELIZA_SCRIPT);
        }
        catch (IOException e) {
            throw new RuntimeException("Cannot read default script <eliza.script>!", e);
        }
    }

    public boolean readScript(String aScriptName) throws IOException {
        this.clearScript();
        String[] script = Eliza.readLines(aScriptName);
        if (script == null || script.length == 0) {
            System.err.println("Cannot load Eliza script!");
            return false;
        }
        this.initScript(script);
        return true;
    }

    protected void initScript(String[] aScript) {
        for (int i = 0; i < aScript.length; ++i) {
            this.collect(aScript[i]);
        }
    }

    protected static String[] readLines(String aFileName) throws IOException {
        File file = new File(aFileName);
        InputStream resourceAsStream = Eliza.class.getClassLoader().getResourceAsStream(aFileName);
        try (BufferedReader reader = file.exists() && file.isFile() ? new BufferedReader(new FileReader(file)) : new BufferedReader(new InputStreamReader(resourceAsStream, StandardCharsets.UTF_8));){
            String line;
            ArrayList<String> list = new ArrayList<String>();
            while ((line = reader.readLine()) != null) {
                list.add(line);
            }
            String[] stringArray = list.toArray(new String[list.size()]);
            return stringArray;
        }
    }

    private String assemble(Decomp aDecompRule, String[] aReply, Key aGotoKey) {
        String[] lines = new String[3];
        aDecompRule.stepRule();
        String rule = aDecompRule.nextRule();
        if (EString.match(rule, "goto *", lines)) {
            aGotoKey.copy(this._keys.getKey(lines[0]));
            if (aGotoKey.getKey() != null) {
                return null;
            }
            System.out.println("Goto rule did not match key: " + lines[0]);
            return null;
        }
        Object work = "";
        while (EString.match(rule, "* (#)*", lines)) {
            rule = lines[2];
            int n = 0;
            try {
                n = Integer.parseInt(lines[1]) - 1;
            }
            catch (NumberFormatException e) {
                System.out.println("Number is wrong in reassembly rule " + lines[1]);
            }
            if (n < 0 || n >= aReply.length) {
                System.out.println("Substitution number is bad " + lines[1]);
                return null;
            }
            aReply[n] = this._post.translate(aReply[n]);
            work = (String)work + lines[0] + " " + aReply[n];
        }
        work = (String)work + rule;
        if (aDecompRule.mem()) {
            this._mem.save((String)work);
            return null;
        }
        return work;
    }

    private void clearScript() {
        this._keys.clear();
        this._syns.clear();
        this._pre.clear();
        this._post.clear();
        this._initial = "";
        this._finl = "";
        this._quit.clear();
        this._keyStack.reset();
    }

    private String decompose(Key aKey, String aSentence, Key aGotoKey) {
        String[] reply = new String[10];
        for (int i = 0; i < aKey.decomp().size(); ++i) {
            Decomp d = (Decomp)aKey.decomp().elementAt(i);
            String pat = d.pattern();
            if (!this._syns.matchDecomp(aSentence, pat, reply)) continue;
            String rep = this.assemble(d, reply, aGotoKey);
            if (rep != null) {
                return rep;
            }
            if (aGotoKey.getKey() == null) continue;
            return null;
        }
        return null;
    }

    private String sentence(String aSentence) {
        aSentence = this._pre.translate(aSentence);
        if (this._quit.find(aSentence = EString.pad(aSentence))) {
            this._finished = true;
            return this._finl;
        }
        this._keys.buildKeyStack(this._keyStack, aSentence);
        for (int i = 0; i < this._keyStack.keyTop(); ++i) {
            Key gotoKey = new Key();
            String reply = this.decompose(this._keyStack.key(i), aSentence, gotoKey);
            if (reply != null) {
                return reply;
            }
            while (gotoKey.getKey() != null) {
                reply = this.decompose(gotoKey, aSentence, gotoKey);
                if (reply == null) continue;
                return reply;
            }
        }
        return null;
    }
}

