/*
 * Decompiled with CFR 0.152.
 */
package club.funcodes.autochat;

import club.funcodes.autochat.Language;
import club.funcodes.autochat.eliza.Eliza;
import club.funcodes.autochat.service.ClientStateElizaRequest;
import club.funcodes.autochat.service.ClientStateElizaResponse;
import club.funcodes.autochat.service.ElizaRequest;
import club.funcodes.autochat.service.ElizaService;
import club.funcodes.autochat.service.InMemoryElizaService;
import club.funcodes.autochat.service.ServerSessionElizaResponse;
import club.funcodes.autochat.teams.TeamsConversationRequest;
import club.funcodes.autochat.teams.TeamsConversationResponse;
import java.io.Console;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Locale;
import org.refcodes.archetype.CliHelper;
import org.refcodes.cli.CasesCondition;
import org.refcodes.cli.CliSugar;
import org.refcodes.cli.ConfigOption;
import org.refcodes.cli.DebugFlag;
import org.refcodes.cli.EnumOption;
import org.refcodes.cli.Example;
import org.refcodes.cli.Flag;
import org.refcodes.cli.HelpFlag;
import org.refcodes.cli.InitFlag;
import org.refcodes.cli.IntOption;
import org.refcodes.cli.NoneOperand;
import org.refcodes.cli.QuietFlag;
import org.refcodes.cli.StringOption;
import org.refcodes.cli.SysInfoFlag;
import org.refcodes.data.AnsiEscapeCode;
import org.refcodes.data.AsciiColorPalette;
import org.refcodes.exception.Trap;
import org.refcodes.logger.RuntimeLogger;
import org.refcodes.logger.RuntimeLoggerFactorySingleton;
import org.refcodes.properties.ImmutableProperties;
import org.refcodes.properties.ext.application.ApplicationProperties;
import org.refcodes.rest.HttpRestServer;
import org.refcodes.rest.JdkHttpRestServer;
import org.refcodes.rest.RestRequestEvent;
import org.refcodes.runtime.Terminal;
import org.refcodes.textual.Font;
import org.refcodes.textual.FontFamily;
import org.refcodes.textual.FontStyle;
import org.refcodes.textual.HorizAlignTextBuilder;
import org.refcodes.textual.HorizAlignTextMode;
import org.refcodes.textual.VerboseTextBuilder;
import org.refcodes.web.HttpServerResponse;
import org.refcodes.web.HttpStatusCode;

public class Main {
    private static final RuntimeLogger LOGGER = RuntimeLoggerFactorySingleton.createRuntimeLogger();
    private static final String NAME = "autochat";
    private static final String TITLE = ">" + "autochat".toUpperCase() + "!";
    private static final String DEFAULT_CONFIG = "autochat.ini";
    private static final String DESCRIPTION = "ELIZA chatbot (by Joseph Weizenbaum) talking to you via RESTful services and an MS-Teams endpoint or on the console (see [https://www.metacodes.pro/manpages/autochat_manpage]).";
    private static final String COPYRIGHT = "Copyright (c) by CLUB.FUNCODES | See [https://www.metacodes.pro/manpages/autochat_manpage]";
    private static final String LICENSE_NOTE = "You may choose between the LGPL v3.0 or later and the Apache License v2.0 when using this software";
    private static final char[] BANNER_PALETTE = AsciiColorPalette.MAX_LEVEL_GRAY.getPalette();
    private static final Font BANNER_FONT = new Font(FontFamily.DIALOG, FontStyle.BOLD);
    private static final int DEFAULT_PORT = 8080;
    private static final String DEFAULT_BASE_PATH = "/autochat";
    private static final String PROMPT = "$>";
    private static final String ELIZA = "ELIZA";
    private static final String PORT_PROPERTY = "port";
    private static final String BASE_PATH_PROPERTY = "basePath";
    private static final String INTERACTIVE_PROPERTY = "interactive";
    private static final String LANGUAGE_PROPERTY = "language";
    private ElizaService _service;
    private HttpRestServer _server;
    private boolean _isQuiet;
    private int _port;
    private String _basePath;
    private Language _language;
    private boolean _isInteractive;

    public static void main(String[] args) {
        NoneOperand theNoneArg = CliSugar.none("Starts with the default configuration.");
        StringOption theBasePathArg = CliSugar.stringOption(Character.valueOf('b'), "base-path", BASE_PATH_PROPERTY, "The base path on which the RESTful server is serving HTTP requests (defaults to \"/\").");
        IntOption thePortArg = CliSugar.intOption(Character.valueOf('p'), PORT_PROPERTY, PORT_PROPERTY, "The TCP port to be used for the HTTP service.");
        EnumOption<Language> theLanguageArg = CliSugar.enumOption(Character.valueOf('l'), LANGUAGE_PROPERTY, Language.class, LANGUAGE_PROPERTY, "Use the according language <" + VerboseTextBuilder.asString((Object[])Language.values()) + "> for the interactive mode.");
        ConfigOption theConfigArg = CliSugar.configOption();
        InitFlag theInitFlag = CliSugar.initFlag(false);
        Flag theInteractiveFlag = CliSugar.flag(Character.valueOf('i'), INTERACTIVE_PROPERTY, INTERACTIVE_PROPERTY, "Start in interactive mode, making ELIZA chat with you on the console.");
        QuietFlag theQuietFlag = CliSugar.quietFlag();
        SysInfoFlag theSysInfoFlag = CliSugar.sysInfoFlag(false);
        HelpFlag theHelpFlag = CliSugar.helpFlag();
        DebugFlag theDebugFlag = CliSugar.debugFlag();
        CasesCondition theArgsSyntax = CliSugar.cases(CliSugar.xor(theNoneArg, CliSugar.any(thePortArg, theBasePathArg, theQuietFlag, theConfigArg, theDebugFlag)), CliSugar.and(theInteractiveFlag, CliSugar.optional(theLanguageArg, theQuietFlag, theDebugFlag)), CliSugar.and(theInitFlag, CliSugar.optional(theConfigArg, theQuietFlag)), CliSugar.xor(theHelpFlag, CliSugar.and(theSysInfoFlag, CliSugar.any(theQuietFlag))));
        Example[] theExamples = CliSugar.examples(CliSugar.example("Start server on another base path", theBasePathArg), CliSugar.example("Start server on another port and base path", thePortArg, theBasePathArg), CliSugar.example("Start server in quiet mode", theQuietFlag), CliSugar.example("Start server using given configuration", theConfigArg), CliSugar.example("Start in interactive (repl) mode", theInteractiveFlag), CliSugar.example("Start using language in interactive (repl) mode", theInteractiveFlag, theLanguageArg), CliSugar.example("Initialize default config file", theInitFlag), CliSugar.example("Initialize specific config file", theInitFlag, theConfigArg), CliSugar.example("To show the help text", theHelpFlag), CliSugar.example("To print the system info", theSysInfoFlag));
        CliHelper theCliHelper = ((CliHelper.Builder)((CliHelper.Builder)((CliHelper.Builder)((CliHelper.Builder)((CliHelper.Builder)((CliHelper.Builder)((CliHelper.Builder)((CliHelper.Builder)((CliHelper.Builder)((CliHelper.Builder)((CliHelper.Builder)((CliHelper.Builder)((CliHelper.Builder)CliHelper.builder().withArgs(args)).withArgsSyntax(theArgsSyntax)).withExamples(theExamples)).withFilePath(DEFAULT_CONFIG)).withResourceClass((Class)Main.class)).withName(NAME)).withTitle(TITLE)).withDescription(DESCRIPTION)).withLicense(LICENSE_NOTE)).withCopyright(COPYRIGHT)).withBannerFont(BANNER_FONT)).withBannerFontPalette(BANNER_PALETTE)).withLogger(LOGGER)).build();
        ApplicationProperties theArgsProperties = theCliHelper.getApplicationProperties();
        try {
            new Main(theArgsProperties).start();
        }
        catch (Throwable e) {
            theCliHelper.exitOnException(e);
        }
    }

    private void start() throws IOException {
        if (this._isInteractive) {
            this.startRepl();
        } else {
            this.startServer();
        }
    }

    public Main(ImmutableProperties aProperties) throws IOException {
        this(aProperties.getIntOr(PORT_PROPERTY, (Integer)8080), aProperties.getOr(BASE_PATH_PROPERTY, DEFAULT_BASE_PATH), aProperties.getBooleanOr(INTERACTIVE_PROPERTY, (Boolean)false), aProperties.getEnumOr(Language.class, LANGUAGE_PROPERTY, Language.toUserLanguage()), aProperties.getBoolean("quiet"));
    }

    public Main(int aPort, String aBasePath, boolean isInteractive, Language aLanguage, boolean isQuiet) throws IOException {
        this._basePath = aBasePath;
        this._port = aPort;
        this._isInteractive = isInteractive;
        this._language = aLanguage;
        this._isQuiet = isQuiet;
        if (!this._isQuiet) {
            LOGGER.info("Starting application <autochat> ...");
        }
        if (!this._isInteractive) {
            if (!this._isQuiet) {
                LOGGER.info("Initializing server on port <" + this._port + "> for base path \"" + this._basePath + "\"...");
            }
            this._service = new InMemoryElizaService();
            this._server = new JdkHttpRestServer();
            this.onCreateConversationSession(this._server, this._basePath);
            this.onContinueConversationForSession(this._server, this._basePath);
            this.onCreateConversationState(this._server, this._basePath);
            this.onContinueConversationForState(this._server, this._basePath);
            this.onTeamsConversation(this._server, this._basePath);
            this.onHttpException(this._server);
        }
    }

    public static Main createReadEvalPrintLoop(boolean isVerbose) throws IOException {
        return new Main(-1, null, true, Language.EN, isVerbose);
    }

    public static Main createReadEvalPrintLoop(Language aLanguage, boolean isVerbose) throws IOException {
        return new Main(-1, null, true, aLanguage, isVerbose);
    }

    public static Main createServer(int aPort, String aBasePath, boolean isVerbose) throws IOException {
        return new Main(aPort, aBasePath, false, null, isVerbose);
    }

    public static Main createServer(int aPort, boolean isVerbose) throws IOException {
        return new Main(aPort, DEFAULT_BASE_PATH, false, null, isVerbose);
    }

    public void startRepl() {
        Object eliza;
        Object you;
        if (!this._isQuiet) {
            LOGGER.info("Initializing REPL with language <" + this._language.getLanguageName().toUpperCase() + "> (\"" + this._language.name() + "\")...");
            LOGGER.info("Exit by entering one of the following:" + VerboseTextBuilder.asString(this._language.getExitKeywords()));
            LOGGER.printTail();
        }
        Eliza theEliza = new Eliza(this._language.getScriptName());
        Console theConsole = System.console();
        if (!this._isQuiet) {
            int max = this._language.you().length() > ELIZA.length() ? this._language.you().length() : ELIZA.length();
            you = HorizAlignTextBuilder.asAligned(this._language.you().toUpperCase(), max, HorizAlignTextMode.RIGHT);
            eliza = HorizAlignTextBuilder.asAligned(ELIZA, max, HorizAlignTextMode.RIGHT);
            Object prompt = " $> ";
            if (Terminal.isAnsiTerminalEnabled()) {
                you = AnsiEscapeCode.ITALIC.toEscapeSequence() + (String)you + AnsiEscapeCode.RESET.toEscapeSequence();
                eliza = AnsiEscapeCode.ITALIC.toEscapeSequence() + (String)eliza + AnsiEscapeCode.RESET.toEscapeSequence();
                prompt = AnsiEscapeCode.FAINT.toEscapeSequence() + (String)prompt + AnsiEscapeCode.RESET.toEscapeSequence();
            }
            you = (String)you + (String)prompt;
            eliza = (String)eliza + (String)prompt;
        } else {
            eliza = "ELIZA: ";
            you = this._language.you().toUpperCase() + ": ";
        }
        if (theConsole == null) {
            throw new IllegalStateException("No console found for running in interactive mode!");
        }
        String eMessage = null;
        do {
            System.out.print((String)eliza);
            if (eMessage != null) {
                System.out.println(theEliza.processInput(eMessage.trim()));
            } else {
                System.out.println(":-)");
            }
            System.out.print((String)you);
        } while (!this._language.isExitKeyword(eMessage = theConsole.readLine()));
        System.exit(0);
    }

    public void startServer() throws IOException {
        this._server.open(this._port);
        if (!this._isQuiet) {
            LOGGER.info("Server started on port <" + this._server.getPort() + "> ...");
        } else {
            System.out.println("Server started on port <" + this._server.getPort() + "> ...");
        }
    }

    public void stopServer() throws IOException {
        this._server.close();
        if (!this._isQuiet) {
            LOGGER.info("Server on port <" + this._server.getPort() + "> stopped!");
        } else {
            System.out.println("Server on port <" + this._server.getPort() + "> stopped!");
        }
    }

    private void onCreateConversationSession(HttpRestServer aServer, String aBasePath) throws IOException {
        aServer.onPut(aBasePath + "/sessions", (aRequest, aResponse) -> {
            ElizaRequest theElizaRequest = aRequest.getRequest(ElizaRequest.class);
            if (!this._isQuiet) {
                LOGGER.info("Received new conversation session request \"" + theElizaRequest.getMessage() + "\"...");
            }
            ServerSessionElizaResponse theBody = this._service.createConversationSession(aRequest.getHeaderFields().getAcceptLanguages(), theElizaRequest);
            aResponse.setResponse(theBody);
        }).withOpen();
    }

    private void onContinueConversationForSession(HttpRestServer aServer, String aBasePath) throws IOException {
        aServer.onPost(aBasePath + "/sessions/${sessionId}", (aRequest, aResponse) -> {
            String theSessionId = aRequest.getWildcardReplacement("sessionId");
            ElizaRequest theElizaRequest = aRequest.getRequest(ElizaRequest.class);
            if (!this._isQuiet) {
                LOGGER.info("Received continue conversation session request \"" + theElizaRequest.getMessage() + "\" for session <" + theSessionId + "> ...");
            }
            ServerSessionElizaResponse theBody = this._service.continueConversationForSession(theSessionId, theElizaRequest);
            aResponse.setResponse(theBody);
        }).withOpen();
    }

    private void onCreateConversationState(HttpRestServer aServer, String aBasePath) throws IOException {
        aServer.onPut(aBasePath, (aRequest, aResponse) -> {
            ElizaRequest theElizaRequest = aRequest.getRequest(ElizaRequest.class);
            if (!this._isQuiet) {
                LOGGER.info("Received create conversation state request \"" + theElizaRequest.getMessage() + "\"...");
            }
            ClientStateElizaResponse theBody = this._service.createConversationState(aRequest.getHeaderFields().getAcceptLanguages(), theElizaRequest);
            aResponse.setResponse(theBody);
        }).withOpen();
    }

    private void onContinueConversationForState(HttpRestServer aServer, String aBasePath) throws IOException {
        aServer.onPost(aBasePath, (aRequest, aResponse) -> {
            ClientStateElizaRequest theElizaRequest = aRequest.getRequest(ClientStateElizaRequest.class);
            if (!this._isQuiet) {
                LOGGER.info("Received continue conversation state request \"" + theElizaRequest.getMessage() + "\" for provided state...");
            }
            ClientStateElizaResponse theBody = this._service.continueConversationForState(theElizaRequest);
            aResponse.setResponse(theBody);
        }).withOpen();
    }

    private void onTeamsConversation(HttpRestServer aServer, String aBasePath) throws IOException {
        aServer.onPost(aBasePath + "/teams", (aRequest, aResponse) -> {
            ServerSessionElizaResponse theResponse;
            TeamsConversationRequest theTeamsRequest = aRequest.getRequest(TeamsConversationRequest.class);
            if (!this._isQuiet) {
                LOGGER.info("Received continue conversation state request \"" + theTeamsRequest.getText() + "\" for provided state...");
            }
            String theSessionId = theTeamsRequest.getConversation().getId();
            String theMessage = theTeamsRequest.toMessage();
            if (this._service.hasConversationSession(theSessionId)) {
                theResponse = this._service.continueConversationForSession(theSessionId, theMessage);
            } else {
                ArrayList<Locale> theAcceptLanguages = new ArrayList<Locale>();
                theAcceptLanguages.add(theTeamsRequest.toLocale());
                if (aRequest.getHeaderFields().getAcceptLanguages() != null) {
                    theAcceptLanguages.addAll(aRequest.getHeaderFields().getAcceptLanguages());
                }
                theResponse = this._service.createConversationSession(theAcceptLanguages, theSessionId, theMessage);
            }
            aResponse.setResponse(new TeamsConversationResponse(theResponse.getAnswer()));
        }).withOpen();
    }

    private void onHttpException(HttpRestServer aServer) {
        aServer.onHttpException((RestRequestEvent restRequestEvent, HttpServerResponse httpServerResponse, Exception aException, HttpStatusCode aHttpStatusCode) -> {
            if (!this._isQuiet) {
                LOGGER.warn("Got a <" + aException.getClass().getSimpleName() + "> exception, responding with HTTP-Status-Code <" + String.valueOf(aHttpStatusCode) + "> (" + aHttpStatusCode.getStatusCode() + "> as of: " + Trap.asMessage(aException));
            }
        });
    }
}

