/*
 * Decompiled with CFR 0.152.
 */
package club.funcodes.autochat;

import java.util.regex.Pattern;
import org.refcodes.runtime.SystemProperty;

public enum Language {
    DEFAULT("english", "eliza.script", "you", new String[]{"exit", "bye", "quit"}),
    DE("german", "eliza-de.script", "du", new String[]{"exit", "bye", "quit", "servus", "tsch\u00fcss", "tschau"}),
    EN("emglish", "eliza-en.script", "you", new String[]{"exit", "bye", "quit"});

    private String _scriptName;
    private String _you;
    private String _languageName;
    private String[] _exitKeyWords;

    private Language(String aLanguageName, String aScriptName, String youWord, String[] exitKeyWords) {
        this._languageName = aLanguageName;
        this._scriptName = aScriptName;
        this._you = youWord;
        this._exitKeyWords = exitKeyWords;
    }

    public String getScriptName() {
        return this._scriptName;
    }

    public String you() {
        return this._you;
    }

    public String getLanguageName() {
        return this._languageName;
    }

    public String[] getExitKeywords() {
        return this._exitKeyWords;
    }

    public boolean isExitKeyword(String aMessage) {
        if (aMessage != null && aMessage.length() != 0) {
            aMessage = aMessage.trim();
            aMessage = aMessage.replaceAll(Pattern.quote("!"), "").replaceAll(Pattern.quote("."), "");
            for (String eKeyWord : this._exitKeyWords) {
                if (!eKeyWord.equalsIgnoreCase(aMessage)) continue;
                return true;
            }
        }
        return false;
    }

    public static Language toUserLanguage() {
        String theUserLang = SystemProperty.USER_LANGUAGE.getValue();
        if (theUserLang != null && theUserLang.length() != 0) {
            theUserLang = theUserLang.trim().toUpperCase();
        }
        for (Language eLang : Language.values()) {
            if (!eLang.name().equalsIgnoreCase(theUserLang)) continue;
            return eLang;
        }
        return DEFAULT;
    }
}

