/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.security;

import java.io.IOException;
import java.io.InputStream;
import org.refcodes.mixin.Disposable;
import org.refcodes.security.Decrypter;
import org.refcodes.security.DecryptionException;

public class DecryptionInputStream
extends InputStream
implements Disposable {
    private InputStream _inputStream;
    private Decrypter<byte[], byte[], DecryptionException> _decrypter;

    public DecryptionInputStream(InputStream aInputStream, Decrypter<byte[], byte[], DecryptionException> aDecrypter) {
        this._inputStream = aInputStream;
        this._decrypter = aDecrypter;
    }

    @Override
    public int available() throws IOException {
        return this._inputStream.available();
    }

    public boolean equals(Object aObj) {
        return this._inputStream.equals(aObj);
    }

    public int hashCode() {
        return this._inputStream.hashCode();
    }

    @Override
    public void mark(int aReadlimit) {
        this._inputStream.mark(aReadlimit);
    }

    @Override
    public boolean markSupported() {
        return this._inputStream.markSupported();
    }

    @Override
    public int read() throws IOException {
        try {
            int theRead = this._inputStream.read();
            if (theRead == -1) {
                return -1;
            }
            return Byte.toUnsignedInt(this._decrypter.toDecrypted(new byte[]{(byte)theRead})[0]);
        }
        catch (DecryptionException e) {
            throw new IllegalStateException("Encountered an illegal sate while decrypting!", e);
        }
    }

    @Override
    public int read(byte[] b) throws IOException {
        try {
            int theRead = this._inputStream.read(b);
            if (theRead == -1) {
                return -1;
            }
            this._decrypter.decrypt(b);
            return theRead;
        }
        catch (DecryptionException e) {
            throw new IllegalStateException("Encountered an illegal sate while decrypting!", e);
        }
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        try {
            int theRead = this._inputStream.read(b, off, len);
            this._decrypter.decrypt(b, off, len);
            return theRead;
        }
        catch (DecryptionException e) {
            throw new IllegalStateException("Encountered an illegal sate while decrypting!", e);
        }
    }

    @Override
    public void reset() throws IOException {
        this._inputStream.reset();
    }

    @Override
    public long skip(long aArg0) throws IOException {
        return this._inputStream.skip(aArg0);
    }

    @Override
    public void close() throws IOException {
        InputStream theInputStream;
        Decrypter<byte[], byte[], DecryptionException> theDecrypter = this._decrypter;
        if (theDecrypter != null) {
            try {
                theDecrypter.dispose();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this._decrypter = null;
        }
        if ((theInputStream = this._inputStream) != null) {
            theInputStream.close();
            this._inputStream = null;
        }
    }

    @Override
    public void dispose() {
        InputStream theInputStream;
        Decrypter<byte[], byte[], DecryptionException> theDecrypter = this._decrypter;
        if (theDecrypter != null) {
            try {
                theDecrypter.dispose();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this._decrypter = null;
        }
        if ((theInputStream = this._inputStream) != null) {
            try {
                theInputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this._inputStream = null;
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + " [inputStream=" + String.valueOf(this._inputStream) + ", decrypter=" + String.valueOf(this._decrypter) + "]";
    }
}

