/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.runtime;

import java.io.File;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import org.refcodes.data.Delimiter;
import org.refcodes.data.ExitCode;
import org.refcodes.data.Folder;
import org.refcodes.data.Scheme;
import org.refcodes.data.SleepLoopTime;
import org.refcodes.exception.Trap;
import org.refcodes.runtime.Host;
import org.refcodes.runtime.JansiHandler;
import org.refcodes.runtime.NativeImageCode;
import org.refcodes.runtime.OperatingSystem;
import org.refcodes.runtime.SystemProperty;
import org.refcodes.runtime.Terminal;
import org.refcodes.struct.Attribute;
import org.refcodes.struct.AttributeImpl;
import sun.misc.Signal;

public final class Execution {
    private static final Logger LOGGER = Logger.getLogger(Execution.class.getName());
    private static final String[] LOGGER_PACKAGE_PARTS = new String[]{".log.", ".logger.", ".logging.", "org.refcodes.struct.", "org.refcodes.properties."};
    public static final NonExistingValueClass NON_EXISTING_VALUE = new NonExistingValueClass();
    public static final String ALIAS_SET = "set";
    public static final String ALIAS_GET = "get";
    public static final String ALIAS_HAS = "has";
    public static final String ALIAS_IS = "is";
    public static final String ALIAS_TOSTRING = "toString";
    private static final String[] RESERVED_PACKAGE_PREFIXES = new String[]{"sun.", "com.sun.", "java.", "javax."};
    private static String[] MAIN_METHODS = new String[]{"main", "start", "<clinit>", "<init>"};
    private static String[] MAIN_METHOD_PREFIXES = new String[]{"test"};
    private static String[] FRAMEWORK_LAUNCHERS = new String[]{"JarLauncher", "TestRunner", "ForkedBooter"};
    private static Scheme[] JAR_PROTOCOLS = new Scheme[]{Scheme.JAR, Scheme.ZIP, Scheme.SH};
    private static final String SPACE_PLACEHOLDER = "%20";
    public static final String CTRL_C_SIGNAL = "INT";
    private static Boolean _isUnderTest = null;
    private static boolean _isAnsiInstalled = false;
    private static boolean _hasShutdownHandle = false;
    private static List<Thread> _shutdownHooks = new LinkedList<Thread>();
    private static Thread _shutdownHook;
    private static Class<?> _mainClass;
    private static File _launcherDir;
    private static final boolean _isAnsi;

    private Execution() {
    }

    public static File toLauncherDir() {
        if (_launcherDir == null) {
            Scheme eProtocol;
            String truncate;
            Object basePath;
            File theLauncherFile;
            String theLauncherDir = SystemProperty.LAUNCHER_DIR.getValue();
            if (theLauncherDir != null && theLauncherDir.length() != 0 && (theLauncherFile = new File(theLauncherDir)).exists() && theLauncherFile.isDirectory()) {
                return theLauncherFile;
            }
            Class<Execution> baseClass = Execution.getMainClass();
            if (baseClass == null) {
                baseClass = Execution.class;
            }
            if (((String)(basePath = baseClass.getProtectionDomain().getCodeSource().getLocation().getPath())).startsWith(Scheme.FILE.toProtocol())) {
                basePath = ((String)basePath).substring(Scheme.FILE.toProtocol().length());
            }
            try {
                String theCanonicalName = baseClass.getCanonicalName();
                truncate = theCanonicalName.replace('.', '/');
            }
            catch (Exception e) {
                return null;
            }
            truncate = truncate.substring(0, truncate.indexOf(baseClass.getSimpleName()));
            int endIndex = ((String)basePath).indexOf(truncate);
            if (endIndex > 0) {
                basePath = ((String)basePath).substring(0, endIndex);
            }
            if (((String)basePath).endsWith("" + Delimiter.PATH.getChar())) {
                basePath = ((String)basePath).substring(0, ((String)basePath).length() - 1);
            }
            if (((String)basePath).endsWith(Folder.CLASSES.getName())) {
                basePath = ((String)basePath).substring(0, ((String)basePath).indexOf(Folder.CLASSES.getName()));
            }
            int index = -1;
            Scheme[] schemeArray = JAR_PROTOCOLS;
            int n = schemeArray.length;
            for (int i = 0; i < n && (index = (eProtocol = schemeArray[i]).firstMarkerIndex(((String)basePath).toLowerCase())) == -1; ++i) {
            }
            if (index != -1 && (index = ((String)(basePath = ((String)basePath).substring(0, index))).lastIndexOf(Delimiter.PATH.getChar())) != -1) {
                basePath = ((String)basePath).substring(0, index);
            }
            if (!((String)basePath).endsWith("" + Delimiter.PATH.getChar())) {
                basePath = (String)basePath + Delimiter.PATH.getChar();
            }
            _launcherDir = new File((String)basePath);
            if (!((String)basePath).endsWith(Folder.TARGET.getName() + Delimiter.PATH.getChar())) {
                _launcherDir = _launcherDir.getParentFile();
            }
            if (!_launcherDir.exists() && ((String)basePath).contains(SPACE_PLACEHOLDER)) {
                basePath = ((String)basePath).replaceAll(Matcher.quoteReplacement(SPACE_PLACEHOLDER), " ");
                _launcherDir = new File((String)basePath);
                if (!((String)basePath).endsWith(Folder.TARGET.getName() + Delimiter.PATH.getChar())) {
                    _launcherDir = _launcherDir.getParentFile();
                }
            }
        }
        return _launcherDir;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Class getMainClass() {
        if (_mainClass != null) return _mainClass;
        Class<Host> clazz = Host.class;
        synchronized (Host.class) {
            Class<?> mainClass;
            StackTraceElement eElement;
            StackTraceElement[] stack = Thread.currentThread().getStackTrace();
            ArrayList<StackTraceElement> theCandidates = new ArrayList<StackTraceElement>();
            for (StackTraceElement aStack : stack) {
                eElement = aStack;
                if (!Execution.hasTestAnnotation(eElement)) continue;
                theCandidates.add(eElement);
            }
            for (int i = stack.length - 1; i > 0; --i) {
                eElement = stack[i];
                for (String eMain : MAIN_METHODS) {
                    if (!eElement.getMethodName().equals(eMain)) continue;
                    theCandidates.add(eElement);
                }
                for (String ePrefix : MAIN_METHOD_PREFIXES) {
                    if (!eElement.getMethodName().startsWith(ePrefix)) continue;
                    theCandidates.add(eElement);
                }
            }
            block11: for (StackTraceElement eCandidate : theCandidates) {
                for (String eLauncer : FRAMEWORK_LAUNCHERS) {
                    if (eCandidate.getClassName().toLowerCase().contains(eLauncer.toLowerCase())) continue block11;
                }
                try {
                    mainClass = Class.forName(eCandidate.getClassName());
                    if (mainClass.getProtectionDomain().getCodeSource() == null) continue;
                    _mainClass = mainClass;
                    // ** MonitorExit[var0] (shouldn't be in output)
                    return _mainClass;
                }
                catch (ClassNotFoundException classNotFoundException) {
                }
            }
            for (StackTraceElement eCandidate : theCandidates) {
                try {
                    mainClass = Class.forName(eCandidate.getClassName());
                    if (mainClass.getProtectionDomain().getCodeSource() == null) continue;
                    _mainClass = mainClass;
                    // ** MonitorExit[var0] (shouldn't be in output)
                    return _mainClass;
                }
                catch (ClassNotFoundException classNotFoundException) {
                }
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return _mainClass;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void addShutdownHook(Thread hook) {
        Object object;
        if (!_shutdownHooks.contains(hook)) {
            _shutdownHooks.add(0, hook);
        }
        if (_shutdownHook == null) {
            object = _shutdownHooks;
            synchronized (object) {
                if (_shutdownHook == null) {
                    _shutdownHook = new Thread(() -> {
                        for (Thread t : _shutdownHooks) {
                            try {
                                t.run();
                            }
                            catch (Exception e) {
                                LOGGER.log(Level.WARNING, "Encountered erroneous shutdown hook <" + String.valueOf(t) + "> as of: " + Trap.asMessage(e), e);
                            }
                        }
                    });
                    _shutdownHook.setDaemon(true);
                    Runtime.getRuntime().addShutdownHook(_shutdownHook);
                }
            }
        }
        if (_hasShutdownHandle || !Execution.isNativeImage()) return;
        object = Host.class;
        synchronized (Host.class) {
            if (_hasShutdownHandle) return;
            _hasShutdownHandle = true;
            try {
                Signal.handle(new Signal(CTRL_C_SIGNAL), signal -> System.exit(ExitCode.CONTROL_C.getStatusCode()));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void addShutdownHook(Runnable hook) {
        Runtime.getRuntime().addShutdownHook(new Thread(hook));
        if (_hasShutdownHandle || !Execution.isNativeImage()) return;
        Class<Host> clazz = Host.class;
        synchronized (Host.class) {
            if (_hasShutdownHandle) return;
            _hasShutdownHandle = true;
            Signal.handle(new Signal(CTRL_C_SIGNAL), signal -> System.exit(ExitCode.CONTROL_C.getStatusCode()));
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public static void setJulLoggingHandler(Handler aHandler) {
        LogManager.getLogManager().reset();
        Logger theRootLogger = LogManager.getLogManager().getLogger("");
        theRootLogger.addHandler(aHandler);
    }

    public static void setJulLoggingStreams(final OutputStream aStdStream, final OutputStream aErrStream, final Level aLevel) {
        Execution.setJulLoggingHandler(new Handler(){
            PrintWriter _stdWriter;
            PrintWriter _errWriter;
            {
                this._stdWriter = new PrintWriter(aStdStream);
                this._errWriter = new PrintWriter(aErrStream);
            }

            @Override
            public void publish(LogRecord aRecord) {
                if (aRecord.getLevel().intValue() >= aLevel.intValue()) {
                    Throwable theThrown = aRecord.getThrown();
                    String theLine = String.valueOf(aRecord.getLevel()) + ": " + Trap.asMessage(aRecord.getMessage(), aRecord.getParameters());
                    if (theThrown != null && theThrown.getMessage() != null) {
                        theLine = theLine + " (" + theThrown.getMessage() + ")";
                    }
                    if (aRecord.getLevel().intValue() > Level.INFO.intValue()) {
                        this._errWriter.println(theLine);
                        if (theThrown != null) {
                            theThrown.printStackTrace(this._errWriter);
                        }
                    } else {
                        if (theThrown == null) {
                            this._stdWriter.println(theLine);
                        } else {
                            this._errWriter.println(theLine);
                        }
                        if (theThrown != null) {
                            theThrown.printStackTrace(this._errWriter);
                        }
                    }
                }
            }

            @Override
            public void flush() {
                this._stdWriter.flush();
                this._errWriter.flush();
            }

            @Override
            public void close() {
                this._stdWriter.close();
                this._errWriter.close();
            }
        });
    }

    public static void setJulLoggingLevel(Level aLevel) {
        Logger theRootJulLogger = LogManager.getLogManager().getLogger("");
        theRootJulLogger.setLevel(aLevel);
        for (Handler e : theRootJulLogger.getHandlers()) {
            e.setLevel(aLevel);
        }
    }

    public static PrintStream toBootstrapStandardOut() {
        return new PrintStream(new FileOutputStream(FileDescriptor.out){

            @Override
            public void close() throws IOException {
            }
        });
    }

    public static PrintStream toBootstrapStandardError() {
        return new PrintStream(new FileOutputStream(FileDescriptor.err){

            @Override
            public void close() throws IOException {
            }
        });
    }

    public static InputStream toBootstrapStandardIn() {
        return new FileInputStream(FileDescriptor.in){

            @Override
            public void close() throws IOException {
            }
        };
    }

    public static PrintStream toSystemOut() {
        return OperatingSystem.toOperatingSystem() == OperatingSystem.WINDOWS && !Execution.isUnderTest() ? Execution.toAnsiOut() : new PrintStream(System.out){

            @Override
            public void close() {
            }
        };
    }

    public static PrintStream toSystemErr() {
        return OperatingSystem.toOperatingSystem() == OperatingSystem.WINDOWS && !Execution.isUnderTest() ? Execution.toAnsiErr() : new PrintStream(System.err){

            @Override
            public void close() {
            }
        };
    }

    public static boolean isNativeImage() {
        return NativeImageCode.isRuntime();
    }

    public static boolean isUnderTest() {
        block4: {
            if (_isUnderTest != null) {
                return _isUnderTest;
            }
            if (SystemProperty.LOG_TESTS.isEnabled()) {
                return true;
            }
            if (SystemProperty.LOG_DEBUG.isEnabled()) {
                return true;
            }
            StackTraceElement[] theStackTrace = Thread.currentThread().getStackTrace();
            List<StackTraceElement> theList = Arrays.asList(theStackTrace);
            for (StackTraceElement eElement : theList) {
                if (!eElement.getClassName().startsWith("org.junit.") && !eElement.getClassName().startsWith("org.testng.")) continue;
                _isUnderTest = true;
                break block4;
            }
            _isUnderTest = false;
        }
        return _isUnderTest;
    }

    public static String toStackTrace() {
        StringWriter theStringWriter = new StringWriter();
        new Throwable("").printStackTrace(new PrintWriter(theStringWriter));
        return theStringWriter.toString();
    }

    public static StackTraceElement getCallerStackTraceElement() {
        StackTraceElement[] theStackTraceElements;
        for (StackTraceElement eStackTraceElement : theStackTraceElements = Thread.currentThread().getStackTrace()) {
            if (Execution.isSkipStackTraceElement(eStackTraceElement)) continue;
            return eStackTraceElement;
        }
        return null;
    }

    public static StackTraceElement getCallerStackTraceElement(Class<?> aCallee) {
        return Execution.getCallerStackTraceElement(aCallee.getName());
    }

    public static StackTraceElement getCallerStackTraceElement(StackTraceElement aCallee) {
        return Execution.getCallerStackTraceElement(aCallee.getClassName());
    }

    public static StackTraceElement getCallerStackTraceElement(Class<?> ... aCallees) {
        StackTraceElement eCaller = null;
        for (Class<?> eClallee : aCallees) {
            eCaller = Execution.getCallerStackTraceElement(eClallee);
            if (eCaller == null) continue;
            return eCaller;
        }
        return null;
    }

    public static StackTraceElement getCallerStackTraceElement(StackTraceElement ... aCallees) {
        StackTraceElement eCaller = null;
        for (StackTraceElement eClallee : aCallees) {
            eCaller = Execution.getCallerStackTraceElement(eClallee);
            if (eCaller == null) continue;
            return eCaller;
        }
        return null;
    }

    public static StackTraceElement getCallerStackTraceElement(String ... aCalleeClassNames) {
        StackTraceElement eCaller = null;
        for (String eClallee : aCalleeClassNames) {
            eCaller = Execution.getCallerStackTraceElement(eClallee);
            if (eCaller == null) continue;
            return eCaller;
        }
        return null;
    }

    public static StackTraceElement getCallerStackTraceElement(String aCalleeClassName) {
        StackTraceElement[] theStackTraceElements = Thread.currentThread().getStackTrace();
        boolean hasCalleeElement = false;
        for (StackTraceElement eStackTraceElement : theStackTraceElements) {
            if (hasCalleeElement && !eStackTraceElement.getClassName().startsWith(aCalleeClassName)) {
                return eStackTraceElement;
            }
            if (!eStackTraceElement.getClassName().startsWith(aCalleeClassName)) continue;
            hasCalleeElement = true;
        }
        return null;
    }

    private static boolean hasReservedPackagePrefix(StackTraceElement aCaller) {
        String theClassName = aCaller.getClassName();
        for (String ePrefix : RESERVED_PACKAGE_PREFIXES) {
            if (!theClassName.startsWith(ePrefix)) continue;
            return true;
        }
        return false;
    }

    public static StackTraceElement toHeurisitcCallerStackTraceElement(String aCalleeClassName) {
        StackTraceElement theStackTraceElement;
        StackTraceElement eStackTraceElement = theStackTraceElement = Execution.getCallerStackTraceElement(aCalleeClassName);
        while (eStackTraceElement != null && Execution.hasReservedPackagePrefix(eStackTraceElement)) {
            eStackTraceElement = Execution.getCallerStackTraceElement(eStackTraceElement);
        }
        return eStackTraceElement != null ? eStackTraceElement : theStackTraceElement;
    }

    public static StackTraceElement toHeurisitcCallerStackTraceElement(StackTraceElement aCallee) {
        return Execution.toHeurisitcCallerStackTraceElement(aCallee.getClassName());
    }

    public static StackTraceElement toHeurisitcCallerStackTraceElement(Class<?> aCallee) {
        return Execution.toHeurisitcCallerStackTraceElement(aCallee.getName());
    }

    public static StackTraceElement toHeurisitcCallerStackTraceElement(String[] aCallees) {
        for (String e : aCallees) {
            StackTraceElement eStackTraceElement = Execution.toHeurisitcCallerStackTraceElement(e);
            if (eStackTraceElement == null) continue;
            return eStackTraceElement;
        }
        return null;
    }

    public static StackTraceElement toHeurisitcCallerStackTraceElement(StackTraceElement[] aCallees) {
        for (StackTraceElement e : aCallees) {
            StackTraceElement eStackTraceElement = Execution.toHeurisitcCallerStackTraceElement(e);
            if (eStackTraceElement == null) continue;
            return eStackTraceElement;
        }
        return null;
    }

    public static StackTraceElement toHeurisitcCallerStackTraceElement(Class<?>[] aCallees) {
        for (Class<?> e : aCallees) {
            StackTraceElement eStackTraceElement = Execution.toHeurisitcCallerStackTraceElement(e);
            if (eStackTraceElement == null) continue;
            return eStackTraceElement;
        }
        return null;
    }

    public static Class<?> getCallerType() {
        StackTraceElement theStackTraceElement = Execution.getCallerStackTraceElement();
        return Execution.toClass(theStackTraceElement);
    }

    public static Class<?> getCallerType(Class<?> aCallee) {
        StackTraceElement theStackTraceElement = Execution.getCallerStackTraceElement(aCallee);
        return Execution.toClass(theStackTraceElement);
    }

    public static Class<?> getCallerType(Class<?> ... aCallees) {
        StackTraceElement theStackTraceElement = Execution.getCallerStackTraceElement(aCallees);
        return Execution.toClass(theStackTraceElement);
    }

    public static Class<?> getCallerType(StackTraceElement aCallee) {
        StackTraceElement theStackTraceElement = Execution.getCallerStackTraceElement(aCallee);
        return Execution.toClass(theStackTraceElement);
    }

    public static Class<?> getCallerType(String ... aCallees) {
        StackTraceElement theStackTraceElement = Execution.getCallerStackTraceElement(aCallees);
        return Execution.toClass(theStackTraceElement);
    }

    public static Class<?> getCallerType(String aCallee) {
        StackTraceElement theStackTraceElement = Execution.getCallerStackTraceElement(aCallee);
        return Execution.toClass(theStackTraceElement);
    }

    public static Class<?> getCallerType(StackTraceElement ... aCallees) {
        StackTraceElement theStackTraceElement = Execution.getCallerStackTraceElement(aCallees);
        return Execution.toClass(theStackTraceElement);
    }

    public static Class<?> toClass(StackTraceElement aStackTraceElement) {
        try {
            return Class.forName(aStackTraceElement.getClassName());
        }
        catch (ClassNotFoundException e) {
            throw new InternalError(e);
        }
    }

    public static String toMethodName(StackTraceElement aStackTraceElement) {
        if (aStackTraceElement == null) {
            return null;
        }
        return aStackTraceElement.getMethodName();
    }

    public static String toClassName(StackTraceElement aStackTraceElement) {
        if (aStackTraceElement == null) {
            return null;
        }
        return Execution.toClassName(aStackTraceElement.getClassName());
    }

    public static String toFullyQualifiedClassName(StackTraceElement aStackTraceElement) {
        if (aStackTraceElement == null) {
            return null;
        }
        return aStackTraceElement.getClassName();
    }

    public static String toFullyQualifiedMethodName(StackTraceElement aStackTraceElement) {
        if (aStackTraceElement == null) {
            return null;
        }
        return aStackTraceElement.getClassName() + Delimiter.METHOD_NAME.getChar() + aStackTraceElement.getMethodName();
    }

    public static String toFullyQualifiedClassName() {
        StackTraceElement theStackTraceElement = Execution.getCallerStackTraceElement();
        return theStackTraceElement.getClassName();
    }

    public static String toFullyQualifiedMethodName() {
        StackTraceElement theStackTraceElement = Execution.getCallerStackTraceElement();
        return theStackTraceElement.getClassName() + Delimiter.METHOD_NAME.getChar() + theStackTraceElement.getMethodName();
    }

    public static String toMethodName() {
        StackTraceElement theStackTraceElement = Execution.getCallerStackTraceElement();
        return theStackTraceElement.getMethodName();
    }

    public static String toClassName() {
        return Execution.toClassName(Execution.toFullyQualifiedClassName());
    }

    public static String toFullyQualifiedPackageName() {
        return Execution.toFullyQualifiedPackageName(Execution.toFullyQualifiedClassName());
    }

    public static String toFullyQualifiedPackageName(StackTraceElement aStackTraceElement) {
        return Execution.toFullyQualifiedPackageName(Execution.toFullyQualifiedClassName(aStackTraceElement));
    }

    public static String toClassName(String aFullyQualifiedClassName) {
        int theClassIndex = aFullyQualifiedClassName.lastIndexOf(46);
        String theClassName = theClassIndex != -1 ? aFullyQualifiedClassName.substring(theClassIndex + 1) : aFullyQualifiedClassName;
        int theInnerClassIndex = theClassName.indexOf(36);
        if (theInnerClassIndex != -1) {
            theClassName = theClassName.substring(theInnerClassIndex + 1);
        }
        return theClassName;
    }

    public static String toFullyQualifiedPackageName(String aFullyQualifiedClassName) {
        int theIndex = aFullyQualifiedClassName.lastIndexOf(46);
        if (theIndex != -1) {
            return aFullyQualifiedClassName.substring(0, theIndex);
        }
        return "";
    }

    public static <T> T toClone(T aObj) throws CloneNotSupportedException {
        if (aObj instanceof Cloneable) {
            try {
                return (T)aObj.getClass().getMethod("clone", new Class[0]).invoke(aObj, new Object[0]);
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                throw new CloneNotSupportedException(Trap.asMessage(e));
            }
        }
        throw new CloneNotSupportedException("The type \"" + aObj.getClass().getName() + "}\" does not implement the \"" + Cloneable.class.getName() + "\" interface.");
    }

    public static String toString(String aToString, String aSuperToString) {
        return aToString + " (" + aSuperToString + ")";
    }

    public static Set<Annotation> annotations(Class<?> aClass) {
        return Execution.annotations(aClass.getAnnotations(), new HashSet<Annotation>());
    }

    public static Set<Annotation> annotations(Field aField) {
        return Execution.annotations(aField.getAnnotations(), new HashSet<Annotation>());
    }

    public static Set<Annotation> annotations(Method aMethod) {
        return Execution.annotations(aMethod.getAnnotations(), new HashSet<Annotation>());
    }

    public static Set<Annotation> annotations(Object aObj) {
        return Execution.annotations(aObj.getClass().getAnnotations(), new HashSet<Annotation>());
    }

    public static Annotation findAnnotation(Class<? extends Annotation> aAnnotation, Class<?> aClass) {
        return Execution.findAnnotation(aAnnotation, aClass.getAnnotations(), new HashSet<Annotation>());
    }

    public static Annotation findAnnotation(Class<? extends Annotation> aAnnotation, Field aField) {
        return Execution.findAnnotation(aAnnotation, aField.getAnnotations(), new HashSet<Annotation>());
    }

    public static Annotation findAnnotation(Class<? extends Annotation> aAnnotation, Method aMethod) {
        return Execution.findAnnotation(aAnnotation, aMethod.getAnnotations(), new HashSet<Annotation>());
    }

    public static Annotation findAnnotation(Class<? extends Annotation> aAnnotation, Object aObj) {
        return Execution.findAnnotation(aAnnotation, aObj.getClass().getAnnotations(), new HashSet<Annotation>());
    }

    public static boolean hasAnnotation(Class<? extends Annotation> aAnnotation, Class<?> aClass) {
        return Execution.hasAnnotation(aAnnotation, aClass.getAnnotations(), new HashSet<Annotation>());
    }

    public static boolean hasAnnotation(Class<? extends Annotation> aAnnotation, Field aField) {
        return Execution.hasAnnotation(aAnnotation, aField.getAnnotations(), new HashSet<Annotation>());
    }

    public static boolean hasAnnotation(Class<? extends Annotation> aAnnotation, Method aMethod) {
        return Execution.hasAnnotation(aAnnotation, aMethod.getAnnotations(), new HashSet<Annotation>());
    }

    public static boolean hasAnnotation(Class<? extends Annotation> aAnnotation, Object aObj) {
        return Execution.hasAnnotation(aAnnotation, aObj.getClass().getAnnotations(), new HashSet<Annotation>());
    }

    public static boolean hasGetterAttribute(Object anObject, String anAttributeName, Class<?> aReturnType) {
        Method[] theMethodArray = anObject.getClass().getMethods();
        try {
            for (Method aTheMethodArray : theMethodArray) {
                if (aTheMethodArray.getParameterTypes().length != 0 || !aTheMethodArray.getReturnType().equals(aReturnType)) continue;
                String theMethodName = aTheMethodArray.getName();
                if (aTheMethodArray.getModifiers() != 1 && aTheMethodArray.getModifiers() != 9 || !(theMethodName.indexOf(ALIAS_GET) == 0 && Character.isUpperCase(theMethodName.charAt(ALIAS_GET.length())) ? anAttributeName.equalsIgnoreCase(theMethodName = theMethodName.substring(ALIAS_GET.length(), theMethodName.length())) : (theMethodName.indexOf(ALIAS_HAS) == 0 && Character.isUpperCase(theMethodName.charAt(ALIAS_HAS.length())) ? anAttributeName.equalsIgnoreCase(theMethodName = theMethodName.substring(ALIAS_HAS.length(), theMethodName.length())) : (theMethodName.indexOf(ALIAS_IS) == 0 && Character.isUpperCase(theMethodName.charAt(ALIAS_IS.length())) ? anAttributeName.equalsIgnoreCase(theMethodName = theMethodName.substring(ALIAS_IS.length(), theMethodName.length())) : theMethodName.indexOf(ALIAS_TOSTRING) == 0 && Character.isUpperCase(theMethodName.charAt(ALIAS_TOSTRING.length())) && anAttributeName.equalsIgnoreCase(theMethodName = theMethodName.substring(ALIAS_TOSTRING.length(), theMethodName.length())))))) continue;
                return true;
            }
        }
        catch (Exception exc) {
            System.err.println("ReflectionUtility.setAttribute(): Caught an exception of aClass <" + exc.getClass().getName() + "> with message = " + exc.getMessage() + ".");
            exc.printStackTrace();
        }
        return false;
    }

    public static boolean hasSetterAttribute(Object anObject, String anAttributeName, Class<?> anAttributeType) {
        Method[] theMethodArray = anObject.getClass().getMethods();
        try {
            for (Method aTheMethodArray : theMethodArray) {
                if (aTheMethodArray.getParameterTypes().length != 1 || !aTheMethodArray.getParameterTypes()[0].isAssignableFrom(anAttributeType) || !aTheMethodArray.getReturnType().equals(Void.TYPE)) continue;
                String theMethodName = aTheMethodArray.getName();
                if (aTheMethodArray.getModifiers() != 1 && aTheMethodArray.getModifiers() != 9 || theMethodName.indexOf(ALIAS_SET) != 0 || !Character.isUpperCase(theMethodName.charAt(ALIAS_SET.length())) || !anAttributeName.equalsIgnoreCase(theMethodName = theMethodName.substring(ALIAS_SET.length(), theMethodName.length()))) continue;
                return true;
            }
        }
        catch (Exception exc) {
            System.err.println("ReflectionUtility.setAttribute(): Caught an exception of aClass <" + exc.getClass().getName() + "> with message = " + exc.getMessage() + ".");
            exc.printStackTrace();
        }
        return false;
    }

    public static void setAttribute(Object anObject, Attribute anAttributeValueStruct) throws NoSuchMethodException {
        Execution.setAttribute(anObject, (String)anAttributeValueStruct.getKey(), anAttributeValueStruct.getValue());
    }

    public static void setAttribute(Object anObject, String anAttributeName, Object anAttributeValue) throws NoSuchMethodException {
        boolean isCalled = false;
        Method[] theMethodArray = anObject.getClass().getMethods();
        try {
            for (Method aTheMethodArray : theMethodArray) {
                if (aTheMethodArray.getParameterTypes().length != 1 || !aTheMethodArray.getParameterTypes()[0].isAssignableFrom(anAttributeValue.getClass()) || !aTheMethodArray.getReturnType().equals(Void.TYPE)) continue;
                String theMethodName = aTheMethodArray.getName();
                if (aTheMethodArray.getModifiers() != 1 && aTheMethodArray.getModifiers() != 9 || theMethodName.indexOf(ALIAS_SET) != 0 || !Character.isUpperCase(theMethodName.charAt(ALIAS_SET.length())) || !anAttributeName.equalsIgnoreCase(theMethodName = theMethodName.substring(ALIAS_SET.length(), theMethodName.length()))) continue;
                try {
                    aTheMethodArray.invoke(anObject, anAttributeValue);
                    isCalled = true;
                }
                catch (Exception e) {
                    System.err.println("ReflectionUtility.setAttribute(): Caught an exception of aClass <" + e.getClass().getName() + "> while invoking the method <" + theMethodName + "> with message = " + e.getMessage() + ".");
                    e.printStackTrace();
                }
                break;
            }
        }
        catch (Exception exc) {
            System.err.println("ReflectionUtility.setAttribute(): Caught an exception of aClass <" + exc.getClass().getName() + "> with message = " + exc.getMessage() + ".");
            exc.printStackTrace();
        }
        if (!isCalled) {
            throw new NoSuchMethodException("ReflectionUtility.setAttribute(): The method for the attribute <" + anAttributeName + "> for the class <" + anObject.getClass().getName() + "> cannot be found.");
        }
    }

    @SafeVarargs
    protected static boolean containsDir(File aDir, List<File> ... aDirs) {
        for (List<File> eDirs : aDirs) {
            if (!eDirs.contains(aDir)) continue;
            return true;
        }
        return false;
    }

    private static boolean hasTestAnnotation(StackTraceElement aElement) {
        try {
            Method[] methods;
            Class<?> aClass = Class.forName(aElement.getClassName());
            String methodName = aElement.getMethodName();
            for (Method method : methods = aClass.getMethods()) {
                Annotation[] eAnnotations;
                if (!method.getName().equals(methodName)) continue;
                for (Annotation eAnnotation : eAnnotations = method.getDeclaredAnnotations()) {
                    String theSimpleName = eAnnotation.annotationType().getSimpleName();
                    if (!"Test".equals(theSimpleName)) continue;
                    return true;
                }
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return false;
    }

    private static boolean isSkipStackTraceElement(StackTraceElement aStackTraceElement) {
        return aStackTraceElement.getClassName().equals(Thread.class.getName()) || aStackTraceElement.getClassName().equals(Execution.class.getName()) || aStackTraceElement.getLineNumber() <= 1;
    }

    private static PrintStream toAnsiOut() {
        if (!_isAnsi) {
            return System.out;
        }
        Execution.doInstallAnsi();
        return new PrintStream(JansiHandler.toAnsiOut()){

            @Override
            public void close() {
            }
        };
    }

    private static PrintStream toAnsiErr() {
        if (!_isAnsi) {
            return System.err;
        }
        Execution.doInstallAnsi();
        return new PrintStream(JansiHandler.toAnsiErr()){

            @Override
            public void close() {
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void doInstallAnsi() {
        if (!_isAnsi || _isAnsiInstalled) return;
        Class<Execution> clazz = Execution.class;
        synchronized (Execution.class) {
            if (_isAnsiInstalled) return;
            JansiHandler.systemInstall();
            try {
                Thread theHook = new Thread(() -> {
                    try {
                        Execution.doUninstallAnsi();
                    }
                    catch (Error | Exception throwable) {
                        // empty catch block
                    }
                });
                theHook.setDaemon(true);
                Execution.addShutdownHook(theHook);
            }
            catch (Exception exception) {
                // empty catch block
            }
            _isAnsiInstalled = true;
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    private static void doUninstallAnsi() {
        if (!_isAnsi) {
            return;
        }
        try {
            Thread.sleep(SleepLoopTime.MIN.getTimeMillis());
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        Execution.toSystemOut().flush();
        Execution.toSystemErr().flush();
        JansiHandler.systemUninstall();
    }

    public static Attribute[] toBeanAttributes(Object anObject) {
        ArrayList<AttributeImpl> theAttributeValueStructList = new ArrayList<AttributeImpl>();
        Method[] theMethodArray = anObject.getClass().getMethods();
        try {
            for (Method aTheMethodArray : theMethodArray) {
                if (aTheMethodArray.getParameterTypes().length != 0 || aTheMethodArray.getReturnType().equals(Void.TYPE)) continue;
                boolean isBeanMethod = false;
                Object eInvokeReturn = NON_EXISTING_VALUE;
                String eMethodName = aTheMethodArray.getName();
                if (aTheMethodArray.getModifiers() != 1 && aTheMethodArray.getModifiers() != 9) continue;
                if (eMethodName.indexOf(ALIAS_GET) == 0 && Character.isUpperCase(eMethodName.charAt(ALIAS_GET.length()))) {
                    isBeanMethod = true;
                    eMethodName = eMethodName.substring(ALIAS_GET.length(), eMethodName.length());
                } else if (eMethodName.indexOf(ALIAS_HAS) == 0 && Character.isUpperCase(eMethodName.charAt(ALIAS_HAS.length()))) {
                    isBeanMethod = true;
                    eMethodName = eMethodName.substring(ALIAS_HAS.length(), eMethodName.length());
                } else if (eMethodName.indexOf(ALIAS_IS) == 0 && Character.isUpperCase(eMethodName.charAt(ALIAS_IS.length()))) {
                    isBeanMethod = true;
                    eMethodName = eMethodName.substring(ALIAS_IS.length(), eMethodName.length());
                } else if (eMethodName.equals(ALIAS_TOSTRING)) {
                    isBeanMethod = true;
                }
                if (!isBeanMethod) continue;
                try {
                    eInvokeReturn = aTheMethodArray.invoke(anObject, new Object[0]);
                }
                catch (Exception e) {
                    System.err.println("ReflectionUtility.setAttribute(): Caught an exception of aClass <" + e.getClass().getName() + "> while invoking the method <" + eMethodName + "> with message = " + e.getMessage() + ".");
                    e.printStackTrace();
                }
                theAttributeValueStructList.add(new AttributeImpl(eMethodName, eInvokeReturn));
            }
        }
        catch (Exception exc) {
            System.err.println("ReflectionUtility.setAttribute(): Caught an exception of aClass <" + exc.getClass().getName() + "> with message = " + exc.getMessage() + ".");
            exc.printStackTrace();
        }
        return theAttributeValueStructList.toArray(new AttributeImpl[theAttributeValueStructList.size()]);
    }

    public static StackTraceElement probeTillNoneLoggerElement(Class<?> ... aCallees) {
        StackTraceElement theCaller;
        StackTraceElement eCaller = theCaller = Execution.toHeurisitcCallerStackTraceElement(aCallees);
        while (eCaller != null && Execution.containsLoggerPackagePart(eCaller)) {
            eCaller = Execution.toHeurisitcCallerStackTraceElement(eCaller);
        }
        if (eCaller != null) {
            theCaller = eCaller;
        }
        return theCaller;
    }

    private static boolean containsLoggerPackagePart(StackTraceElement aCaller) {
        String theClassName = aCaller.getClassName();
        for (String ePart : LOGGER_PACKAGE_PARTS) {
            if (!theClassName.contains(ePart)) continue;
            return true;
        }
        return false;
    }

    private static Set<Annotation> annotations(Annotation[] aAnnotations, Set<Annotation> aVisted) {
        for (Annotation eAnno : aAnnotations) {
            if (aVisted.contains(eAnno)) continue;
            aVisted.add(eAnno);
            Execution.annotations(eAnno.annotationType().getAnnotations(), aVisted);
        }
        return aVisted;
    }

    private static Annotation findAnnotation(Class<? extends Annotation> aAnnotation, Annotation[] aAnnotations, Set<Annotation> aVisted) {
        for (Annotation eAnno : aAnnotations) {
            if (aVisted.contains(eAnno)) continue;
            if (aAnnotation.isAssignableFrom(eAnno.getClass())) {
                return eAnno;
            }
            aVisted.add(eAnno);
            Annotation result = Execution.findAnnotation(aAnnotation, eAnno.annotationType().getAnnotations(), aVisted);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    private static boolean hasAnnotation(Class<? extends Annotation> aAnnotation, Annotation[] aAnnotations, Set<Annotation> aVisted) {
        for (Annotation eAnno : aAnnotations) {
            if (aVisted.contains(eAnno)) continue;
            if (aAnnotation.isAssignableFrom(eAnno.getClass())) {
                return true;
            }
            aVisted.add(eAnno);
            if (!Execution.hasAnnotation(aAnnotation, eAnno.annotationType().getAnnotations(), aVisted)) continue;
            return true;
        }
        return false;
    }

    static {
        _mainClass = null;
        _launcherDir = null;
        _isAnsi = System.console() != null && Terminal.isAnsiTerminalEnabled();
    }

    public static class NonExistingValueClass {
    }
}

