/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.properties;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.text.ParseException;
import java.util.Map;
import org.refcodes.data.FilenameExtension;
import org.refcodes.properties.DocumentMetrics;
import org.refcodes.properties.DocumentNotation;
import org.refcodes.properties.ImmutableProperties;
import org.refcodes.properties.JavaProperties;
import org.refcodes.properties.Properties;
import org.refcodes.properties.ResourceProperties;
import org.refcodes.properties.ResourcePropertiesFactory;
import org.refcodes.runtime.ConfigLocator;

public class JavaPropertiesFactory
implements ResourcePropertiesFactory {
    private final DocumentMetrics _documentMetrics;

    public JavaPropertiesFactory() {
        this(DocumentNotation.DEFAULT);
    }

    public JavaPropertiesFactory(DocumentMetrics aDocumentMetrics) {
        this._documentMetrics = aDocumentMetrics;
    }

    @Override
    public String[] getFilenameSuffixes() {
        return new String[]{FilenameExtension.PROPERTIES.getFilenameSuffix()};
    }

    @Override
    public ResourceProperties toProperties(Class<?> aResourceClass, String aFilePath, ConfigLocator aConfigLocator) throws IOException, ParseException {
        return new JavaProperties(aResourceClass, aFilePath, aConfigLocator, this._documentMetrics);
    }

    @Override
    public ResourceProperties toProperties(File aFile, ConfigLocator aConfigLocator) throws IOException, ParseException {
        return new JavaProperties(aFile, aConfigLocator, this._documentMetrics);
    }

    @Override
    public ResourceProperties toProperties(InputStream aInputStream) throws IOException, ParseException {
        return new JavaProperties(aInputStream, this._documentMetrics);
    }

    @Override
    public ResourceProperties toProperties(Map<?, ?> aProperties) {
        return new JavaProperties(aProperties, this._documentMetrics);
    }

    @Override
    public ResourceProperties toProperties(Object aObj) {
        return new JavaProperties(aObj, this._documentMetrics);
    }

    @Override
    public ResourceProperties toProperties(ImmutableProperties aProperties) {
        return new JavaProperties(aProperties, this._documentMetrics);
    }

    @Override
    public ResourceProperties toProperties(Properties aProperties) {
        return new JavaProperties(aProperties, this._documentMetrics);
    }

    @Override
    public ResourceProperties toProperties(String aFilePath, ConfigLocator aConfigLocator) throws IOException, ParseException {
        return new JavaProperties(aFilePath, aConfigLocator, this._documentMetrics);
    }

    @Override
    public ResourceProperties toProperties(URL aUrl) throws IOException, ParseException {
        return new JavaProperties(aUrl, this._documentMetrics);
    }
}

