/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.numerical;

import org.refcodes.exception.UnhandledEnumBugException;
import org.refcodes.numerical.NumericalUtility;

public enum Endianess {
    LITTLE,
    BIG;


    public byte[] toBytes(long aValue, int aLength) {
        return switch (this.ordinal()) {
            default -> throw new MatchException(null, null);
            case 1 -> NumericalUtility.toBigEndianBytes(aValue, aLength);
            case 0 -> NumericalUtility.toLittleEndianBytes(aValue, aLength);
        };
    }

    public byte[] toBytes(long aValue) {
        return switch (this.ordinal()) {
            case 1 -> NumericalUtility.toBigEndianBytes(aValue);
            case 0 -> NumericalUtility.toLittleEndianBytes(aValue);
            default -> throw new UnhandledEnumBugException(this);
        };
    }

    public byte[] toBytes(int aValue, int aLength) {
        return switch (this.ordinal()) {
            case 1 -> NumericalUtility.toBigEndianBytes(aValue, aLength);
            case 0 -> NumericalUtility.toLittleEndianBytes(aValue, aLength);
            default -> throw new UnhandledEnumBugException(this);
        };
    }

    public byte[] toBytes(int aValue) {
        return switch (this.ordinal()) {
            case 1 -> NumericalUtility.toBigEndianBytes(aValue);
            case 0 -> NumericalUtility.toLittleEndianBytes(aValue);
            default -> throw new UnhandledEnumBugException(this);
        };
    }

    public byte[] toBytes(short aValue, int aLength) {
        return switch (this.ordinal()) {
            case 1 -> NumericalUtility.toBigEndianBytes(aValue, aLength);
            case 0 -> NumericalUtility.toLittleEndianBytes(aValue, aLength);
            default -> throw new UnhandledEnumBugException(this);
        };
    }

    public byte[] toBytes(short aValue) {
        return switch (this.ordinal()) {
            case 1 -> NumericalUtility.toBigEndianBytes(aValue);
            case 0 -> NumericalUtility.toLittleEndianBytes(aValue);
            default -> throw new UnhandledEnumBugException(this);
        };
    }

    public byte[] toBytes(float aValue) {
        return switch (this.ordinal()) {
            case 1 -> NumericalUtility.toBigEndianBytes(aValue);
            case 0 -> NumericalUtility.toLittleEndianBytes(aValue);
            default -> throw new UnhandledEnumBugException(this);
        };
    }

    public byte[] toBytes(double aValue) {
        return switch (this.ordinal()) {
            case 1 -> NumericalUtility.toBigEndianBytes(aValue);
            case 0 -> NumericalUtility.toLittleEndianBytes(aValue);
            default -> throw new UnhandledEnumBugException(this);
        };
    }

    public byte[] toUnsignedBytes(long aValue, int aLength) {
        return switch (this.ordinal()) {
            case 1 -> NumericalUtility.toUnsignedBigEndianBytes(aValue, aLength);
            case 0 -> NumericalUtility.toUnsignedLittleEndianBytes(aValue, aLength);
            default -> throw new UnhandledEnumBugException(this);
        };
    }

    public byte[] toUnsignedBytes(long aValue) {
        return switch (this.ordinal()) {
            case 1 -> NumericalUtility.toUnsignedBigEndianBytes(aValue);
            case 0 -> NumericalUtility.toUnsignedLittleEndianBytes(aValue);
            default -> throw new UnhandledEnumBugException(this);
        };
    }

    public byte[] toUnsignedBytes(int aValue) {
        return switch (this.ordinal()) {
            case 1 -> NumericalUtility.toUnsignedBigEndianBytes(aValue);
            case 0 -> NumericalUtility.toUnsignedLittleEndianBytes(aValue);
            default -> throw new UnhandledEnumBugException(this);
        };
    }

    public byte[] toUnsignedBytes(short aValue) {
        return switch (this.ordinal()) {
            case 1 -> NumericalUtility.toUnsignedBigEndianBytes(aValue);
            case 0 -> NumericalUtility.toUnsignedLittleEndianBytes(aValue);
            default -> throw new UnhandledEnumBugException(this);
        };
    }

    public long toLong(byte[] aBytes) {
        return switch (this.ordinal()) {
            case 1 -> NumericalUtility.toLongFromBigEndianBytes(aBytes);
            case 0 -> NumericalUtility.toLongFromLittleEndianBytes(aBytes);
            default -> throw new UnhandledEnumBugException(this);
        };
    }

    public long toUnsignedLong(byte[] aBytes) {
        return switch (this.ordinal()) {
            case 1 -> NumericalUtility.toUnsignedLongFromBigEndianBytes(aBytes);
            case 0 -> NumericalUtility.toUnsignedLongFromLittleEndianBytes(aBytes);
            default -> throw new UnhandledEnumBugException(this);
        };
    }

    public int toInteger(byte[] aBytes) {
        return switch (this.ordinal()) {
            case 1 -> NumericalUtility.toIntFromBigEndianBytes(aBytes);
            case 0 -> NumericalUtility.toIntFromLittleEndianBytes(aBytes);
            default -> throw new UnhandledEnumBugException(this);
        };
    }

    public int toUnsignedInteger(byte[] aBytes) {
        return switch (this.ordinal()) {
            case 1 -> NumericalUtility.toUnsignedIntFromBigEndianBytes(aBytes);
            case 0 -> NumericalUtility.toUnsignedIntFromLittleEndianBytes(aBytes);
            default -> throw new UnhandledEnumBugException(this);
        };
    }

    public short toShort(byte[] aBytes) {
        return switch (this.ordinal()) {
            case 1 -> NumericalUtility.toShortFromBigEndianBytes(aBytes);
            case 0 -> NumericalUtility.toShortFromLittleEndianBytes(aBytes);
            default -> throw new UnhandledEnumBugException(this);
        };
    }

    public short toUnsignedShort(byte[] aBytes) {
        return switch (this.ordinal()) {
            case 1 -> NumericalUtility.toUnsignedShortFromBigEndianBytes(aBytes);
            case 0 -> NumericalUtility.toUnsignedShortFromLittleEndianBytes(aBytes);
            default -> throw new UnhandledEnumBugException(this);
        };
    }

    public float toFloat(byte[] aBytes) {
        return switch (this.ordinal()) {
            case 1 -> NumericalUtility.toFloatFromBigEndianBytes(aBytes);
            case 0 -> NumericalUtility.toFloatFromLittleEndianBytes(aBytes);
            default -> throw new UnhandledEnumBugException(this);
        };
    }

    public double toDouble(byte[] aBytes) {
        return switch (this.ordinal()) {
            case 1 -> NumericalUtility.toDoubleFromBigEndianBytes(aBytes);
            case 0 -> NumericalUtility.toDoubleFromLittleEndianBytes(aBytes);
            default -> throw new UnhandledEnumBugException(this);
        };
    }
}

