/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.exception;

import java.text.MessageFormat;
import java.util.Arrays;
import java.util.function.Function;
import org.refcodes.exception.ErrorCodeAccessor;
import org.refcodes.exception.MessageDetails;

public interface Trap
extends ErrorCodeAccessor {
    default public String toMessage(MessageDetails aMessageDetails) {
        return this.toMessage((Function<Throwable, String>)aMessageDetails);
    }

    default public String toMessage(Function<Throwable, String> aMessageFunction) {
        Trap trap = this;
        if (trap instanceof Throwable) {
            Throwable t = (Throwable)((Object)trap);
            return aMessageFunction.apply(t);
        }
        throw new UnsupportedOperationException("The provided type <" + this.getClass().getName() + "> is not an exception type though this method is only applicable to types extending the <" + Throwable.class.getName() + "> type)!");
    }

    default public String toMessage() {
        return this.toMessage(MessageDetails.FULL);
    }

    default public String toLocalizedMessage() {
        return this.toMessage(MessageDetails.FULL_LOCALIZED);
    }

    default public String toShortMessage() {
        return this.toMessage(MessageDetails.SHORT);
    }

    default public String toShortLocalizedMessage() {
        return this.toMessage(MessageDetails.SHORT_LOCALIZED);
    }

    default public Object[] getPatternArguments() {
        return null;
    }

    public static String asMessage(Throwable aException) {
        return MessageDetails.FULL.apply(aException);
    }

    public static String asLocalizedMessage(Throwable aException) {
        return MessageDetails.FULL_LOCALIZED.apply(aException);
    }

    public static String asShortMessage(Throwable aException) {
        return MessageDetails.SHORT.apply(aException);
    }

    public static String asShortLocalizedMessage(Throwable aException) {
        return MessageDetails.SHORT_LOCALIZED.apply(aException);
    }

    public static String asMessage(String aMessage, Throwable aException) {
        return Trap.toMessage(aMessage, aException, MessageDetails.FULL);
    }

    public static String asLocalizedMessage(String aMessage, Throwable aException) {
        return Trap.toMessage(aMessage, aException, MessageDetails.FULL_LOCALIZED);
    }

    public static String asMessage(String aMessage, Object ... aArguments) {
        if (aArguments == null || aArguments.length == 0) {
            return aMessage;
        }
        try {
            Object[] theArguments = new Object[aArguments.length];
            for (int i = 0; i < aArguments.length; ++i) {
                theArguments[i] = Trap.toString(aArguments[i], i);
            }
            return MessageFormat.format(aMessage, theArguments);
        }
        catch (IllegalArgumentException e) {
            if (aArguments == null || aArguments.length == 0) {
                return aMessage;
            }
            Object[] theArguments = new Object[aArguments.length];
            for (int i = 0; i < aArguments.length; ++i) {
                theArguments[i] = Trap.toString(aArguments[i], i);
            }
            return aMessage + " (" + Trap.toString(theArguments) + ")";
        }
    }

    private static Object toString(Object aObject, int aIndex) {
        if (aObject instanceof Object[]) {
            Object[] aObjects = (Object[])aObject;
            String theString = Trap.toString(aObjects);
            return theString.isEmpty() ? "{" + aIndex + "}" : theString;
        }
        return aObject;
    }

    private static String toString(Object[] aObjects) {
        if (aObjects != null && aObjects.length == 1) {
            String str;
            Object theString = Trap.toString(aObjects[0]);
            return theString instanceof String ? (str = (String)theString) : (theString != null ? theString.toString() : null);
        }
        Object[] theObjects = new Object[aObjects.length];
        for (int i = 0; i < theObjects.length; ++i) {
            theObjects[i] = Trap.toString(aObjects[i]);
        }
        String theString = theObjects.length == 0 ? "" : Arrays.toString(theObjects);
        return theString;
    }

    private static Object toString(Object aObject) {
        if (aObject instanceof String) {
            String theStr = (String)aObject;
            if (!(theStr.startsWith("\"") || theStr.endsWith("\"") || theStr.startsWith("[\"") || theStr.endsWith("\"]"))) {
                return "\"" + theStr + "\"";
            }
            return theStr;
        }
        if (aObject instanceof Character) {
            Character theChar = (Character)aObject;
            return "'" + theChar + "'";
        }
        return aObject;
    }

    private static String toMessage(String aMessage, Throwable aException, MessageDetails aMessageDetails) {
        String theMessage = aMessageDetails.apply(aException);
        if (theMessage != null && theMessage.length() != 0) {
            theMessage.trim();
            if (theMessage.length() != 0) {
                aMessage = (String)aMessage + " " + theMessage;
            }
        }
        return aMessage;
    }
}

