/*
 * Decompiled with CFR 0.152.
 */
package club.funcodes.ascart;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import org.refcodes.archetype.CliHelper;
import org.refcodes.cli.CasesCondition;
import org.refcodes.cli.CliSugar;
import org.refcodes.cli.DebugFlag;
import org.refcodes.cli.EnumOption;
import org.refcodes.cli.Example;
import org.refcodes.cli.HelpFlag;
import org.refcodes.cli.IntOption;
import org.refcodes.cli.StringOption;
import org.refcodes.cli.SysInfoFlag;
import org.refcodes.cli.VerboseFlag;
import org.refcodes.data.AsciiColorPalette;
import org.refcodes.data.Delimiter;
import org.refcodes.exception.BugException;
import org.refcodes.graphical.BoxBorderMode;
import org.refcodes.logger.RuntimeLogger;
import org.refcodes.logger.RuntimeLoggerFactorySingleton;
import org.refcodes.properties.ext.application.ApplicationProperties;
import org.refcodes.runtime.Execution;
import org.refcodes.runtime.Terminal;
import org.refcodes.textual.AsciiArtBuilder;
import org.refcodes.textual.Font;
import org.refcodes.textual.FontFamily;
import org.refcodes.textual.FontStyle;
import org.refcodes.textual.PixmapRatioMode;
import org.refcodes.textual.TextBorderBuilder;
import org.refcodes.textual.TextBoxStyle;
import org.refcodes.textual.VerboseTextBuilder;

public class Main {
    private static final RuntimeLogger LOGGER = RuntimeLoggerFactorySingleton.createRuntimeLogger();
    private static final String NAME = "ascart";
    private static final String TITLE = "ASC(II)ART";
    private static final String LICENSE_NOTE = "You may choose between the LGPL v3.0 or later and the Apache License v2.0 when using this software";
    private static final String COPYRIGHT = "Copyright (c) by CLUB.FUNCODES | See [https://www.metacodes.pro/manpages/ascart_manpage]";
    private static final char[] BANNER_PALETTE = AsciiColorPalette.MAX_LEVEL_GRAY.getPalette();
    private static final Font BANNER_FONT = new Font(FontFamily.DIALOG, FontStyle.BOLD);
    private static final String DESCRIPTION = "A command line tool for creating ASCII art (\"[ASC]II[ART]\") from plain text or image files (see [https://www.metacodes.pro/manpages/ascart_manpage]).";
    private static final String TEXT_PROPERTY = "text";
    private static final String OUTPUTFILE_PROPERTY = "outputFile";
    private static final String IMAGEFILE_PROPERTY = "imageFile";
    private static final String BORDER_STYLE_PROPERTY = "borderStyle";
    private static final String LINE_WIDTH_PROPERTY = "lineWidth";
    private static final String FONT_FAMILY_PROPERTY = "fontFamily";
    private static final String FONT_STYLE_PROPERTY = "fontStyle";
    private static final String COLOR_PALETTE_PROPERTY = "colorPalette";
    private static final String PADDING_PROPERTY = "padding";
    private static final String RATIO_MODE_PROPERTY = "ratioMode";
    private static final FontFamily DEFAULT_FONT_FAMILY = FontFamily.DIALOG;
    private static final FontStyle DEFAULT_FONT_STYLE = FontStyle.BOLD;
    private static final int DEFAULT_PADDING = 1;
    private static final AsciiColorPalette DEFAULT_COLOR_PALETTE = AsciiColorPalette.MAX_LEVEL_GRAY;
    private static final int DEFAULT_LINE_WIDTH = 80;
    private static final PixmapRatioMode DEFAULT_RATIO_MODE = PixmapRatioMode.CONSOLE;

    public static void main(String[] args) {
        int theDefaultLineWidth = Terminal.getWidth();
        if (theDefaultLineWidth < 0) {
            theDefaultLineWidth = 80;
        }
        EnumOption<TextBoxStyle> theBorderStyleArg = CliSugar.enumOption("border-style", TextBoxStyle.class, BORDER_STYLE_PROPERTY, "The style of the border surrounding the ASCII art: " + VerboseTextBuilder.asString(TextBoxStyle.values()));
        EnumOption<FontFamily> theFontFamilyArg = CliSugar.enumOption("font-family", FontFamily.class, FONT_FAMILY_PROPERTY, "The font family to use for the ASCII art text (defaults to <" + String.valueOf(DEFAULT_FONT_FAMILY) + ">): " + VerboseTextBuilder.asString(FontFamily.values()));
        EnumOption<FontStyle> theFontStyleArg = CliSugar.enumOption("font-style", FontStyle.class, FONT_STYLE_PROPERTY, "The font style to use for the ASCII art text (defaults to <" + String.valueOf(DEFAULT_FONT_STYLE) + ">): " + VerboseTextBuilder.asString(FontStyle.values()));
        EnumOption<AsciiColorPalette> theColorPaletteArg = CliSugar.enumOption("color-palette", AsciiColorPalette.class, COLOR_PALETTE_PROPERTY, "The color palette (chars) to use for the ASCII art (defaults to <" + String.valueOf((Object)DEFAULT_COLOR_PALETTE) + ">): " + VerboseTextBuilder.asString((Object[])AsciiColorPalette.values()));
        EnumOption<PixmapRatioMode> theRatioModeArg = CliSugar.enumOption("ratio", PixmapRatioMode.class, RATIO_MODE_PROPERTY, "The ratio mode when rendering images (defaults to <" + String.valueOf((Object)DEFAULT_RATIO_MODE) + ">): " + VerboseTextBuilder.asString((Object[])PixmapRatioMode.values()));
        StringOption theImageFileArg = CliSugar.stringOption(Character.valueOf('i'), "image-file", IMAGEFILE_PROPERTY, "The image file from which to create the ASCII art from.");
        StringOption theOutputFileArg = CliSugar.stringOption(Character.valueOf('o'), "output-file", OUTPUTFILE_PROPERTY, "The output file where to write the ASCII art to.");
        StringOption theTextArg = CliSugar.stringOption(Character.valueOf('t'), TEXT_PROPERTY, TEXT_PROPERTY, "The text message from which to create the ASCII art from.");
        IntOption theLineWidthArg = CliSugar.intOption("line-width", LINE_WIDTH_PROPERTY, "The line width to use when creating the ASCII art (defaults to current console's line width <" + theDefaultLineWidth + ">).");
        IntOption thePaddingArg = CliSugar.intOption(PADDING_PROPERTY, PADDING_PROPERTY, "The padding width to use when creating the ASCII art (defaults to <1>).");
        DebugFlag theDebugFlag = CliSugar.debugFlag();
        VerboseFlag theVerboseFlag = CliSugar.verboseFlag();
        SysInfoFlag theSysInfoFlag = CliSugar.sysInfoFlag(false);
        HelpFlag theHelpFlag = CliSugar.helpFlag();
        CasesCondition theArgsSyntax = CliSugar.cases(CliSugar.and(theTextArg, CliSugar.any(theFontFamilyArg, theFontStyleArg, theColorPaletteArg, thePaddingArg, theBorderStyleArg, theOutputFileArg, theLineWidthArg, theVerboseFlag, theDebugFlag)), CliSugar.and(theImageFileArg, CliSugar.any(theRatioModeArg, theColorPaletteArg, thePaddingArg, theBorderStyleArg, theOutputFileArg, theLineWidthArg, theVerboseFlag, theDebugFlag)), CliSugar.xor(theHelpFlag, CliSugar.and(theSysInfoFlag, CliSugar.any(theVerboseFlag))));
        Example[] theExamples = CliSugar.examples(CliSugar.example("Render text with current console's width", theTextArg), CliSugar.example("Render text with given width", theTextArg, theLineWidthArg), CliSugar.example("Render text with current console's width and given border", theTextArg, theBorderStyleArg), CliSugar.example("Render text with given width and border", theTextArg, theLineWidthArg, theBorderStyleArg), CliSugar.example("Render text with given width, padding and border", theTextArg, theLineWidthArg, thePaddingArg, theBorderStyleArg), CliSugar.example("Render text with given font family and font style", theTextArg, theFontFamilyArg, theFontStyleArg), CliSugar.example("Render text with given color palette", theTextArg, theColorPaletteArg), CliSugar.example("Render image with current console's width", theImageFileArg), CliSugar.example("Render image with given width", theImageFileArg, theLineWidthArg), CliSugar.example("Render image with current console's width and given border", theImageFileArg, theBorderStyleArg), CliSugar.example("Render image with given width, padding and border", theImageFileArg, theLineWidthArg, thePaddingArg, theBorderStyleArg), CliSugar.example("Render image with given width and border", theImageFileArg, theLineWidthArg, theBorderStyleArg), CliSugar.example("Render image with given color palette", theImageFileArg, theColorPaletteArg), CliSugar.example("Render image with given ration", theImageFileArg, theRatioModeArg), CliSugar.example("To show the help text", theHelpFlag), CliSugar.example("To print the system info", theSysInfoFlag));
        CliHelper theCliHelper = ((CliHelper.Builder)((CliHelper.Builder)((CliHelper.Builder)((CliHelper.Builder)((CliHelper.Builder)((CliHelper.Builder)((CliHelper.Builder)((CliHelper.Builder)((CliHelper.Builder)((CliHelper.Builder)((CliHelper.Builder)((CliHelper.Builder)((CliHelper.Builder)CliHelper.builder().withArgs(args)).withEscapeCodesEnabled(false)).withArgsSyntax(theArgsSyntax)).withExamples(theExamples)).withResourceClass((Class)Main.class)).withName(NAME)).withTitle(TITLE)).withDescription(DESCRIPTION)).withLicense(LICENSE_NOTE)).withCopyright(COPYRIGHT)).withBannerFont(BANNER_FONT)).withBannerFontPalette(BANNER_PALETTE)).withLogger(LOGGER)).build();
        ApplicationProperties theArgsProperties = theCliHelper.getApplicationProperties();
        boolean isVerbose = theCliHelper.isVerbose();
        try {
            String theText = (String)theArgsProperties.get((Object)theTextArg);
            String theImageFileName = (String)theArgsProperties.get((Object)theImageFileArg);
            String theOutputFileName = (String)theArgsProperties.get((Object)theOutputFileArg);
            TextBoxStyle theBorderStyle = theArgsProperties.getEnum(TextBoxStyle.class, (Object)theBorderStyleArg);
            int thePadding = theArgsProperties.getIntOr(thePaddingArg, (Integer)(theBorderStyle != null ? 1 : 0));
            int theLineWidth = theArgsProperties.getIntOr(theLineWidthArg, (Integer)theDefaultLineWidth);
            AsciiColorPalette theColorPalette = theArgsProperties.getEnumOr(theColorPaletteArg, DEFAULT_COLOR_PALETTE);
            FontFamily theFontFamily = theArgsProperties.getEnumOr(theFontFamilyArg, DEFAULT_FONT_FAMILY);
            FontStyle theFontStyle = theArgsProperties.getEnumOr(theFontStyleArg, DEFAULT_FONT_STYLE);
            PixmapRatioMode theRatioMode = theArgsProperties.getEnumOr(theRatioModeArg, DEFAULT_RATIO_MODE);
            if (isVerbose) {
                if (theText != null && theText.length() != 0) {
                    LOGGER.info("Text = " + theText);
                }
                if (theBorderStyle != null) {
                    LOGGER.info("Encoding = " + String.valueOf(theBorderStyle));
                }
                if (theLineWidth != -1) {
                    LOGGER.info("Line width = " + theLineWidth);
                }
                LOGGER.info("Color palette = " + String.valueOf((Object)theColorPalette));
            }
            OutputStream theOutputStream = Execution.toBootstrapStandardOut();
            if (theOutputFileName != null && theOutputFileName.length() != 0) {
                File theOutputFile = new File(theOutputFileName);
                if (isVerbose) {
                    LOGGER.info("Output file = \"" + theOutputFileName + "\" (<" + theOutputFile.getAbsolutePath() + ">)");
                }
                theOutputStream = new FileOutputStream(theOutputFile);
            }
            int theCanvasWidth = theLineWidth - thePadding * 2;
            if (theBorderStyle != null) {
                theCanvasWidth -= 2;
            }
            String[] theAsciiArt = null;
            if (theText != null) {
                if (isVerbose) {
                    LOGGER.info("Font family = " + String.valueOf(theFontFamily));
                    LOGGER.info("Font style = " + String.valueOf(theFontStyle));
                }
                theAsciiArt = ((AsciiArtBuilder)new AsciiArtBuilder().withPixmapRatioMode(theRatioMode).withAsciiColorPalette(theColorPalette).withFontSize(12).withColumnWidth(theCanvasWidth).withFontStyle(theFontStyle).withFontFamily(theFontFamily).withText(new String[]{theText})).toStrings();
            } else if (theImageFileName != null && theImageFileName.length() != 0) {
                InputStream theImageStream;
                File theImageFile = new File(theImageFileName);
                if (isVerbose) {
                    LOGGER.info("Image file = \"" + theImageFileName + "\" (<" + theImageFile.getAbsolutePath() + ">)");
                    LOGGER.info("Ratio mode = " + String.valueOf((Object)theRatioMode));
                }
                if (!theImageFile.exists() || !theImageFile.isFile()) {
                    theImageStream = Main.class.getResourceAsStream((String)(theImageFileName.startsWith("" + Delimiter.PATH.getChar()) ? theImageFileName : Delimiter.PATH.getChar() + theImageFileName));
                    if (theImageStream == null) {
                        throw new FileNotFoundException("No file \"" + theImageFileName + "\" (<" + theImageFile.getAbsolutePath() + ">) found!");
                    }
                } else {
                    theImageStream = new FileInputStream(theImageFile);
                }
                try {
                    theAsciiArt = new AsciiArtBuilder().withPixmapRatioMode(theRatioMode).withAsciiColorPalette(theColorPalette).withColumnWidth(theCanvasWidth).withImageInputStream(theImageStream).toStrings();
                }
                catch (Exception e) {
                    throw new RuntimeException("Cannot process image file <" + theImageFile.getAbsolutePath() + "> (propably wrong image format)!", e);
                }
            } else {
                throw new BugException("We encountered a bug, none argument was processed!");
            }
            if (thePadding != 0) {
                theAsciiArt = ((TextBorderBuilder)new TextBorderBuilder().withBoxBorderMode(BoxBorderMode.ALL).withText(theAsciiArt)).withBorderWidth(thePadding).withBorderChar(' ').toStrings();
            }
            if (theBorderStyle != null) {
                theAsciiArt = ((TextBorderBuilder)new TextBorderBuilder().withText(theAsciiArt)).withBoxBorderMode(BoxBorderMode.ALL).withTextBoxStyle(theBorderStyle).toStrings();
            }
            if (isVerbose) {
                LOGGER.printTail();
            }
            try (PrintWriter theWriter = new PrintWriter(theOutputStream);){
                for (int i = 0; i < theAsciiArt.length; ++i) {
                    theWriter.println(theAsciiArt[i]);
                }
            }
        }
        catch (Throwable e) {
            theCliHelper.exitOnException(e);
        }
    }
}

